/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutable;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.diag.param.HaltOnErrorParameter;
import com.sun.jade.cim.diag.param.PercentOfTestCoverageParameter;
import com.sun.jade.cim.diag.param.QuickModeParameter;
import com.sun.jade.cim.diag.param.ReportSoftErrorsParameter;
import com.sun.jade.cim.diag.param.ReportStatusMessagesParameter;
import com.sun.jade.cim.diag.param.TestWarningLevelParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.protocol.agent.AgentTest;
import com.sun.jade.device.protocol.agent.DiagnosticAbortCommand;
import com.sun.jade.device.protocol.agent.DiagnosticOutput;
import com.sun.jade.device.protocol.agent.DiagnosticRunCommand;
import com.sun.jade.device.protocol.agent.DiagnosticStatusCommand;
import com.sun.jade.device.protocol.agent.HTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class AgentTestExecutable
implements TestExecutable {
    static final String RETURN_TAG = "@ReturnCode=";
    private String command;
    private DiagnosticResult result;
    private AgentTest test;
    private ReferenceForMSE mse;
    private DiagnosticSetting setting;
    private String pid;
    private int warnLevel;
    private boolean reportStatus;
    private boolean reportErrors;
    private boolean haltOnError;
    private boolean isQuick;
    private int percentCover = 100;
    private int POLL_INTERVAL = 10000;
    private int TIMEOUT = 3600000;
    private boolean abort;
    private static final String sccs_id = "@(#)AgentTestExecutable.java\t1.0 06/17/02 SMI";

    AgentTestExecutable(AgentTest agentTest, ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        this.test = agentTest;
        this.mse = referenceForMSE;
        this.setting = diagnosticSetting;
    }

    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        this.result = diagnosticResult;
        HTTPConnection hTTPConnection = new HTTPConnection(this.test.getHost(), this.test.getPort());
        String string = this.mse.getKeyValue();
        DiagnosticRunCommand diagnosticRunCommand = new DiagnosticRunCommand(string, this.test.getTestName());
        this.parseSettings(diagnosticRunCommand);
        String string2 = hTTPConnection.sendCommand(diagnosticRunCommand);
        if (string2 == null || string2.indexOf("OK") == -1) {
            diagnosticResult.setFinalResults(TestState.FAILED, "Could not start test on Agent");
            return;
        }
        int n = string2.indexOf("OK");
        diagnosticResult.setTestState(TestState.IN_PROGRESS);
        this.pid = string2.substring(n + 2);
        if (this.pid != null) {
            this.pid = this.pid.trim();
        }
        this.monitorTest();
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        int n;
        DiagnosticAbortCommand diagnosticAbortCommand;
        boolean bl = false;
        this.abort = true;
        HTTPConnection hTTPConnection = new HTTPConnection(this.test.getHost(), this.test.getPort());
        String string = hTTPConnection.sendCommand(diagnosticAbortCommand = new DiagnosticAbortCommand(this.pid));
        if (string != null && (n = string.indexOf("OK")) > 0) {
            bl = true;
            this.notify();
        }
        return bl;
    }

    public DiagnosticSetting getDiagnosticSetting() {
        return this.setting;
    }

    public ReferenceForMSE getMSE() {
        return this.mse;
    }

    public ReferenceForMSE getExclusiveMSE() {
        return this.mse;
    }

    private void monitorTest() {
        HTTPConnection hTTPConnection = new HTTPConnection(this.test.getHost(), this.test.getPort());
        DiagnosticStatusCommand diagnosticStatusCommand = new DiagnosticStatusCommand(this.pid);
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = l + (long)this.TIMEOUT;
        do {
            try {
                Thread.sleep(this.POLL_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.abort) {
                this.result.setFinalResults(TestState.STOPPED, "Test aborted");
                return;
            }
            DiagnosticOutput diagnosticOutput = new DiagnosticOutput(hTTPConnection.sendCommand(diagnosticStatusCommand));
            String string = diagnosticOutput.getProperty("info.status");
            if ("C".equals(string)) {
                this.result.addTestResults(diagnosticOutput.getOutput());
                String string2 = diagnosticOutput.getProperty("process.0.rc").trim();
                if ("0".equals(string2)) {
                    this.result.setFinalResults(TestState.PASSED);
                } else {
                    this.result.setFinalResults(TestState.FAILED);
                }
                bl = true;
                continue;
            }
            if (System.currentTimeMillis() <= l2) continue;
            this.result.addTestResults("Test timed out. Aborting...");
            try {
                this.abortTest();
            }
            catch (DiagnosticException diagnosticException) {
                this.result.setFinalResults(TestState.FAILED);
                bl = true;
            }
        } while (!bl);
    }

    private void parseSettings(DiagnosticRunCommand diagnosticRunCommand) {
        this.reportStatus = this.setting.getReportStatusMessagesValue();
        this.reportErrors = this.setting.getReportSoftErrorsValue();
        this.haltOnError = this.setting.getHaltOnErrorValue();
        Vector vector = this.setting.getTestParameters();
        int n = 0;
        while (n < vector.size()) {
            TestParameter testParameter = (TestParameter)vector.get(n);
            if (!(testParameter instanceof HaltOnErrorParameter || testParameter instanceof ReportSoftErrorsParameter || testParameter instanceof ReportStatusMessagesParameter || testParameter instanceof TestWarningLevelParameter || testParameter instanceof QuickModeParameter || testParameter instanceof PercentOfTestCoverageParameter)) {
                diagnosticRunCommand.addOption(testParameter.getName(), testParameter.getCurrentValue().toString());
            }
            ++n;
        }
    }

    private String getLine(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                int n;
                if ((n = inputStream.read()) == 13) {
                    continue;
                }
                if (n != 10 && n != -1) {
                    stringBuffer.append((char)n);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

