/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;

public class DiagnosticOutput {
    private Properties p;
    private StringBuffer diagOutput;
    public static final String sccs_id = "@(#)DiagnosticOutput.java\t1.2 09/05/02 SMI";

    public DiagnosticOutput(String string) {
        this.parse(new BufferedReader(new StringReader(string)));
    }

    public DiagnosticOutput(BufferedReader bufferedReader) {
        this.parse(bufferedReader);
    }

    public String getProperty(String string) {
        return this.p.getProperty(string);
    }

    public String getOutput() {
        return this.diagOutput.toString();
    }

    private void parse(BufferedReader bufferedReader) {
        this.p = new Properties();
        this.diagOutput = new StringBuffer();
        boolean bl = false;
        try {
            String string;
            while (null != (string = bufferedReader.readLine())) {
                if (bl) {
                    if (string.startsWith("#Done")) continue;
                    this.diagOutput.append(string + "\n");
                    continue;
                }
                if (string.startsWith("#")) {
                    if (!string.startsWith("#OUTPUT")) continue;
                    bl = true;
                    continue;
                }
                int n = string.indexOf("\t");
                if (n <= 0 || n >= string.length() - 1) continue;
                this.p.setProperty(string.substring(0, n), string.substring(n + 1));
            }
        }
        catch (IOException iOException) {
            Report.error.log(iOException, (Object)"Error reading properties");
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#<pre>\n");
            stringBuffer.append("info.command\tcommand_name\n");
            stringBuffer.append("info.pid\t1234\n");
            stringBuffer.append("process.0.rc\t0\n");
            stringBuffer.append("#OUTPUT 0\n");
            stringBuffer.append("test output\n");
            stringBuffer.append("#Done\n");
            DiagnosticOutput diagnosticOutput = new DiagnosticOutput(new BufferedReader(new StringReader(stringBuffer.toString())));
            this.assertEquals(diagnosticOutput.getProperty("info.command"), "command_name");
            this.assertEquals(diagnosticOutput.getOutput(), "test output\n");
        }
    }

    public static interface Info {
        public static final String returnCode = "process.0.rc";
        public static final String status = "info.status";
        public static final String pid = "info.pid";
    }
}

