/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.agent;

import com.sun.jade.device.protocol.agent.AgentCommand;
import com.sun.jade.device.protocol.agent.HTTPException;
import com.sun.jade.device.protocol.http.SimpleHostnameVerifier;
import com.sun.jade.device.protocol.http.SimpleTrustManager;
import com.sun.jade.util.log.Report;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import sun.misc.BASE64Encoder;

public class HTTPConnection {
    private String host;
    private int port;
    private String request;
    private String user;
    private String password;
    public static String CLIENT_ROOT = "/rashttp?GO=Client::";
    public static String LIST_REQUEST = CLIENT_ROOT + "InstrReport::list";
    public static String DATA_REQUEST = CLIENT_ROOT + "InstrReport::report&key=";
    public static String HBA_REPORT = CLIENT_ROOT + "HBA::report";
    public static String DISCO_LIST = CLIENT_ROOT + "Discovery::list";
    public static String HTTP_TAG = "HTTP_TAG";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    private static int DEFAULT_TIMEOUT = 5;
    public static final int INVALID_RESPONSE = -2;
    private int responseCode = -2;
    private boolean abortConnection;
    private IOException connectException;
    private boolean connecting;
    private static final String sccs_id = "@(#)HTTPConnection.java  1.5 04/30/01 SMI";

    public HTTPConnection(String string, int n) {
        this.host = string;
        this.port = n;
        this.user = "peer";
        this.password = "peer";
    }

    public HTTPConnection(String string, int n, String string2, String string3) {
        this.host = string;
        this.port = n;
        this.user = string2;
        this.password = string3;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public synchronized String get(String string) throws HTTPException, IOException {
        return this.get(string, DEFAULT_TIMEOUT);
    }

    public synchronized String get(String string, int n) throws HTTPException, IOException {
        new AbortTimer(this, n).start();
        String string2 = null;
        try {
            string2 = this.getData(string, HTTPS_PROTOCOL);
        }
        catch (Exception exception) {
            try {
                string2 = this.getData(string, HTTP_PROTOCOL);
            }
            catch (Exception exception2) {
                throw new HTTPException("Both HTTPS and HTTP failed: " + exception2.toString());
            }
        }
        return string2;
    }

    private String getData(String string, String string2) throws HTTPException, IOException {
        String string3;
        HttpURLConnection httpURLConnection = null;
        Report.debug.log(HTTP_TAG, (Object)("Attempting to connect to " + this.host + " on port " + this.port + " with " + string2));
        httpURLConnection = this.openConnection(string, string2);
        this.responseCode = -2;
        try {
            httpURLConnection.setRequestMethod("GET");
        }
        catch (ProtocolException protocolException) {
            throw new HTTPException("Protocol Exception");
        }
        httpURLConnection.setDoOutput(false);
        httpURLConnection.setDoInput(true);
        this.waitForConnection(httpURLConnection);
        InputStream inputStream = httpURLConnection.getInputStream();
        if (inputStream == null) {
            throw new HTTPException("Failure getting the Input stream");
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string4 = new String("");
        while ((string3 = bufferedReader.readLine()) != null) {
            string4 = string4 + string3 + "\n";
        }
        this.responseCode = httpURLConnection.getResponseCode();
        Report.debug.log(HTTP_TAG, (Object)("The connection response code is " + this.responseCode));
        httpURLConnection.disconnect();
        if (this.responseCode == 200) {
            return string4;
        }
        Report.error.log(HTTP_TAG, (Object)("There was a failure connecting to the agent: " + this.responseCode));
        throw new HTTPException("Communication Error: " + this.responseCode);
    }

    private HttpURLConnection openConnection(String string, String string2) throws HTTPException, ConnectException {
        HttpURLConnection httpURLConnection;
        block7: {
            URL uRL = null;
            this.abort();
            try {
                uRL = new URL(string2, this.host, this.port, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new HTTPException("MalformedURLException" + malformedURLException.toString());
            }
            String string3 = this.user + ":" + this.password;
            String string4 = new BASE64Encoder().encode(string3.getBytes());
            httpURLConnection = null;
            try {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestProperty("Authorization", "Basic " + string4);
                httpURLConnection.setAllowUserInteraction(false);
                httpURLConnection.setUseCaches(false);
                if (!httpURLConnection.getURL().toString().startsWith(HTTPS_PROTOCOL)) break block7;
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
                try {
                    TrustManager[] trustManagerArray = new TrustManager[]{new SimpleTrustManager()};
                    SSLContext sSLContext = SSLContext.getInstance("TLS");
                    sSLContext.init(null, trustManagerArray, null);
                    httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
                    httpsURLConnection.setHostnameVerifier(new SimpleHostnameVerifier(this.host));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new HTTPException("Security exception" + noSuchAlgorithmException.toString());
                }
                catch (KeyManagementException keyManagementException) {
                    throw new HTTPException("Security exception" + keyManagementException.toString());
                }
            }
            catch (IOException iOException) {
                throw new HTTPException("Could not create the connection" + iOException.toString());
            }
        }
        return httpURLConnection;
    }

    public synchronized String sendRequest(String string) {
        return this.sendRequest(string, DEFAULT_TIMEOUT);
    }

    public synchronized String sendRequest(String string, int n) {
        String string2 = null;
        try {
            string2 = this.get(string, n);
        }
        catch (HTTPException hTTPException) {
            Report.warning.log("Comm error making http request: " + hTTPException.toString());
        }
        catch (IOException iOException) {
            Report.warning.log("IO error getting http response: " + iOException.toString());
        }
        return string2;
    }

    public String sendCommand(AgentCommand agentCommand) {
        return this.sendRequest(agentCommand.getRequest());
    }

    public synchronized void abort() {
        if (this.connecting) {
            this.abortConnection = true;
            this.notifyAll();
        }
    }

    private synchronized void connected(HttpURLConnection httpURLConnection, IOException iOException) {
        this.connectException = iOException;
        this.connecting = false;
        this.notifyAll();
    }

    private void waitForConnection(HttpURLConnection httpURLConnection) throws IOException, HTTPException {
        this.abortConnection = false;
        this.connectException = null;
        this.connecting = true;
        ConnectThread connectThread = new ConnectThread(httpURLConnection);
        connectThread.start();
        while (this.connecting) {
            if (this.abortConnection) {
                this.connecting = false;
                throw new HTTPException("Connection aborted");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.connecting = false;
        if (this.connectException != null) {
            throw this.connectException;
        }
    }

    public static void usage() {
        System.out.println("\nusage <host> <port> <request>");
        System.out.println("Host is the IP address of the StorAde2.0 host.");
        System.out.println("Port is the port on the indicated host");
        System.out.println("Request type: list or device key");
    }

    public static void main(String[] stringArray) {
        HTTPConnection hTTPConnection = null;
        String string = null;
        if (stringArray.length < 3) {
            HTTPConnection.usage();
            System.exit(-1);
        } else if (stringArray.length == 3) {
            if ("list".equals(stringArray[2])) {
                hTTPConnection = new HTTPConnection(stringArray[0], Integer.parseInt(stringArray[1]));
                string = LIST_REQUEST;
            } else {
                hTTPConnection = new HTTPConnection(stringArray[0], Integer.parseInt(stringArray[1]));
                string = DATA_REQUEST + stringArray[2];
            }
            System.out.println("\nHTTP query: " + string + "\n");
        }
        try {
            String string2 = hTTPConnection.get(string);
            System.out.print(string2);
        }
        catch (HTTPException hTTPException) {
            hTTPException.printStackTrace();
            hTTPException.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            iOException.toString();
        }
    }

    private class ConnectThread
    extends Thread {
        private IOException ce = null;
        HttpURLConnection connection;

        ConnectThread(HttpURLConnection httpURLConnection) {
            this.connection = httpURLConnection;
        }

        public void run() {
            try {
                this.connection.connect();
            }
            catch (IOException iOException) {
                this.ce = iOException;
            }
            HTTPConnection.this.connected(this.connection, this.ce);
        }
    }

    private class AbortTimer
    extends Thread {
        int seconds;
        HTTPConnection c;

        AbortTimer(HTTPConnection hTTPConnection2, int n) {
            this.seconds = n;
            this.c = hTTPConnection2;
        }

        public void run() {
            try {
                AbortTimer.sleep(this.seconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.c.abort();
        }
    }
}

