/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.protocol.snmp;

import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Report;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpSession;

public class SingleSnmpSession {
    private static SnmpSession snmp_Session = null;
    private static SnmpSession asyncsnmp_Session = null;
    private static final String LOG_TAG = "MIB";
    private static final String SNMP_RETRIES = "snmp.retries";
    private static final String SNMP_TIMEOUT = "snmp.timeout";
    public static final String SNMP_PROPERTIES_FILENAME = "SNMP.properties";
    public static final String sccs_id = "@(#)SingleSnmpSession.java\t1.2 10/22/02 SMI";

    private void SingleSnmpSession() {
    }

    public static SnmpSession getSnmpSession() {
        try {
            if (snmp_Session == null) {
                snmp_Session = new SnmpSession("SyncManager session");
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            Report.error.log(snmpStatusException.getLocalizedMessage());
        }
        return snmp_Session;
    }

    public static SnmpSession getAsyncSnmpSession() {
        try {
            if (asyncsnmp_Session == null) {
                asyncsnmp_Session = new SnmpSession("Async SyncManager session");
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            Report.error.log(snmpStatusException.getLocalizedMessage());
        }
        return asyncsnmp_Session;
    }

    public static void destroySnmpSession() {
        if (snmp_Session != null) {
            snmp_Session.destroySession();
        }
    }

    public static void destroyAsyncSnmpSession() {
        if (asyncsnmp_Session != null) {
            asyncsnmp_Session.destroySession();
        }
    }

    public static SnmpPeer newSnmpPeer(String string) throws UnknownHostException {
        SnmpPeer snmpPeer = new SnmpPeer(string);
        int n = 3;
        int n2 = 3000;
        try {
            Properties properties = PropertiesPersister.restoreProperties(SNMP_PROPERTIES_FILENAME);
            n = Integer.parseInt(properties.getProperty(SNMP_RETRIES));
            n2 = Integer.parseInt(properties.getProperty(SNMP_TIMEOUT));
        }
        catch (Exception exception) {
            Report.warning.log(exception.getLocalizedMessage(), (Object)"Error reading SNMP properties. Using defaults.");
        }
        snmpPeer.setMaxTries(n);
        snmpPeer.setTimeout(n2);
        return snmpPeer;
    }
}

