/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.test;

import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.StaticString;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class TestMF
extends AbstractMF
implements ReportGenerator {
    private int timeout = 0;
    private int numInst = 0;
    private Properties p;
    private static final String sccs_id = "@(#)TestMF.java\t1.7 09/25/02 SMI";

    public TestMF(Properties properties) {
        super(properties);
        this.p = properties;
        String string = properties.getProperty("realtype");
        if (string == null) {
            Report.error.log("realtype property missing");
        } else {
            properties.setProperty("type", string);
        }
        this.setDeviceReport(this);
        try {
            String string2 = properties.getProperty("timeout");
            if (string2 != null) {
                this.timeout = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getClassName() {
        return this.p.getProperty("class");
    }

    public String getName() {
        String string = this.p.getProperty("key");
        if (string == null) {
            return this.p.getProperty("name");
        }
        return string;
    }

    public LocalizedMessage getCaption() {
        String string = this.p.getProperty("logicalName");
        if (string == null) {
            return null;
        }
        return new StaticString(string);
    }

    public LocalizedMessage getDescription() {
        String string = this.p.getProperty("description");
        if (string == null) {
            return null;
        }
        return new StaticString(string);
    }

    public synchronized String generateReport() {
        Object object;
        File file = new File(this.p.getProperty("file"));
        ++this.numInst;
        String string = this.p.getProperty("altfile");
        if (string != null) {
            int n = 2;
            int n2 = 1;
            object = this.p.getProperty("altstart");
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
            if ((object = this.p.getProperty("altskip")) != null) {
                n2 = Integer.parseInt((String)object);
            }
            if (this.numInst >= n && (this.numInst - n) % (n2 + 1) == 0) {
                file = new File(string);
                Report.debug.log("Agent", (Object)("generating " + string));
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(file);
            object = new char[1024];
            while ((n = fileReader.read((char[])object)) != -1) {
                String string2 = new String((char[])object, 0, n);
                stringBuffer.append(string2);
            }
            fileReader.close();
        }
        catch (IOException iOException) {
            Report.error.log(iOException, (Object)"Error reading report");
            return "<report ReturnCode='FAILURE'><error>" + iOException.toString() + "</error></report>";
        }
        if (this.timeout > 0) {
            try {
                this.wait(this.timeout * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    public static void usage() {
        System.out.println("Usage TestMF [options] <properties>");
        System.out.println("Options:");
        System.out.println("Properties:");
        System.out.println("file=/tmp/report.xml  : Name of file to read in report.");
        System.out.println("class=CIM_System      : Name of class to return.");
        System.out.println("realtype=t3           : The real type that the test MF is emulating.");
        System.out.println("name=Fake Switch      : Name of device to return.");
        System.out.println("altFile=altreport.xml : Report with something changed.");
        System.out.println("altStart=2            : When to start using alt report.");
        System.out.println("altSkip=1             : Number of normal reports between alt reports.");
        System.out.println("timeout=0             : Seconds to wait before returning report.");
    }

    public static void main(String[] stringArray) {
        try {
            Properties properties = new Properties();
            properties.setProperty("type", "test");
            if (stringArray.length == 0) {
                TestMF.usage();
                System.exit(0);
            }
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf("=");
                if (n2 <= 0) {
                    System.err.println("Bad arg " + stringArray[n]);
                    System.exit(1);
                }
                properties.setProperty(stringArray[n].substring(0, n2), stringArray[n].substring(n2 + 1));
                ++n;
            }
            TestMF testMF = new TestMF(properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

