/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.apps.command.DebugCommand;
import com.sun.jade.apps.discovery.InstallerService;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceHandler;
import com.sun.jade.logic.mf.MF;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class DebugInst
implements DebugCommand {
    public static final String CMD_ROOT = "/jade/debug/instrumentation";
    public static final String sccs_id = "@(#)DebugInst.java\t1.3 11/08/02 SMI";

    public String getHelp() {
        return "Print state of device instrumentation code.";
    }

    public int execute(Properties properties, PrintWriter printWriter) throws IOException {
        DeviceHandler deviceHandler = DeviceHandler.getDeviceHandler();
        String string = properties.getProperty("cmd");
        if ("poll".equals(string)) {
            String string2 = properties.getProperty("name");
            if (string2 == null) {
                deviceHandler.poll();
                printWriter.println("Finished Polling all");
            } else {
                deviceHandler.poll(string2);
                printWriter.println("Finished Polling " + string2);
            }
        } else if ("report".equals(string)) {
            deviceHandler.debugReport(printWriter);
        } else {
            this.printUsage(printWriter);
        }
        return 0;
    }

    private void printUsage(PrintWriter printWriter) throws IOException {
        printWriter.println("<H1>Instrumentation</H1>");
        printWriter.println("Commands:<UL>");
        printWriter.println("<LI>Internal debug <A HREF=\"/jade/debug/instrumentation?cmd=report\">report</A>");
        printWriter.println("<LI>Instrument everything <A HREF=\"/jade/debug/instrumentation?cmd=poll\">now</A>");
        printWriter.println("<LI>Instrument device:<UL>");
        String string = InstallerServiceFinder.getCurrentDomain();
        InstallerService installerService = InstallerServiceFinder.getInstallerService(string);
        MF[] mFArray = installerService.getInstalledSystems();
        int n = 0;
        while (n < mFArray.length) {
            String string2 = mFArray[n].getName();
            String string3 = mFArray[n].getClassName();
            printWriter.print("<LI><A HREF=\"/jade/debug/instrumentation?cmd=poll&name=");
            printWriter.print(string2);
            printWriter.print("\">");
            printWriter.println(string3 + "." + string2);
            printWriter.print("</A>");
            ++n;
        }
        printWriter.println("</UL>");
        printWriter.println("</UL>");
    }
}

