/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.device.util.DeviceHandlerInterface;
import com.sun.jade.device.util.DeviceReportExceptionParser;
import com.sun.jade.device.util.ReportParser;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.logic.service.StorAdeService;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class DeviceHandler
implements DeviceHandlerInterface,
StorAdeService {
    private Timer timer;
    private int pollInterval;
    private boolean override;
    private Vector handlers = new Vector();
    private static long HANG_TIME = 300000L;
    private static final int MILLS_IN_SECOND = 1000;
    private static final int MAX_THREADS = 10;
    private String status;
    private static DeviceHandler deviceHandler;
    private PollingTask polling;
    private Vector devs = new Vector();
    private DeviceList instList = new DeviceList();
    private DeviceList parseList = new DeviceList();
    private Parser parser = new Parser();
    public static final String sccs_id = "@(#)DeviceHandler.java\t1.26 12/06/02 SMI";

    public static synchronized DeviceHandler getDeviceHandler() {
        return deviceHandler;
    }

    public static void addDevice(ReportGenerator reportGenerator, AbstractMF abstractMF) {
        DeviceHandler deviceHandler = DeviceHandler.getDeviceHandler();
        if (deviceHandler != null) {
            deviceHandler.addDevice(new DeviceItem(reportGenerator, abstractMF));
        }
    }

    public void monitorDevice(ReportGenerator reportGenerator, AbstractMF abstractMF) {
        this.addDevice(new DeviceItem(reportGenerator, abstractMF));
    }

    public void removeDevice(AbstractMF abstractMF) {
        int n = 0;
        while (n < this.devs.size()) {
            DeviceItem deviceItem = (DeviceItem)this.devs.get(n);
            if (deviceItem.mf == abstractMF) {
                this.devs.remove(n);
                this.instList.removeDevice(abstractMF);
                this.parseList.removeDevice(abstractMF);
                return;
            }
            ++n;
        }
    }

    public void parseReport(AbstractMF abstractMF, String string) {
        this.parseList.addDevice(new DeviceItem(abstractMF, string));
    }

    public void stopPolling() {
        this.timer.cancel();
        this.timer = null;
        this.polling = null;
    }

    public void startPolling() {
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.polling = new PollingTask();
            this.timer.schedule((TimerTask)this.polling, 0L, (long)this.pollInterval);
        }
    }

    public void poll() {
        this.polling.run();
    }

    public void poll(String string) {
        int n = 0;
        while (n < this.devs.size()) {
            DeviceItem deviceItem = (DeviceItem)this.devs.get(n);
            String string2 = deviceItem.mf.getName();
            if (string.equals(string2)) {
                deviceItem.lastInstStart = System.currentTimeMillis();
                deviceItem.report = deviceItem.gen.generateReport();
                deviceItem.lastInst = System.currentTimeMillis();
                this.parseList.addDevice(deviceItem);
            }
            ++n;
        }
    }

    public void updatePollingInterval(int n) {
        if (this.timer == null) {
            this.pollInterval = n;
        } else {
            this.stopPolling();
            this.pollInterval = n;
            this.startPolling();
        }
    }

    private synchronized void addDevice(DeviceItem deviceItem) {
        this.devs.add(deviceItem);
        this.instList.addDevice(deviceItem);
        if (DeviceHandler.deviceHandler.devs.size() < 10) {
            Instrumentation instrumentation = new Instrumentation();
            this.handlers.add(instrumentation);
            instrumentation.start();
        }
    }

    private boolean doInstrumentaion(DeviceItem deviceItem) {
        String string = deviceItem.mf.getClassName();
        long l = this.pollInterval;
        Properties properties = DevInfo.getDeviceProperties(deviceItem.mf);
        String string2 = properties.getProperty("REPORT_INTERVAL");
        if (string2 != null && !this.override) {
            try {
                l = Integer.parseInt(string2) * 1000;
            }
            catch (Throwable throwable) {
                Report.error.log(throwable, (Object)("Error parsing REPORT_INTERVAL for " + string));
            }
        }
        return System.currentTimeMillis() > l + deviceItem.lastInst;
    }

    public static DeviceHandler getService(Properties properties) {
        if (deviceHandler == null) {
            deviceHandler = new DeviceHandler(properties);
        }
        return deviceHandler;
    }

    private DeviceHandler(Properties properties) {
        String string = properties.getProperty("device_polling_interval");
        this.pollInterval = Integer.parseInt(string) * 1000;
        DeviceConfig deviceConfig = StoradeEnvironment.getDeviceConfig();
        String string2 = deviceConfig.getProperty("device_polling_interval");
        if (string2 != null) {
            this.override = true;
            this.pollInterval = Integer.parseInt(string2) * 1000;
        }
        Report.debug.log("Agent", (Object)("Polling interval set at " + this.pollInterval / 1000 + " seconds."));
        this.parser.start();
    }

    public String getInterfaceName() {
        return "DeviceHandler";
    }

    public String getName() {
        return "StorADE Device Handler";
    }

    public boolean isStarted() {
        return this.timer != null;
    }

    public String getStatus() {
        return this.status;
    }

    public void startService() throws StorAdeException {
        this.startPolling();
        this.status = "OK";
    }

    public void stopService() throws StorAdeException {
        this.stopPolling();
        this.status = "Stopped";
    }

    synchronized void debugReport(PrintWriter printWriter) {
        Object object;
        printWriter.println("<H1>Device Handler Debug Report</H1>");
        printWriter.println("Timer = " + this.timer);
        printWriter.println("pollInterval = " + this.pollInterval / 1000);
        if (this.polling != null) {
            printWriter.println("last polling = " + new Date(this.polling.lastPoll));
        }
        printWriter.println("override = " + this.override);
        printWriter.println("status = " + this.status);
        printWriter.println("<H2>Device Data</H2>");
        printWriter.println("devs : <UL>");
        Iterator iterator = this.devs.iterator();
        while (iterator.hasNext()) {
            object = (DeviceItem)iterator.next();
            printWriter.print("<LI>");
            this.debugDevItem((DeviceItem)object, printWriter);
        }
        printWriter.println("</UL>");
        printWriter.println("<H2>Instrumentation Data</H2>");
        printWriter.println("Instrumentation list size = " + this.instList.size());
        printWriter.println("Number of Instrumentation Threads = " + this.handlers.size());
        printWriter.println("<UL>");
        iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            object = (Instrumentation)iterator.next();
            if (!((Instrumentation)object).doRun) {
                printWriter.println("<LI>Thread has been shut down.");
            } else if (((Instrumentation)object).di == null) {
                printWriter.println("<LI>Thread is idle.");
            } else {
                printWriter.println("<LI>Instrumenting device ");
                this.debugDevItem(((Instrumentation)object).di, printWriter);
            }
            if (((Instrumentation)object).lastError == null) continue;
            printWriter.println("<LI>Last Instrumentation Error this thread:");
            ((Instrumentation)object).lastError.printStackTrace(printWriter);
        }
        printWriter.println("</UL>");
        printWriter.println("<H2>Parser Data</H2>");
        printWriter.println("Parse list size = " + this.parseList.size());
        if (this.parser.di == null) {
            printWriter.println("Waiting for device to parse.");
        } else {
            printWriter.println("Parsing device ");
            this.debugDevItem(this.parser.di, printWriter);
        }
        if (this.parser.lastError != null) {
            printWriter.println("Last Parser error:");
            this.parser.lastError.printStackTrace(printWriter);
        }
    }

    private void debugDevItem(DeviceItem deviceItem, PrintWriter printWriter) {
        if (deviceItem == null) {
            printWriter.println("null");
            return;
        }
        String string = deviceItem.mf.getName();
        String string2 = deviceItem.mf.getClassName();
        printWriter.print("<A HREF=\"/jade/debug/device?name=");
        printWriter.print(string);
        printWriter.print("\">");
        printWriter.print(string2 + "." + string);
        printWriter.println("</a><UL>");
        if (deviceItem.isNew) {
            printWriter.println("<LI>New Device");
        }
        printWriter.println("<LI>Status: isRunning = " + deviceItem.isRunning + "    isHung = " + deviceItem.isHung);
        printWriter.println("<LI>Last Inst Start = " + new Date(deviceItem.lastInstStart));
        if (deviceItem.lastInst < deviceItem.lastInstStart) {
            printWriter.println("<LI>In progress");
        } else {
            printWriter.println("<LI>Last Inst Finish = " + new Date(deviceItem.lastInst));
        }
        if (deviceItem.startParse > deviceItem.lastInstStart) {
            printWriter.println("<LI>Last Parse Start = " + new Date(deviceItem.startParse));
            if (deviceItem.lastParse < deviceItem.startParse) {
                printWriter.println("<LI>In progress");
            } else {
                printWriter.println("<LI>Last Parse Finish = " + new Date(deviceItem.lastParse));
            }
        }
        printWriter.println("</UL>");
    }

    private String getParserReport() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.parser.di != null) {
                stringBuffer.append("Parsed Device: " + this.parser.di.mf.getName() + "\n");
            } else {
                stringBuffer.append("Parsed Device: null\n");
            }
            stringBuffer.append("Current Time: " + System.currentTimeMillis() + "\n");
            stringBuffer.append("preHang Time: " + this.parser.preHangTime + "\n");
            stringBuffer.append("isPreHung: " + this.parser.isPreHung + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private class DeviceList {
        private LinkedList list = new LinkedList();
        private LinkedList newList = new LinkedList();

        private DeviceList() {
        }

        synchronized DeviceItem getDevice() {
            while (this.list.size() == 0 && this.newList.size() == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.newList.size() > 0) {
                return (DeviceItem)this.newList.removeFirst();
            }
            return (DeviceItem)this.list.removeFirst();
        }

        synchronized void addDevice(DeviceItem deviceItem) {
            if (deviceItem.getIsNew()) {
                this.newList.add(deviceItem);
            } else {
                this.list.add(deviceItem);
            }
            this.notifyAll();
        }

        synchronized void removeDevice(AbstractMF abstractMF) {
            DeviceItem deviceItem;
            Iterator iterator = this.newList.iterator();
            while (iterator.hasNext()) {
                deviceItem = (DeviceItem)iterator.next();
                if (deviceItem.mf != abstractMF) continue;
                this.list.remove(deviceItem);
                return;
            }
            iterator = this.list.iterator();
            while (iterator.hasNext()) {
                deviceItem = (DeviceItem)iterator.next();
                if (deviceItem.mf != abstractMF) continue;
                this.list.remove(deviceItem);
                return;
            }
        }

        int size() {
            return this.list.size() + this.newList.size();
        }
    }

    private static class DeviceItem {
        ReportGenerator gen;
        AbstractMF mf;
        String report;
        boolean isNew;
        boolean isHung;
        boolean isRunning;
        long lastInstStart;
        long lastInst;
        long startParse;
        long lastParse;

        DeviceItem(ReportGenerator reportGenerator, AbstractMF abstractMF) {
            this.gen = reportGenerator;
            this.mf = abstractMF;
            this.isNew = true;
        }

        DeviceItem(AbstractMF abstractMF, String string) {
            this.mf = abstractMF;
            this.isNew = true;
            this.report = string;
        }

        public void setIsNew(boolean bl) {
            this.isNew = bl;
        }

        public boolean getIsNew() {
            return this.isNew;
        }
    }

    private class Parser
    extends Thread {
        private boolean doRun = true;
        Throwable lastError;
        ReportParser rp = new ReportParser();
        DeviceReportExceptionParser drep = new DeviceReportExceptionParser();
        DeviceItem di;
        boolean isPreHung;
        long preHangTime;

        private Parser() {
        }

        public synchronized void abort() {
            this.doRun = false;
        }

        public synchronized boolean isRunning() {
            return this.doRun;
        }

        public void run() {
            while (this.doRun) {
                this.di = DeviceHandler.this.parseList.getDevice();
                this.isPreHung = false;
                String string = this.di.mf.getName();
                try {
                    this.di.startParse = System.currentTimeMillis();
                    this.di.setIsNew(false);
                    String string2 = this.di.report;
                    this.di.report = null;
                    this.di.mf.updateStatus(string2, this.rp, this.drep);
                    Report.debug.log("Agent", (Object)("Finished parsing :" + this.di.mf.getName()));
                    this.di.lastParse = System.currentTimeMillis();
                    this.di = null;
                    System.gc();
                }
                catch (Throwable throwable) {
                    this.lastError = throwable;
                    Report.error.log(throwable, (Object)("Device Report Parsing failed for " + string));
                    this.di = null;
                }
                if (StoradeEnvironment.getState() != 2) continue;
                this.abort();
            }
        }

        public synchronized boolean isHung() {
            if (this.di == null && DeviceHandler.this.parseList.size() == 0) {
                return false;
            }
            if (this.di == null && DeviceHandler.this.parseList.size() != 0) {
                if (!this.isPreHung) {
                    this.isPreHung = true;
                    this.preHangTime = System.currentTimeMillis();
                    return false;
                }
                long l = System.currentTimeMillis() - this.preHangTime;
                return l > HANG_TIME;
            }
            long l = System.currentTimeMillis() - this.di.startParse;
            return l > HANG_TIME;
        }
    }

    private class Instrumentation
    extends Thread {
        private boolean doRun = true;
        DeviceItem di;
        Throwable lastError;
        DeviceItem lastDevError;

        private Instrumentation() {
        }

        public synchronized void abort() {
            this.doRun = false;
        }

        public synchronized boolean isRunning() {
            return this.doRun;
        }

        public synchronized boolean isHung() {
            if (this.di == null) {
                return false;
            }
            long l = System.currentTimeMillis() - this.di.lastInstStart;
            if (l > HANG_TIME) {
                Report.error.log("Device instumentation hung for device: " + this.di.mf.getClassName() + ":" + this.di.mf.getName());
                this.di.isHung = true;
                return true;
            }
            return false;
        }

        public void run() {
            while (this.doRun) {
                this.di = DeviceHandler.this.instList.getDevice();
                try {
                    this.di.isRunning = true;
                    if (DeviceHandler.this.doInstrumentaion(this.di)) {
                        this.di.lastInstStart = System.currentTimeMillis();
                        Report.debug.log("Agent", (Object)("Instrumenting device :" + this.di.mf.getName()));
                        this.di.report = this.di.gen.generateReport();
                        this.di.lastInst = System.currentTimeMillis();
                        if (this.doRun) {
                            DeviceHandler.this.parseList.addDevice(this.di);
                            Report.debug.log("Agent", (Object)("Finished instrumenting :" + this.di.mf.getName()));
                        }
                        this.di.isHung = false;
                    }
                    this.di.isRunning = false;
                    this.di = null;
                }
                catch (Throwable throwable) {
                    this.di.isRunning = false;
                    this.lastError = throwable;
                    this.lastDevError = this.di;
                    Report.error.log(throwable, (Object)("Instrumentation failed for " + this.di.mf.getName()));
                    this.di = null;
                }
            }
        }
    }

    private class PollingTask
    extends TimerTask {
        long lastPoll;

        private PollingTask() {
        }

        public void run() {
            Object object;
            Object object2;
            if (StoradeEnvironment.getState() == 2) {
                DeviceHandler.this.stopPolling();
                return;
            }
            if (DeviceHandler.this.parser.isHung()) {
                Report.trace.log("Parser has hung. The parser report is:\n " + DeviceHandler.this.getParserReport());
                DeviceHandler.this.parser.abort();
                DeviceHandler.this.parser = new Parser();
                DeviceHandler.this.parser.start();
            }
            int n = 0;
            while (n < DeviceHandler.this.handlers.size()) {
                object2 = (Instrumentation)DeviceHandler.this.handlers.get(n);
                if (((Instrumentation)object2).isRunning() && ((Instrumentation)object2).isHung()) {
                    ((Instrumentation)object2).abort();
                    object = new Instrumentation();
                    DeviceHandler.this.handlers.add(object);
                    ((Thread)object).start();
                }
                ++n;
            }
            if (DeviceHandler.this.instList.size() != 0 || DeviceHandler.this.parseList.size() != 0) {
                return;
            }
            object2 = DeviceHandler.this.devs.iterator();
            Report.debug.log("Agent", (Object)"Instrumenting the SAN...");
            while (object2.hasNext()) {
                object = (DeviceItem)object2.next();
                if (((DeviceItem)object).isRunning || ((DeviceItem)object).isHung) continue;
                DeviceHandler.this.instList.addDevice((DeviceItem)object);
            }
            this.lastPoll = System.currentTimeMillis();
        }
    }
}

