/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.util;

import com.sun.jade.cim.bean.CIM_LogicalDevice;
import com.sun.jade.cim.bean.CIM_System;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.device.util.AssocAdder;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.crimson.tree.XmlDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DeviceReport {
    private static final String cimBeanPackage = "com.sun.jade.cim.bean";
    private static final String cimBeanPrefix = "CIM_";
    DeviceClass deviceClass;
    private String returnCode;
    private String packageName = "com.sun.jade.cim.bean";
    private String prefixName = "CIM";
    private static long memLast;
    private static final String sccs_id = "@(#)DeviceReport.java\t1.10 01/31/02 SMI";
    static /* synthetic */ Class class$java$lang$String;

    public DeviceReport() {
    }

    public DeviceReport(String string) {
        this.deviceClass = new DeviceClass();
        this.parse(string);
        this.packageName = this.deviceClass.getProperty("package");
        this.prefixName = this.deviceClass.getProperty("prefix");
    }

    public DeviceClass getDeviceClass() {
        return this.deviceClass;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPrefixName() {
        return this.prefixName;
    }

    public void update(String string) {
        if (this.deviceClass == null) {
            this.parse(string);
            this.packageName = this.deviceClass.getProperty("package");
            this.prefixName = this.deviceClass.getProperty("prefix");
        }
    }

    public synchronized void parse(String string) {
        if (string == null) {
            return;
        }
        this.deviceClass = new DeviceClass();
        XmlDocument xmlDocument = null;
        try {
            xmlDocument = XmlDocument.createXmlDocument((InputSource)new InputSource(new StringReader(string)), (boolean)false);
        }
        catch (SAXException sAXException) {
            Report.error.log(sAXException, (Object)"Couldn't create document");
            return;
        }
        catch (IOException iOException) {
            Report.error.log(iOException, (Object)"Couldn't create document");
            return;
        }
        Element element = xmlDocument.getDocumentElement();
        if ("report".equals(element.getNodeName())) {
            Object object;
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                object = namedNodeMap.item(n);
                if ("ReturnCode".equals(object.getNodeName())) {
                    this.returnCode = object.getNodeValue();
                }
                ++n;
            }
            object = element.getChildNodes();
            int n2 = 0;
            while (n2 < object.getLength()) {
                Node node = object.item(n2);
                if ("model".equals(node.getNodeName())) {
                    this.parseModel(xmlDocument.getDocumentElement(), this.deviceClass);
                } else if ("error".equals(node.getNodeName())) {
                    // empty if block
                }
                ++n2;
            }
        } else if ("model".equals(element.getNodeName())) {
            this.parseModel(xmlDocument.getDocumentElement(), this.deviceClass);
        }
    }

    private void parseModel(Node node, DeviceClass deviceClass) {
        switch (node.getNodeType()) {
            case 1: {
                NodeList nodeList;
                int n;
                if (deviceClass.getClassName() != null) {
                    deviceClass = deviceClass.newSubInstance();
                }
                deviceClass.setClassName(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    int n2 = namedNodeMap.getLength();
                    n = 0;
                    while (n < n2) {
                        Node node2 = namedNodeMap.item(n);
                        deviceClass.setProperty(node2.getNodeName(), node2.getNodeValue());
                        ++n;
                    }
                }
                if ((nodeList = node.getChildNodes()) == null) break;
                n = 0;
                while (n < nodeList.getLength()) {
                    this.parseModel(nodeList.item(n), deviceClass);
                    ++n;
                }
                break;
            }
            case 3: 
            case 4: {
                deviceClass.setAlias(node.getNodeValue());
                break;
            }
            case 2: {
                deviceClass.setProperty(node.getNodeName(), node.getNodeValue());
            }
        }
    }

    public static void printDC(DeviceClass deviceClass) {
        Iterator iterator;
        System.out.println("ClassName=" + deviceClass.getClassName());
        Properties properties = deviceClass.getProperties();
        if (properties != null) {
            System.out.println("Properties:");
            deviceClass.getProperties().list(System.out);
        }
        if ((iterator = deviceClass.getChildren()) != null) {
            while (iterator.hasNext()) {
                DeviceReport.printDC((DeviceClass)iterator.next());
            }
        }
    }

    public Collection toBeans() {
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable = new Hashtable();
        DefaultProperties defaultProperties = new DefaultProperties();
        defaultProperties.setPackageName(this.packageName);
        defaultProperties.setPrefixName(this.prefixName);
        defaultProperties.setViewName(this.deviceClass.getProperty("view"));
        this.findBeans(defaultProperties, this.deviceClass, arrayList, hashtable);
        return arrayList;
    }

    public synchronized DeviceGraph toGraph() {
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable = new Hashtable();
        DefaultProperties defaultProperties = new DefaultProperties();
        defaultProperties.setPackageName(this.packageName);
        defaultProperties.setPrefixName(this.prefixName);
        defaultProperties.setViewName(this.deviceClass.getProperty("view"));
        this.findBeans(defaultProperties, this.deviceClass, arrayList, hashtable);
        DeviceGraph deviceGraph = new DeviceGraph(arrayList, hashtable);
        return deviceGraph;
    }

    private void findBeans(DefaultProperties defaultProperties, DeviceClass deviceClass, ArrayList arrayList, Hashtable hashtable) {
        CIMBean cIMBean = deviceClass.toBean(defaultProperties.getPackageName(), defaultProperties.getPrefixName());
        if (cIMBean == null) {
            Iterator iterator = deviceClass.getChildren();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    DeviceClass deviceClass2 = (DeviceClass)iterator.next();
                    this.findBeans(defaultProperties, deviceClass2, arrayList, hashtable);
                }
            }
        } else {
            arrayList.add(cIMBean);
            this.addBeans(defaultProperties, cIMBean, deviceClass, arrayList, hashtable);
        }
    }

    private void addBeans(DefaultProperties defaultProperties, CIMBean cIMBean, DeviceClass deviceClass, List list, Hashtable hashtable) {
        Iterator iterator = deviceClass.getChildren();
        if (iterator != null) {
            while (iterator.hasNext()) {
                DeviceClass deviceClass2 = (DeviceClass)iterator.next();
                CIMBean cIMBean2 = deviceClass2.toBean(defaultProperties.getPackageName(), defaultProperties.getPrefixName());
                if (cIMBean2 == null) {
                    if (deviceClass2.getAlias() != null) continue;
                    Report.error.log("CIMBean for " + deviceClass2.getClassName() + " not found");
                    continue;
                }
                list.add(cIMBean2);
                defaultProperties.setDefaultProperties(cIMBean, cIMBean2);
                this.addAssociations(cIMBean, cIMBean2, list, hashtable);
                this.addBeans(defaultProperties, cIMBean2, deviceClass2, list, hashtable);
            }
        }
    }

    private void addAssociations(CIMBean cIMBean, CIMBean cIMBean2, List list, Hashtable hashtable) {
        CIMBean cIMBean3 = AssocAdder.addAssociations(cIMBean, cIMBean2);
        if (cIMBean3 != null) {
            list.add(cIMBean3);
            Association association = new Association(cIMBean3, cIMBean, cIMBean2);
            hashtable.put(cIMBean3.getCIMObjectPath(), association);
        }
    }

    private static void usage() {
        System.out.println("Usage: DeviceReport [options] <xml Report>");
        System.out.println("\t-v Turn on verbose output.");
        System.out.println("\t-b Print beans");
        System.out.println("\t-m Print memory usage.");
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (!string.startsWith("-") || string.equals("-")) break;
                if (string.equals("-v")) {
                    bl = true;
                } else if (string.equals("-b")) {
                    bl2 = true;
                } else if (string.equals("-m")) {
                    bl3 = true;
                }
                ++n;
            }
            if (n >= stringArray.length) {
                DeviceReport.usage();
                System.exit(-1);
            }
            int n2 = n;
            while (n2 < stringArray.length) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                int n3;
                StringBuffer stringBuffer = new StringBuffer();
                FileReader fileReader = null;
                File file = new File(stringArray[n2]);
                fileReader = new FileReader(file);
                char[] cArray = new char[1024];
                while ((n3 = fileReader.read(cArray)) != -1) {
                    object4 = new String(cArray, 0, n3);
                    stringBuffer.append((String)object4);
                }
                if (bl3) {
                    DeviceReport.mem("Starting...");
                }
                object4 = new DeviceReport(stringBuffer.toString());
                if (bl3) {
                    DeviceReport.mem("parser");
                    object3 = ((DeviceReport)object4).toGraph();
                    DeviceReport.mem("bean graph0");
                    object2 = ((DeviceReport)object4).toGraph();
                    DeviceReport.mem("bean graph1");
                    object = ((DeviceReport)object4).toGraph();
                    DeviceReport.mem("bean graph2");
                    DeviceGraph deviceGraph = ((DeviceReport)object4).toGraph();
                    DeviceReport.mem("bean graph3");
                }
                object3 = ((DeviceReport)object4).getDeviceClass();
                if (bl) {
                    System.out.println(((DeviceClass)object3).toXML(""));
                } else if (bl2) {
                    object2 = ((DeviceReport)object4).toBeans();
                    object = object2.iterator();
                    int n4 = 0;
                    while (object.hasNext()) {
                        CIMBean cIMBean = (CIMBean)object.next();
                        if (!bl) continue;
                        System.out.println("bean # " + n4++);
                        System.out.println(((CIMBeanBase)cIMBean).toBeanXML() + "\n");
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void mem(String string) {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        long l3 = l2 - l;
        long l4 = l3 - memLast;
        memLast = l3;
        System.out.println(string + " MEMORY USED:" + l3 + "  INC:" + l4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class Association {
        CIMBean assoc;
        CIMBean left;
        CIMBean right;

        Association(CIMBean cIMBean, CIMBean cIMBean2, CIMBean cIMBean3) {
            this.assoc = cIMBean;
            this.left = cIMBean2;
            this.right = cIMBean3;
        }

        CIMBean getAssoc() {
            return this.assoc;
        }

        CIMBean getLeft() {
            return this.left;
        }

        CIMBean getRight() {
            return this.right;
        }
    }

    private static class DefaultProperties {
        private String systemCreationClassName;
        private String systemName;
        private String deviceCreationClassName;
        private String deviceID;
        private String packageName = "com.sun.jade.cim.bean";
        private String prefixName = "CIM";
        private String viewName = "system";

        private DefaultProperties() {
        }

        void setPackageName(String string) {
            if (string != null) {
                this.packageName = string;
            }
        }

        String getPackageName() {
            return this.packageName;
        }

        void setPrefixName(String string) {
            if (string != null) {
                this.prefixName = string;
            }
        }

        String getPrefixName() {
            return this.prefixName;
        }

        void setViewName(String string) {
            if (string != null) {
                this.viewName = string;
            }
        }

        void setDefaultProperties(CIMBean cIMBean, CIMBean cIMBean2) {
            if (cIMBean instanceof CIM_System) {
                CIM_System cIM_System = (CIM_System)cIMBean;
                this.systemCreationClassName = cIM_System.getCreationClassName();
                this.systemName = cIM_System.getName();
                if (cIMBean2 instanceof CIM_LogicalDevice) {
                    String string;
                    CIM_LogicalDevice cIM_LogicalDevice = (CIM_LogicalDevice)cIMBean2;
                    this.deviceCreationClassName = cIM_LogicalDevice.getCreationClassName();
                    this.deviceID = cIM_LogicalDevice.getDeviceID();
                    String string2 = cIM_LogicalDevice.getSystemCreationClassName();
                    if (string2 == null) {
                        cIM_LogicalDevice.setSystemCreationClassName(this.systemCreationClassName);
                    }
                    if ((string = cIM_LogicalDevice.getSystemName()) == null) {
                        cIM_LogicalDevice.setSystemName(this.systemName);
                    }
                }
            } else {
                this.setBeanValue(cIMBean2, "SystemCreationClassName", this.systemCreationClassName);
                this.setBeanValue(cIMBean2, "SystemName", this.systemName);
                this.setBeanValue(cIMBean2, "DeviceID", this.deviceID);
                this.setBeanValue(cIMBean2, "DeviceCreationClassName", this.deviceCreationClassName);
                this.setBeanValue(cIMBean2, "CSCreationClassName", this.systemCreationClassName);
                this.setBeanValue(cIMBean2, "CSName", this.systemName);
            }
        }

        private void setBeanValue(CIMBean cIMBean, String string, String string2) {
            if (string2 == null) {
                return;
            }
            if (cIMBean == null) {
                return;
            }
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DeviceReport.class$("java.lang.String")) : class$java$lang$String};
            Class<?> clazz = cIMBean.getClass();
            try {
                Method method = clazz.getMethod("get" + string, new Class[0]);
                Object object = method.invoke((Object)cIMBean, new Object[0]);
                if (object == null) {
                    method = clazz.getMethod("set" + string, classArray);
                    method.invoke((Object)cIMBean, string2);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public class DeviceGraph {
        ArrayList list;
        Hashtable assoc;

        DeviceGraph(ArrayList arrayList, Hashtable hashtable) {
            this.list = arrayList;
            this.assoc = hashtable;
        }

        public ArrayList getBeans() {
            return this.list;
        }

        public Hashtable getAssociations() {
            return this.assoc;
        }
    }
}

