/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.event;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.EmbeddedObject;
import com.sun.jade.util.SequenceNumberGenerator;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.xml.XMLTag;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMObjectPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EventData {
    private static final String TAG = "EventData";
    private String source;
    private long sourceSequenceNumber;
    private long subjectTime;
    private String[] correlatedEvents;
    private long sourceTime;
    private String type;
    private String topic;
    private String subject;
    private int severity;
    private String payloadType;
    private Object payload;
    private LocalizedString description;
    private String eventCode;
    private String eventID;
    private String subjectEnclosureIP;
    private String descriptionCode;
    private Object[] descriptionInfo;
    protected ArrayList data;
    protected String deviceName;
    protected String className;
    protected String initiator;
    protected ArrayList otherData;
    protected CIMDateTime cimTime;
    protected long eventTime;
    protected String eventType;

    public EventData(int n, String string, String string2, String string3, String string4) {
        this(n, string, string2, string3, string4, null, null);
    }

    public EventData(int n, String string, String string2, String string3, String string4, String[] stringArray, LocalizedString localizedString) {
        this(n, string, SequenceNumberGenerator.createSequenceNumber(string), string2, System.currentTimeMillis(), string3, string4, stringArray, localizedString, System.currentTimeMillis());
    }

    public EventData(int n, String string, long l, String string2, long l2, String string3, String string4, String[] stringArray, LocalizedString localizedString, long l3) {
        this(n, string, l, string2, l2, string3, string4, stringArray, localizedString, l3, null);
    }

    public EventData(int n, String string, long l, String string2, long l2, String string3, String string4, String[] stringArray, LocalizedString localizedString, long l3, String string5) {
        this.setSeverity(n);
        this.setSource(string);
        this.setSourceSequenceNumber(l);
        this.setSubject(string2);
        this.setSubjectTime(l2);
        this.setTopic(string3);
        this.setType(string4);
        this.setCorrelatedEvents(stringArray);
        this.setDescription(localizedString);
        this.setSourceTime(l3);
        this.setEventCode(string5);
    }

    public static boolean eventIsOfThisType(AbstractEvent abstractEvent) {
        String string = abstractEvent.getPayloadType();
        return string != null && string.startsWith("ESM/Common/XML/1.0");
    }

    public EventData(AbstractEvent abstractEvent) {
        XMLTag xMLTag;
        this.setSeverity(abstractEvent.getSeverity());
        this.setSource(abstractEvent.getSource());
        this.setSourceSequenceNumber(abstractEvent.getSourceSequenceNumber());
        this.setSubject(abstractEvent.getSubject());
        this.setSubjectTime(abstractEvent.getSubjectTime());
        this.setTopic(abstractEvent.getTopic());
        this.setType(abstractEvent.getType());
        this.setCorrelatedEvents(abstractEvent.getCorrelatedEvents());
        this.setSourceTime(abstractEvent.getSourceTime());
        this.setPayload(abstractEvent.getPayload());
        this.setPayloadType(abstractEvent.getPayloadType());
        this.setEventID(abstractEvent.getEventID());
        String string = abstractEvent.getPayloadType();
        if (string != null && string.startsWith("ESM/Common/XML/1.0") && (xMLTag = XMLTag.getTagFromString((String)abstractEvent.getPayload())) != null) {
            Object object;
            XMLTag xMLTag2;
            XMLTag xMLTag3 = this.getTag("common:description", xMLTag);
            if (xMLTag3 != null) {
                xMLTag2 = this.getTag("common:I18NString", xMLTag3);
                object = EventData.getLocalizedStringFromXMLTag(xMLTag2);
                this.setDescription((LocalizedString)object);
            }
            if ((xMLTag2 = this.getTag("storadeExt", xMLTag)) != null) {
                String string2;
                object = (String)xMLTag2.getAttributes().get("eventCode");
                if (object != null) {
                    this.setEventCode((String)object);
                }
                if ((string2 = (String)xMLTag2.getAttributes().get("subjectEnclosureIP")) != null) {
                    this.setSubjectEnclosureIP(string2);
                }
            }
        }
    }

    protected XMLTag getTag(String string, XMLTag xMLTag) {
        if (xMLTag.getName().equals(string)) {
            return xMLTag;
        }
        Collection collection = xMLTag.getContents();
        if (collection == null) {
            return null;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            XMLTag xMLTag2;
            Object e = iterator.next();
            if (!(e instanceof XMLTag) || (xMLTag2 = this.getTag(string, (XMLTag)e)) == null) continue;
            return xMLTag2;
        }
        return null;
    }

    protected static LocalizedString getLocalizedStringFromXMLTag(XMLTag xMLTag) {
        Object object;
        if (xMLTag == null) {
            return null;
        }
        String string = (String)xMLTag.getAttributes().get("resBundleName");
        String string2 = (String)xMLTag.getAttributes().get("code");
        Collection collection = xMLTag.getContents();
        if (collection == null) {
            return new LocalizedString(string, string2, string + "." + string2);
        }
        Iterator iterator = collection.iterator();
        String string3 = null;
        Vector<Object> vector = new Vector<Object>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof XMLTag) {
                XMLTag xMLTag2 = (XMLTag)object;
                Collection collection2 = xMLTag2.getContents();
                Object[] objectArray = collection2.toArray();
                if (objectArray.length <= 0) continue;
                vector.add(objectArray[0]);
                continue;
            }
            string3 = (String)object;
        }
        object = new Object[vector.size()];
        vector.copyInto((Object[])object);
        return new LocalizedString(string, string2, string3, (Object[])object);
    }

    protected CIMBean getCIMBeanFromInstanceTag(XMLTag xMLTag) {
        Collection collection;
        if (xMLTag == null) {
            return null;
        }
        String string = null;
        if (xMLTag.getAttributes() != null) {
            string = (String)xMLTag.getAttributes().get("package");
        }
        if ((collection = xMLTag.getContents()) != null) {
            Iterator iterator = collection.iterator();
            String string2 = (String)iterator.next();
            try {
                EmbeddedObject embeddedObject = new EmbeddedObject(string2);
                CIMBean cIMBean = embeddedObject.getBean();
                return cIMBean;
            }
            catch (Exception exception) {
                Report.error.log(TAG, exception, "Failed to parse CIMBean from XMLTag: " + xMLTag);
            }
        }
        return null;
    }

    public void setSubjectEnclosureIP(String string) {
        this.subjectEnclosureIP = string;
    }

    public String getSubjectEnclosureIP() {
        return this.subjectEnclosureIP;
    }

    public void setEventID(String string) {
        this.eventID = string;
    }

    public String getEventID() {
        return this.eventID;
    }

    public void setPayload(Object object) {
        this.payload = object;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setSourceSequenceNumber(long l) {
        this.sourceSequenceNumber = l;
    }

    public long getSourceSequenceNumber() {
        return this.sourceSequenceNumber;
    }

    public void setSubjectTime(long l) {
        this.subjectTime = l;
    }

    public long getSubjectTime() {
        return this.subjectTime;
    }

    public void setCorrelatedEvents(String[] stringArray) {
        this.correlatedEvents = stringArray;
    }

    public String[] getCorrelatedEvents() {
        return this.correlatedEvents;
    }

    public void setSourceTime(long l) {
        this.sourceTime = l;
    }

    public long getSourceTime() {
        return this.sourceTime;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String string) {
        this.topic = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }

    protected String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(String string) {
        this.payloadType = string;
    }

    public LocalizedString getDescription() {
        return this.description;
    }

    public void setDescription(LocalizedString localizedString) {
        this.description = localizedString;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String string) {
        this.eventCode = string;
    }

    public void addCorrelatedEvent(String string) {
        String[] stringArray = this.getCorrelatedEvents();
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        String[] stringArray2 = new String[++n];
        int n2 = 0;
        while (n2 < n - 1) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        stringArray2[n - 1] = string;
        this.setCorrelatedEvents(stringArray2);
    }

    public EventData(String string, String string2, String string3, CIMObjectPath cIMObjectPath, int n, String string4, String string5, ArrayList arrayList) throws IllegalArgumentException {
        String string6 = null;
        if (string == null) {
            string6 = "deviceName";
        } else if (string2 == null) {
            string6 = "eventType";
        } else if (string3 == null) {
            string6 = "topic";
        } else if (cIMObjectPath == null) {
            string6 = "subject";
        } else if (string4 == null) {
            string6 = "className";
        } else if (string5 == null) {
            string6 = "initiator";
        } else if (arrayList == null) {
            string6 = "data";
        }
        if (string6 != null) {
            throw new IllegalArgumentException("EventData parameter is null: " + string6);
        }
        this.deviceName = string;
        this.eventType = string2;
        this.topic = string3;
        this.subject = cIMObjectPath.toString();
        this.severity = n;
        this.className = string4;
        this.initiator = string5;
        this.data = arrayList;
        this.cimTime = new CIMDateTime();
        this.eventTime = System.currentTimeMillis();
    }

    public String getDescriptionCode() {
        return this.descriptionCode;
    }

    public void setDescriptionCode(String string) {
        this.descriptionCode = string;
    }

    public Object[] getDescriptionInfo() {
        return this.descriptionInfo;
    }

    public void setDescriptionInfo(Object[] objectArray) {
        this.descriptionInfo = objectArray;
    }

    public ArrayList getData() {
        return this.data;
    }

    public void setData(ArrayList arrayList) {
        this.data = arrayList;
    }

    public void setSubject(CIMObjectPath cIMObjectPath) {
        this.subject = cIMObjectPath.toString();
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setOtherData(ArrayList arrayList) {
        this.otherData = arrayList;
    }

    public ArrayList getOtherData() {
        return this.otherData;
    }

    public CIMDateTime getCimTime() {
        return this.cimTime;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInitiator() {
        return this.initiator;
    }
}

