/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.event;

import com.sun.jade.cim.bean.NWS_Agent;
import com.sun.jade.cim.bean.NWS_DirectLink;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.EventConstants;
import com.sun.jade.event.EventData;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.message.MessageCode;
import com.sun.jade.services.event.AbstractEventSubscriber;
import com.sun.jade.services.event.EventService;
import com.sun.jade.util.OID;
import com.sun.jade.util.jini.BaseServiceFinder;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.xml.XMLTag;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class EventGenerator {
    private static final String TAG = "EventGenerator";
    public static final String PAYLOAD_TYPE_COMMON = "ESM/Common/XML/1.0";
    public static final String PAYLOAD_TYPE_STORADE = "ESM/Common/XML/1.0/StorADE";
    public static final String DISCOVERY_EVENT = "DeviceDiscovery";
    public static final String AGENT_DISCOVERY_EVENT = "AgentDiscovery";
    public static final String TOPOLOGY_DISCOVERY_EVENT = "TopologyDiscovery";
    public static final String TOPOLOGY_ADDITION_EVENT = "TopologyAddition";
    public static final String TOPOLOGY_REMOVAL_EVENT = "TopologyRemoval";
    public static final String AUDIT_EVENT = "Audit";
    public static final String HEARTBEAT_EVENT = "Heartbeat";
    public static final String STATE_CHANGE_EVENT = "StateChange";
    public static final String STATE_CHANGE_ALERT = "StateChangeAlert";
    public static final String DIAGNOSIS_START_EVENT = "DiagnosisStart";
    public static final String DIAGNOSIS_STATUS_EVENT = "DiagnosisStatus";
    public static final String COMMUNICATION_STATE_CHANGE_EVENT = "CommunicationStateChange";

    public static void generateEvent(EventData eventData) {
        Object object;
        Object object2 = null;
        String string = null;
        String string2 = eventData.getEventID();
        if (string2 == null) {
            string2 = EventGenerator.createEventID();
        }
        if (eventData instanceof AlertEventData) {
            object = (AlertEventData)eventData;
            Exception exception = new Exception("Dummy Exception for tracing.");
            if (((AlertEventData)object).getCauseInformation() == null) {
                Report.warning.log(exception, (Object)"Alert generated without cause information.  Dummy exception for tracing follows:");
            }
            if (((EventData)object).getSubjectEnclosureIP() == null) {
                Report.warning.log(exception, (Object)"Alert generated without subject enclosure ip.  Dummy exception for tracing follows:");
            }
        }
        if (null == eventData.getDescription()) {
            object = new MessageCode("app.sade3.general.error", 7);
            eventData.setDescription(((MessageCode)object).getLocalizedStringMessage());
            Report.warning.log(new Exception("Dummy Exception for tracing."), (Object)"Event generated without description.Dummy exception for tracing follows:");
        }
        if (eventData instanceof DefinitionEventData || eventData instanceof ModificationEventData || eventData instanceof DeletionEventData || eventData instanceof AlertEventData) {
            object2 = EventGenerator.buildPayload(eventData);
            string = PAYLOAD_TYPE_STORADE;
        } else {
            object2 = eventData.getPayload();
            string = eventData.getPayloadType();
        }
        object = new NSMEvent(eventData.getSeverity(), eventData.getSource(), eventData.getSourceSequenceNumber(), eventData.getSubject(), eventData.getSubjectTime(), eventData.getTopic(), eventData.getType(), object2, string, eventData.getCorrelatedEvents(), string2, eventData.getSourceTime());
        EventGenerator.postEvent((NSMEvent)object);
    }

    public static String createEventID() {
        return OID.getKey();
    }

    public static void generateCorrelatedEvents(Collection collection) {
        EventData[] eventDataArray = new EventData[collection.size()];
        collection.toArray(eventDataArray);
        if (eventDataArray.length == 1) {
            EventGenerator.generateEvent(eventDataArray[0]);
            return;
        }
        int n = 0;
        while (n < eventDataArray.length) {
            eventDataArray[n].setEventID(EventGenerator.createEventID());
            ++n;
        }
        n = 0;
        while (n < eventDataArray.length) {
            String[] stringArray = eventDataArray[n].getCorrelatedEvents();
            int n2 = stringArray == null ? 0 : stringArray.length;
            String[] stringArray2 = new String[eventDataArray.length - 1 + n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < eventDataArray.length) {
                if (n != n4) {
                    stringArray2[n3++] = eventDataArray[n4].getEventID();
                }
                ++n4;
            }
            if (n2 > 0) {
                int n5 = 0;
                while (n5 < stringArray.length) {
                    stringArray2[eventDataArray.length - 1 + n5] = stringArray[n5];
                    ++n5;
                }
            }
            eventDataArray[n].setCorrelatedEvents(stringArray2);
            EventGenerator.generateEvent(eventDataArray[n]);
            ++n;
        }
    }

    private static String buildPayload(EventData eventData) {
        if (eventData instanceof DefinitionEventData) {
            return EventGenerator.buildDefinitionPayload((DefinitionEventData)eventData);
        }
        if (eventData instanceof ModificationEventData) {
            return EventGenerator.buildModificationPayload((ModificationEventData)eventData);
        }
        if (eventData instanceof AlertEventData) {
            return EventGenerator.buildAlertPayload((AlertEventData)eventData);
        }
        if (eventData instanceof DeletionEventData) {
            return EventGenerator.buildDeletionPayload((DeletionEventData)eventData);
        }
        return "eh?";
    }

    private static String buildDefinitionPayload(DefinitionEventData definitionEventData) {
        String string;
        XMLTag xMLTag;
        XMLTag xMLTag2 = new XMLTag("common:payload");
        XMLTag xMLTag3 = EventGenerator.getStoradeExtXMLTag(definitionEventData);
        if (xMLTag3 != null) {
            xMLTag2.addContent(xMLTag3);
        }
        if ((xMLTag = EventGenerator.getDescriptionXMLTag(definitionEventData)) != null) {
            xMLTag2.addContent(xMLTag);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = definitionEventData.getDefinitionType();
        if (string2 != null) {
            hashMap.put("type", string2);
        }
        if (!(string = definitionEventData.isAudit() + "").equals("")) {
            hashMap.put("audit", string);
        }
        XMLTag xMLTag4 = new XMLTag("common:definition", hashMap);
        CIMBean[] cIMBeanArray = definitionEventData.getDefinedObjects();
        if (cIMBeanArray != null) {
            int n = 0;
            while (n < cIMBeanArray.length) {
                try {
                    XMLTag xMLTag5 = new XMLTag("common:instance");
                    xMLTag5.addContent(((CIMBeanBase)cIMBeanArray[n]).toCIMInstance().toMOF());
                    xMLTag4.addContent(xMLTag5);
                }
                catch (Exception exception) {
                    Report.error.log(TAG, exception, "Failed to convert CIMBean into MOF");
                }
                ++n;
            }
        }
        xMLTag2.addContent(xMLTag4);
        return xMLTag2.toString();
    }

    private static String buildDeletionPayload(DeletionEventData deletionEventData) {
        XMLTag xMLTag;
        XMLTag xMLTag2 = new XMLTag("common:payload");
        XMLTag xMLTag3 = EventGenerator.getStoradeExtXMLTag(deletionEventData);
        if (xMLTag3 != null) {
            xMLTag2.addContent(xMLTag3);
        }
        if ((xMLTag = EventGenerator.getDescriptionXMLTag(deletionEventData)) != null) {
            xMLTag2.addContent(xMLTag);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = deletionEventData.getDeletionType();
        if (string != null) {
            hashMap.put("type", string);
        }
        XMLTag xMLTag4 = new XMLTag("common:deletion", hashMap);
        CIMBean[] cIMBeanArray = deletionEventData.getDeletedObjects();
        if (cIMBeanArray != null) {
            int n = 0;
            while (n < cIMBeanArray.length) {
                try {
                    XMLTag xMLTag5 = new XMLTag("common:instance");
                    xMLTag5.addContent(((CIMBeanBase)cIMBeanArray[n]).toCIMInstance().toMOF());
                    xMLTag4.addContent(xMLTag5);
                }
                catch (Exception exception) {
                    Report.error.log(TAG, exception, "Failed to convert CIMBean into MOF");
                }
                ++n;
            }
        }
        xMLTag2.addContent(xMLTag4);
        return xMLTag2.toString();
    }

    private static String buildModificationPayload(ModificationEventData modificationEventData) {
        XMLTag xMLTag;
        XMLTag xMLTag2;
        XMLTag xMLTag3;
        XMLTag xMLTag4 = new XMLTag("common:payload");
        XMLTag xMLTag5 = EventGenerator.getStoradeExtXMLTag(modificationEventData);
        if (xMLTag5 != null) {
            xMLTag4.addContent(xMLTag5);
        }
        if ((xMLTag3 = EventGenerator.getDescriptionXMLTag(modificationEventData)) != null) {
            xMLTag4.addContent(xMLTag3);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = modificationEventData.getModificationType();
        if (string != null) {
            hashMap.put("type", string);
        }
        XMLTag xMLTag6 = new XMLTag("common:modification", hashMap);
        if (modificationEventData.getPreviousInstance() != null) {
            xMLTag2 = new XMLTag("common:prevInstance");
            xMLTag = new XMLTag("common:instance");
            try {
                xMLTag.addContent(((CIMBeanBase)modificationEventData.getPreviousInstance()).toCIMInstance().toMOF());
                xMLTag2.addContent(xMLTag);
                xMLTag6.addContent(xMLTag2);
            }
            catch (Exception exception) {
                Report.error.log(TAG, exception, "Failed to convert CIMBean into MOF");
            }
        }
        if (modificationEventData.getCurrentInstance() != null) {
            xMLTag2 = new XMLTag("common:currInstance");
            xMLTag = new XMLTag("common:instance");
            try {
                xMLTag.addContent(((CIMBeanBase)modificationEventData.getCurrentInstance()).toCIMInstance().toMOF());
                xMLTag2.addContent(xMLTag);
                xMLTag6.addContent(xMLTag2);
            }
            catch (Exception exception) {
                Report.error.log(TAG, exception, "Failed to convert CIMBean into MOF");
            }
        }
        xMLTag4.addContent(xMLTag6);
        return xMLTag4.toString();
    }

    private static String buildAlertPayload(AlertEventData alertEventData) {
        LocalizedString[] localizedStringArray;
        LocalizedString[] localizedStringArray2;
        Object object;
        Serializable serializable;
        AlertEventData.CauseInformation[] causeInformationArray;
        XMLTag xMLTag;
        XMLTag xMLTag2 = new XMLTag("common:payload");
        XMLTag xMLTag3 = EventGenerator.getStoradeExtXMLTag(alertEventData);
        if (xMLTag3 != null) {
            xMLTag2.addContent(xMLTag3);
        }
        if ((xMLTag = EventGenerator.getDescriptionXMLTag(alertEventData)) != null) {
            xMLTag2.addContent(xMLTag);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = alertEventData.getAlertType();
        if (string != null) {
            hashMap.put("type", string);
        }
        XMLTag xMLTag4 = new XMLTag("common:alert", hashMap);
        if (alertEventData.getCauseInformation() == null) {
            LocalizedString[] localizedStringArray3;
            LocalizedString[] localizedStringArray4;
            causeInformationArray = new MessageCode("app.sade3.general.error", 6);
            String string2 = causeInformationArray.getProperty("url");
            serializable = causeInformationArray.getLocalizedStringProperty("probableCause");
            object = causeInformationArray.getLocalizedStringProperty("recommendedAction");
            if (serializable == null) {
                localizedStringArray4 = null;
            } else {
                LocalizedString[] localizedStringArray5 = new LocalizedString[1];
                localizedStringArray4 = localizedStringArray5;
                localizedStringArray5[0] = serializable;
            }
            localizedStringArray2 = localizedStringArray4;
            if (object == null) {
                localizedStringArray3 = null;
            } else {
                LocalizedString[] localizedStringArray6 = new LocalizedString[1];
                localizedStringArray3 = localizedStringArray6;
                localizedStringArray6[0] = object;
            }
            localizedStringArray = localizedStringArray3;
            alertEventData.setCauseInformation(new AlertEventData.CauseInformation[]{new AlertEventData.CauseInformation(localizedStringArray2, localizedStringArray, string2)});
        }
        if (alertEventData.getCauseInformation() != null) {
            causeInformationArray = alertEventData.getCauseInformation();
            int n = 0;
            while (n < causeInformationArray.length) {
                LocalizedString[] localizedStringArray7;
                XMLTag xMLTag5;
                serializable = new HashMap();
                object = causeInformationArray[n].getURL();
                if (object != null) {
                    ((HashMap)serializable).put("url", object);
                }
                localizedStringArray2 = new XMLTag("common:causeInfo", (HashMap)serializable);
                localizedStringArray = causeInformationArray[n].getProbableCauses();
                if (localizedStringArray != null) {
                    int n2 = 0;
                    while (n2 < localizedStringArray.length) {
                        XMLTag xMLTag6 = new XMLTag("common:probCause");
                        xMLTag5 = EventGenerator.getLocalizedStringXMLTag(localizedStringArray[n2]);
                        xMLTag6.addContent(xMLTag5);
                        localizedStringArray2.addContent(xMLTag6);
                        ++n2;
                    }
                }
                if ((localizedStringArray7 = causeInformationArray[n].getRecommendedActions()) != null) {
                    int n3 = 0;
                    while (n3 < localizedStringArray7.length) {
                        xMLTag5 = new XMLTag("common:recAction");
                        XMLTag xMLTag7 = EventGenerator.getLocalizedStringXMLTag(localizedStringArray7[n3]);
                        xMLTag5.addContent(xMLTag7);
                        localizedStringArray2.addContent(xMLTag5);
                        ++n3;
                    }
                }
                xMLTag4.addContent(localizedStringArray2);
                ++n;
            }
        }
        xMLTag2.addContent(xMLTag4);
        return xMLTag2.toString();
    }

    private static XMLTag getDescriptionXMLTag(EventData eventData) {
        XMLTag xMLTag = new XMLTag("common:description");
        LocalizedString localizedString = eventData.getDescription();
        if (localizedString == null) {
            return null;
        }
        XMLTag xMLTag2 = EventGenerator.getLocalizedStringXMLTag(localizedString);
        xMLTag.addContent(xMLTag2);
        return xMLTag;
    }

    private static XMLTag getStoradeExtXMLTag(EventData eventData) {
        String string = eventData.getEventCode();
        String string2 = eventData.getSubjectEnclosureIP();
        if (string == null && string2 == null) {
            return null;
        }
        XMLTag xMLTag = new XMLTag("common:payloadExt");
        XMLTag xMLTag2 = new XMLTag("storadeExt");
        if (string != null) {
            xMLTag2.addAttribute("eventCode", "" + string);
        }
        if (string2 != null) {
            xMLTag2.addAttribute("subjectEnclosureIP", "" + string2);
        }
        xMLTag.addContent(xMLTag2);
        return xMLTag;
    }

    private static XMLTag getLocalizedStringXMLTag(LocalizedString localizedString) {
        if (localizedString == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = localizedString.getResource();
        String string2 = localizedString.getProperty();
        if (string != null) {
            hashMap.put("resBundleName", string);
        }
        if (string2 != null) {
            hashMap.put("code", string2);
        }
        XMLTag xMLTag = new XMLTag("common:I18NString", hashMap);
        Object[] objectArray = localizedString.getArgs();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                String string3 = objectArray[n].getClass().getName();
                hashMap2.put("type", string3);
                XMLTag xMLTag2 = new XMLTag("common:I18NStringArg", hashMap2);
                xMLTag2.addContent(objectArray[n]);
                xMLTag.addContent(xMLTag2);
                ++n;
            }
        }
        String string4 = localizedString.getLocalizedMessage();
        xMLTag.addContent(string4);
        return xMLTag;
    }

    private static void postEvent(NSMEvent nSMEvent) {
        Report.debug.log("EventMsg", (Object)("Posting a " + nSMEvent.getTopic() + " event for " + nSMEvent.getSource()));
        EventService eventService = BaseServiceFinder.getEventService2();
        eventService.post(nSMEvent);
    }

    public static void main(String[] stringArray) {
        int n = 3;
        String string = EventConstants.SOURCE_PREFIX + "EventGenerator/TestCode";
        long l = 123L;
        String string2 = "the subject";
        long l2 = System.currentTimeMillis();
        String string3 = "foo.bar";
        String string4 = "the type";
        String[] stringArray2 = new String[]{"124"};
        LocalizedString localizedString = new LocalizedString("foo.resource", "foo.property", "default msg");
        long l3 = System.currentTimeMillis();
        String string5 = "1";
        NWS_DirectLink nWS_DirectLink = new NWS_DirectLink();
        NWS_DirectLink nWS_DirectLink2 = new NWS_DirectLink();
        nWS_DirectLink.setType("oldValue");
        nWS_DirectLink2.setType("newValue");
        AbstractEventSubscriber abstractEventSubscriber = new AbstractEventSubscriber(){

            public void notify(AbstractEvent abstractEvent) {
                block22: {
                    AlertEventData alertEventData;
                    AlertEventData.CauseInformation[] causeInformationArray;
                    System.out.println("received event " + abstractEvent.getEventID());
                    System.out.println("XML:");
                    System.out.println(((NSMEvent)abstractEvent).toXML());
                    EventData eventData = new EventData(abstractEvent);
                    System.out.println("FIELDS:");
                    System.out.println("eventID=" + eventData.getEventID());
                    System.out.println("severity=" + eventData.getSeverity());
                    System.out.println("source=" + eventData.getSource());
                    System.out.println("sourceSequenceNumber=" + eventData.getSourceSequenceNumber());
                    System.out.println("subject=" + eventData.getSubject());
                    System.out.println("subjectTime=" + eventData.getSubjectTime());
                    System.out.println("topic=" + eventData.getTopic());
                    System.out.println("type=" + eventData.getType());
                    System.out.println("correlatedEvents=" + eventData.getCorrelatedEvents());
                    if (eventData.getDescription() != null) {
                        System.out.println("description=" + eventData.getDescription().getLocalizedMessage());
                    } else {
                        System.out.println("description=null");
                    }
                    System.out.println("sourceTime=" + eventData.getSourceTime());
                    System.out.println("eventCode=" + eventData.getEventCode());
                    System.out.println("payloadType=" + eventData.getPayloadType());
                    System.out.println("payload=" + eventData.getPayload());
                    if (abstractEvent.getType().equals(EventGenerator.DISCOVERY_EVENT)) {
                        DefinitionEventData definitionEventData = new DefinitionEventData(abstractEvent);
                        try {
                            CIMBean[] cIMBeanArray = definitionEventData.getDefinedObjects();
                            int n = 0;
                            while (n < cIMBeanArray.length) {
                                System.out.println("definedInstances[" + n + "]=" + ((CIMBeanBase)cIMBeanArray[n]).toCIMInstance().toMOF());
                                ++n;
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (abstractEvent.getType().equals(EventGenerator.STATE_CHANGE_EVENT)) {
                        ModificationEventData modificationEventData = new ModificationEventData(abstractEvent);
                        try {
                            CIMBean cIMBean = modificationEventData.getPreviousInstance();
                            if (cIMBean == null) {
                                System.out.println("previousInstance=null");
                            } else {
                                System.out.println("previousInstance=" + ((CIMBeanBase)cIMBean).toCIMInstance().toMOF());
                            }
                            CIMBean cIMBean2 = modificationEventData.getCurrentInstance();
                            if (cIMBean2 == null) {
                                System.out.println("currentInstance=null");
                                break block22;
                            }
                            System.out.println("currentInstance=" + ((CIMBeanBase)cIMBean2).toCIMInstance().toMOF());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (abstractEvent.getType().equals("alert") && (causeInformationArray = (alertEventData = new AlertEventData(abstractEvent)).getCauseInformation()) != null) {
                        int n = 0;
                        while (n < causeInformationArray.length) {
                            int n2;
                            String string = causeInformationArray[n].getURL();
                            String string2 = "causeInformation[" + n + "].";
                            System.out.println(string2 + "url=" + string);
                            LocalizedString[] localizedStringArray = causeInformationArray[n].getProbableCauses();
                            LocalizedString[] localizedStringArray2 = causeInformationArray[n].getRecommendedActions();
                            if (localizedStringArray == null) {
                                System.out.println(string2 + ".probCauses=null");
                            } else {
                                n2 = 0;
                                while (n2 < localizedStringArray.length) {
                                    System.out.println((string2 + "probCauses[" + n2 + "]=" + localizedStringArray[n2].getLocalizedMessage()).trim());
                                    ++n2;
                                }
                            }
                            if (localizedStringArray2 == null) {
                                System.out.println(string2 + ".recActions=null");
                            } else {
                                n2 = 0;
                                while (n2 < localizedStringArray2.length) {
                                    System.out.println((string2 + "recActions[" + n2 + "]=" + localizedStringArray2[n2].getLocalizedMessage()).trim());
                                    ++n2;
                                }
                            }
                            ++n;
                        }
                    }
                }
            }
        };
        BaseServiceFinder.getEventService2().subscribe(abstractEventSubscriber, "foo.bar");
        EventData eventData = new EventData(n, string, string2, string3, string4);
        EventGenerator.generateEvent(eventData);
        eventData.setPayload("custom payload");
        eventData.setPayloadType("custom");
        EventGenerator.generateEvent(eventData);
        DefinitionEventData definitionEventData = new DefinitionEventData(n, string, string2, string3, DISCOVERY_EVENT, "topology", new CIMBean[]{nWS_DirectLink});
        EventGenerator.generateEvent(definitionEventData);
        definitionEventData = new DefinitionEventData(n, string, string2, string3, DISCOVERY_EVENT, stringArray2, localizedString, "topology", new CIMBean[]{nWS_DirectLink, nWS_DirectLink2});
        EventGenerator.generateEvent(definitionEventData);
        definitionEventData = new DefinitionEventData(n, string, l, string2, l2, string3, DISCOVERY_EVENT, stringArray2, localizedString, l3, true, "topology", new CIMBean[]{nWS_DirectLink, nWS_DirectLink2});
        EventGenerator.generateEvent(definitionEventData);
        ModificationEventData modificationEventData = new ModificationEventData(n, string, string2, string3, STATE_CHANGE_EVENT, "topology", (CIMBean)nWS_DirectLink, (CIMBean)nWS_DirectLink2);
        EventGenerator.generateEvent(modificationEventData);
        modificationEventData = new ModificationEventData(n, string, string2, string3, STATE_CHANGE_EVENT, stringArray2, localizedString, "topology", (CIMBean)nWS_DirectLink, (CIMBean)nWS_DirectLink2);
        EventGenerator.generateEvent(modificationEventData);
        modificationEventData = new ModificationEventData(n, string, l, string2, l2, string3, string4, stringArray2, localizedString, l3, "topology", (CIMBean)nWS_DirectLink, (CIMBean)nWS_DirectLink2);
        EventGenerator.generateEvent(modificationEventData);
        modificationEventData = new ModificationEventData(n, string, l, string2, l2, string3, STATE_CHANGE_EVENT, stringArray2, localizedString, l3, "topology", null, null);
        EventGenerator.generateEvent(modificationEventData);
        LocalizedString localizedString2 = new LocalizedString("foo.resource", "foo.property", "fire");
        LocalizedString localizedString3 = new LocalizedString("foo.resource", "foo.property", "flood");
        LocalizedString localizedString4 = new LocalizedString("foo.resource", "foo.property", "run");
        LocalizedString localizedString5 = new LocalizedString("foo.resource", "foo.property", "swim $1", new Object[]{"quickly"});
        LocalizedString localizedString6 = new LocalizedString("foo.resource", "foo.property", "hide");
        AlertEventData.CauseInformation[] causeInformationArray = new AlertEventData.CauseInformation[]{new AlertEventData.CauseInformation(new LocalizedString[]{localizedString2}, new LocalizedString[]{localizedString4, localizedString6}, "http://www.firedepartment.com"), new AlertEventData.CauseInformation(new LocalizedString[]{localizedString3}, new LocalizedString[]{localizedString5}, "http://www.coastguard.com")};
        AlertEventData alertEventData = new AlertEventData(n, string, string2, string3, "alert", "other", causeInformationArray);
        EventGenerator.generateEvent(alertEventData);
        alertEventData = new AlertEventData(n, string, string2, string3, "alert", stringArray2, localizedString, "other", causeInformationArray);
        EventGenerator.generateEvent(alertEventData);
        alertEventData = new AlertEventData(n, string, l, string2, l2, string3, "alert", stringArray2, localizedString, l3, string5, "other", causeInformationArray);
        EventGenerator.generateEvent(alertEventData);
    }

    public static NWS_Agent createAgent() {
        return new NWS_Agent();
    }
}

