/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.event;

import com.sun.jade.event.Formatter;
import com.sun.jade.util.OID;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.xml.XMLTag;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Locale;

public final class NSMEvent
extends AbstractEvent {
    private static final boolean DEBUG = false;
    private String terse;
    private String verbose;
    private String stationID;
    private String stationURL;

    public NSMEvent cloneEvent() {
        try {
            NSMEvent nSMEvent = new NSMEvent();
            Class<?> clazz = nSMEvent.getClass();
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                String string = methodArray[n].getName();
                if (string.startsWith("get")) {
                    Method method = methodArray[n];
                    String string2 = string.substring(3);
                    String string3 = "set" + string2;
                    try {
                        Method method2 = clazz.getMethod(string3, methodArray[n].getReturnType());
                        method2.invoke((Object)nSMEvent, method.invoke((Object)this, new Object[0]));
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            return nSMEvent;
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)("Failed to clone event " + this.getEventID()));
            return null;
        }
    }

    public NSMEvent() {
        this.assignEventID();
    }

    public NSMEvent(int n, String string, long l, String string2, long l2, String string3, String string4, Object object, String string5, String[] stringArray, String string6, String string7, Object[] objectArray, long l3) {
        this.setSeverity(n);
        this.setSource(string);
        this.setSourceSequenceNumber(l);
        this.setSubject(string2);
        this.setSubjectTime(l2);
        this.setTopic(string3);
        this.setType(string4);
        this.setPayload(object);
        this.setPayloadType(string5);
        this.setCorrelatedEvents(stringArray);
        this.setEventID(string6);
        this.setDescriptionCode(string7);
        this.setDescriptionInfo(objectArray);
        this.setSourceTime(l3);
    }

    public NSMEvent(int n, String string, long l, String string2, long l2, String string3, String string4, Object object, String string5, String[] stringArray, String string6, long l3) {
        this.setSeverity(n);
        this.setSource(string);
        this.setSourceSequenceNumber(l);
        this.setSubject(string2);
        this.setSubjectTime(l2);
        this.setTopic(string3);
        this.setType(string4);
        this.setPayload(object);
        this.setPayloadType(string5);
        this.setCorrelatedEvents(stringArray);
        this.setEventID(string6);
        this.setSourceTime(l3);
    }

    public NSMEvent(String string, String string2, String string3) throws IllegalArgumentException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null) {
            Report.info.log("Source Field of Event is null");
            throw new IllegalArgumentException();
        }
        if (string3 == null) {
            Report.info.log("Topic Field of Event is null");
            throw new IllegalArgumentException();
        }
        if (string == null) {
            Report.info.log("Subject Field of Event is null");
            throw new IllegalArgumentException();
        }
        this.assignEventID();
        super.setSubject(string);
        super.setSource(string2);
        super.setTopic(string3);
        super.setType(this.getClass().getPackage().getName());
        super.setSourceSequenceNumber(System.currentTimeMillis());
    }

    private void assignEventID() {
        this.setEventID(OID.getKey());
    }

    public String toXML() {
        Object object;
        int n;
        Object[] objectArray;
        XMLTag xMLTag = new XMLTag("common:ESMEvent");
        Class<?> clazz = this.getClass();
        do {
            objectArray = clazz.getDeclaredMethods();
            n = 0;
            while (n < objectArray.length) {
                object = objectArray[n].getName();
                if (!(((String)object).equals("getCorrelatedEvents") || ((String)object).equals("getDescriptionInfo") || ((String)object).equals("getPayload") || ((String)object).equals("getClass") || ((String)object).equals("getDescriptionCode") || ((String)object).equals("getDescriptionInfo") || ((String)object).equals("getPostSequenceNumber") || !((String)object).startsWith("get"))) {
                    Object object2 = null;
                    try {
                        object2 = ((Method)objectArray[n]).invoke((Object)this, new Object[0]);
                        object = ((String)object).substring(3);
                        xMLTag.addAttribute((String)object, object2.toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n;
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        objectArray = this.getCorrelatedEvents();
        if (objectArray != null) {
            n = 0;
            while (n < objectArray.length) {
                object = new XMLTag("common:corrEvent");
                ((XMLTag)object).addContent(objectArray[n]);
                xMLTag.addContent(object);
                ++n;
            }
        }
        if (this.getPayload() != null) {
            xMLTag.addContent(this.getPayload());
        }
        return xMLTag.toString();
    }

    protected boolean validatePayload(Object object, StringBuffer stringBuffer) {
        boolean bl = true;
        if (object == null) {
            stringBuffer.append('\n');
            stringBuffer.append("Payload Object is Null");
            Report.info.log("Payload Object is Null");
            bl = false;
        }
        if (!(object instanceof Serializable)) {
            stringBuffer.append('\n');
            stringBuffer.append("Payload Object not Serializable");
            Report.info.log("Payload Object not Serializable");
            bl = false;
        }
        if (!bl) {
            return bl;
        }
        return bl;
    }

    protected boolean validateBaseFields(StringBuffer stringBuffer) {
        boolean bl = true;
        if (this.getSource() == null) {
            stringBuffer.append('\n');
            stringBuffer.append("Source Field of Event is null");
            Report.info.log("Source Field of Event is null");
            bl = false;
        } else if (this.getTopic() == null) {
            stringBuffer.append('\n');
            stringBuffer.append("Topic Field of Event is null");
            Report.info.log("Topic Field of Event is null");
            bl = false;
        } else if (this.getSubject() == null) {
            stringBuffer.append('\n');
            stringBuffer.append("Subject Field of Event is null");
            Report.info.log("Subject Field of Event is null");
            bl = false;
        } else if (this.getType() == null) {
            stringBuffer.append('\n');
            stringBuffer.append("Type Field of Event is null");
            Report.info.log("Type Field of Event is null");
            bl = false;
        }
        if (!bl) {
            return bl;
        }
        return bl;
    }

    public String getTerse(Locale locale) {
        return this.getVerbose(locale);
    }

    public String getVerbose(Locale locale) {
        return Formatter.format(locale, this);
    }

    public String toString() {
        return "";
    }

    public void setStationID(String string) {
        this.stationID = string;
    }

    public String getStationID() {
        return this.stationID;
    }

    public void setStationURL(String string) {
        this.stationURL = string;
    }

    public String getStationURL() {
        return this.stationURL;
    }
}

