/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.health;

import com.sun.jade.apps.persistence.service.CIMBeanPersistence;
import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.NoDataFoundException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.service.StatisticsPersistence;
import com.sun.jade.cim.bean.CIM_ManagedSystemElement;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanBase;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.device.util.BeanHandler;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.logic.health.HealthEvent;
import com.sun.jade.logic.health.HealthHandler;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.mediator.Filter;
import com.sun.jade.mediator.FilterChecker;
import com.sun.jade.mediator.FilterEvaluationException;
import com.sun.jade.mediator.FilterParseException;
import com.sun.jade.mediator.Predicate;
import com.sun.jade.message.MessageGroup;
import com.sun.jade.policy.FilterAction;
import com.sun.jade.policy.FilterActionInfo;
import com.sun.jade.policy.PolicyException;
import com.sun.jade.policy.PolicyGroup;
import com.sun.jade.policy.PolicyServiceImpl;
import com.sun.jade.policy.StatisticInfo;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class HealthMonitor {
    private MF mf;
    private PolicyGroup pg;
    private String type;
    private String name;
    private String className;
    private HealthHandler handler;
    private Vector filters;
    private Vector msgFilters;
    private static String TAG = "Health";
    private static HashMap mflist = new HashMap();
    static String MSG_CODE_KEY = "_msgcode";
    static String MSG_CODE_ARGS = "args";
    private CIMBeanPersistence persistence;
    public static final String sccs_id = "@(#)HealthMonitor.java\t1.34 01/30/03 SMI";

    public HealthMonitor(MF mF) {
        this.mf = mF;
        this.handler = new HealthHandler(this);
        DevTypeData devTypeData = (DevTypeData)mflist.get(this.className);
        if (devTypeData == null) {
            Report.trace.log(TAG, (Object)("Initializing policy for " + this.className));
            this.filters = new Vector();
            this.pg = this.initPolicy(this.mf);
            devTypeData = new DevTypeData(this.pg, this.filters, this.msgFilters);
            mflist.put(this.className, devTypeData);
        } else {
            this.pg = devTypeData.getPolicyGroup();
            this.filters = devTypeData.getFilters();
            this.msgFilters = devTypeData.getMsgCodeFilters();
        }
    }

    public void updateBean(CIMBean cIMBean) {
        this.updateBean(cIMBean, null);
    }

    public void updateBean(CIMBean cIMBean, CIMBean cIMBean2) {
        if (cIMBean == null) {
            return;
        }
        if (StoradeEnvironment.getState() == 2) {
            return;
        }
        try {
            this.initPersistence();
            if (cIMBean2 == null) {
                try {
                    cIMBean2 = this.persistence.retrieveBean(cIMBean);
                }
                catch (Exception exception) {
                    cIMBean2 = null;
                }
            }
            if (cIMBean2 == null) {
                this.evalFilters(cIMBean2, cIMBean);
                this.persistence.storeCIMBean(cIMBean);
            } else if (!CIMBeanUtil.deepEquals(cIMBean2, cIMBean)) {
                this.evalFilters(cIMBean2, cIMBean);
                this.persistence.storeCIMBean(cIMBean);
            }
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Error Connecting to Persistence");
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error Persisting CIMBean.");
        }
    }

    public void updateSystemStatus(MFStatus mFStatus) {
        CIMBean cIMBean = null;
        String string = "unknown";
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(this.mf.getClassName());
            cIMObjectPath.addKey("Name", new CIMValue((Object)this.mf.getName()));
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)this.mf.getClassName()));
            string = cIMObjectPath.toString();
            cIMBean = CIMBeanUtil.createBean(cIMObjectPath);
            this.initPersistence();
            CIM_ManagedSystemElement cIM_ManagedSystemElement = (CIM_ManagedSystemElement)this.persistence.retrieveBean(cIMBean);
            CIMBean cIMBean2 = (CIMBean)cIM_ManagedSystemElement.clone();
            cIM_ManagedSystemElement.setStatus(mFStatus.getMappedValue());
            this.updateBean((CIMBean)cIM_ManagedSystemElement, cIMBean2);
        }
        catch (NoDataFoundException noDataFoundException) {
            this.updateBean(cIMBean);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)("Unable to find/update status for " + string));
        }
    }

    private PolicyGroup initPolicy(MF mF) {
        try {
            Object object;
            Properties properties = mF.getProperties();
            this.type = properties.getProperty("type");
            Properties properties2 = DevInfo.getDeviceProperties(this.type);
            String string = properties2.getProperty("BASE_MESSAGE_CODE");
            if (string != null) {
                object = new StringTokenizer(string, ",");
                Report.debug.log(TAG, (Object)("Loading message code policies " + string));
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.setMessageCodeFilters(new MessageGroup(((StringTokenizer)object).nextToken()));
                }
            }
            if ((object = properties2.getProperty("PolicyGroup.properties")) != null) {
                PolicyServiceImpl policyServiceImpl = PolicyServiceImpl.getService();
                ResourceBundle resourceBundle = ResourceBundle.getBundle(properties2.getProperty("PolicyGroup.properties"));
                String string2 = resourceBundle.getString("PolicyGroup.PolicyRole");
                this.pg = policyServiceImpl.getPolicyGroup(this.className, string2);
                this.startPolicy(this.pg);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (PolicyException policyException) {
            Report.error.log(policyException, (Object)"Policy init failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.warning.log(illegalArgumentException, (Object)"No policy for device.");
        }
        return this.pg;
    }

    private void setMessageCodeFilters(MessageGroup messageGroup) {
        if (this.msgFilters == null) {
            this.msgFilters = new Vector();
        }
        Map map = messageGroup.getMessagePropertiesMap();
        TreeMap treeMap = new TreeMap(map);
        Set set = treeMap.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Properties properties = (Properties)entry.getValue();
            String string2 = properties.getProperty("filter.property");
            if (string2 == null) continue;
            properties.setProperty(MSG_CODE_KEY, string);
            this.msgFilters.add(properties);
        }
    }

    private void startPolicy(PolicyGroup policyGroup) {
        policyGroup.activate();
        Vector vector = policyGroup.getGroupFilters();
        int n = 0;
        while (n < vector.size()) {
            com.sun.jade.policy.Filter filter = (com.sun.jade.policy.Filter)vector.elementAt(n);
            String string = filter.toString();
            String string2 = filter.getTopic();
            String string3 = filter.getFilterAction();
            if (Report.trace.isEnabled(TAG)) {
                Report.trace.log("Filter add: query=" + string + " topic=" + string2 + " type=" + this.type + " name=" + this.name);
            }
            try {
                Filter filter2 = new Filter(string, string2, this.type, this.name);
                filter2.setAction(string3);
                this.filters.add(filter2);
            }
            catch (FilterParseException filterParseException) {
                Report.error.log(filterParseException, (Object)"Filter init failed.");
            }
            ++n;
        }
    }

    public BeanHandler getBeanHandler() {
        return this.handler;
    }

    public MF getDevice() {
        return this.mf;
    }

    public void evalMsgCodeFilters(CIMBean cIMBean, CIMBean cIMBean2) {
        Report.trace.log(TAG, (Object)"Evaluating message code filter.");
        Class<?> clazz = cIMBean2.getClass();
        HealthEvent healthEvent = null;
        int n = 0;
        while (n < this.msgFilters.size()) {
            block15: {
                Properties properties = (Properties)this.msgFilters.get(n);
                String string = properties.getProperty("filter.property");
                int n2 = string.indexOf(".");
                String string2 = string.substring(0, n2);
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName("com.sun.jade.cim.bean." + string2);
                }
                catch (Exception exception) {
                    break block15;
                }
                if (clazz2 != null && clazz2.isAssignableFrom(clazz)) {
                    if (Report.debug.isEnabled(TAG)) {
                        Report.debug.log("Evaluating message code filter " + string + ":" + properties.getProperty(MSG_CODE_KEY));
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2 + 1), "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3;
                        Object object;
                        String string4 = stringTokenizer.nextToken();
                        Object object2 = cIMBean2 == null ? null : CIMBeanUtil.getAttributeValue(cIMBean2, string4);
                        Object object3 = object = cIMBean == null ? null : CIMBeanUtil.getAttributeValue(cIMBean, string4);
                        if (CIMBeanUtil.attributeEquals(object2, object)) continue;
                        if (Report.debug.isEnabled(TAG)) {
                            Report.debug.log("Bean value, " + string4 + ", changed from " + object + " to " + object2);
                        }
                        if (healthEvent == null) {
                            healthEvent = new HealthEvent(this.mf, cIMBean, cIMBean2);
                        }
                        if ((string3 = properties.getProperty("filter.previous")) == null) {
                            string3 = "*";
                        }
                        if (!this.attrCheck(string3, object)) continue;
                        String string5 = properties.getProperty("filter.current");
                        if (string5 != null) {
                            if (!this.attrCheck(string5, object2)) continue;
                            healthEvent.createMsgCodeEvent(properties);
                            continue;
                        }
                        string5 = properties.getProperty("filter.current!");
                        if (string5 != null) {
                            if (this.attrCheck(string5, object2)) continue;
                            healthEvent.createMsgCodeEvent(properties);
                            continue;
                        }
                        String string6 = properties.getProperty("filter.over");
                        if (string6 != null) {
                            if (!(object2 instanceof Number)) continue;
                            long l = Long.parseLong(string6);
                            long l2 = ((Number)object2).longValue();
                            if (l2 <= l) continue;
                            healthEvent.createMsgCodeEvent(properties);
                            continue;
                        }
                        String string7 = properties.getProperty("filter.under");
                        if (string7 != null) {
                            if (!(object2 instanceof Number)) continue;
                            long l = Long.parseLong(string7);
                            long l3 = ((Number)object2).longValue();
                            if (l3 >= l) continue;
                            healthEvent.createMsgCodeEvent(properties);
                            continue;
                        }
                        String string8 = properties.getProperty("filter.statistics");
                        if (string8 != null) {
                            if (!this.evalStatistics(string8, string4, object2, object, cIMBean, cIMBean2)) continue;
                            healthEvent.createMsgCodeEvent(properties);
                            continue;
                        }
                        if (!this.attrCheck("*", object2)) continue;
                        healthEvent.createMsgCodeEvent(properties);
                    }
                }
            }
            ++n;
        }
        if (healthEvent != null) {
            healthEvent.generateEvents();
        }
    }

    private boolean evalStatistics(String string, String string2, Object object, Object object2, CIMBean cIMBean, CIMBean cIMBean2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string3 = "0";
        String string4 = "0";
        String string5 = "0";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        long l = Long.parseLong(string3);
        long l2 = ((Number)object).longValue();
        int n = Integer.parseInt(string4);
        int n2 = Integer.parseInt(string5);
        if (n == 0) {
            long l3 = ((Number)object2).longValue();
            long l4 = l2 - l3;
            if (l4 < 0L) {
                l4 *= -1L;
            }
            if (l4 > l) {
                return true;
            }
        } else {
            Object object3;
            CIMObjectPath cIMObjectPath = cIMBean2.getCIMObjectPath();
            ReferenceForMSE referenceForMSE = new ReferenceForMSE(cIMObjectPath);
            Date date = new Date();
            Date date2 = new Date(date.getTime() - (long)(n * 1000));
            Iterator iterator = null;
            try {
                object3 = PersistenceService.getService();
                StatisticsPersistence statisticsPersistence = ((PersistenceService)object3).getStatisticsPersistence();
                iterator = statisticsPersistence.getStatisticsByAttr(referenceForMSE, date2, date, string2);
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Reading Statistics from persistence");
                return false;
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object3 = (StatisticInfo)iterator.next();
                    long l5 = Long.parseLong(((StatisticInfo)object3).getOldValue());
                    long l6 = l2 - l5;
                    if (l6 <= l) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean attrCheck(String string, Object object) {
        if (string.indexOf(124) > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (!this.attrCheckOne(stringTokenizer.nextToken(), object)) continue;
                return true;
            }
            return false;
        }
        return this.attrCheckOne(string, object);
    }

    private boolean attrCheckOne(String string, Object object) {
        if ("**".equals(string)) {
            return true;
        }
        if ("*".equals(string)) {
            return object != null;
        }
        if ("null".equals(string) && object == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return string.equals(object.toString());
    }

    public void evalFilters(CIMBean cIMBean, CIMBean cIMBean2) {
        if (cIMBean2 == null) {
            return;
        }
        if (this.msgFilters != null && this.msgFilters.size() > 0) {
            this.evalMsgCodeFilters(cIMBean, cIMBean2);
        }
        Class<?> clazz = cIMBean2.getClass();
        int n = 0;
        while (n < this.filters.size()) {
            block15: {
                Filter filter = (Filter)this.filters.elementAt(n);
                boolean bl = false;
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName("com.sun.jade.cim.bean." + filter.getClassName());
                }
                catch (Exception exception) {
                    break block15;
                }
                if (clazz2 != null && clazz2.isAssignableFrom(clazz)) {
                    Vector vector = filter.getPredicates();
                    if (vector == null || vector.size() == 0) {
                        this.createEvent(cIMBean2, cIMBean, filter);
                        return;
                    }
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        boolean bl2;
                        Predicate predicate = (Predicate)vector.get(n2);
                        String string = predicate.getAttributeName();
                        Object object = CIMBeanUtil.getAttributeValue(cIMBean2, string);
                        Object object2 = cIMBean == null ? null : CIMBeanUtil.getAttributeValue(cIMBean, string);
                        boolean bl3 = bl2 = !CIMBeanUtil.attributeEquals(object, object2);
                        if (bl2) {
                            boolean bl4;
                            if (Report.debug.isEnabled(TAG)) {
                                Report.debug.log("Bean value, " + predicate.getAttributeName() + ", changed from " + object2 + " to " + object);
                            }
                            if (predicate.getOperator() == 7) {
                                bl4 = true;
                            } else {
                                try {
                                    bl4 = FilterChecker.makeComparison(object, predicate.getOperator(), predicate.getTargetValue());
                                }
                                catch (FilterEvaluationException filterEvaluationException) {
                                    Report.error.log(filterEvaluationException, (Object)"Filter Evaluation Failed");
                                    bl4 = false;
                                }
                            }
                            bl = n2 == 0 ? bl4 : (predicate.getLogicalOperator() == 1 ? (bl &= bl4) : (bl |= bl4));
                        }
                        ++n2;
                    }
                    if (bl) {
                        this.createEvent(cIMBean2, cIMBean, filter);
                        return;
                    }
                }
            }
            ++n;
        }
    }

    private CIMBeanBase cloneBean(CIMBeanBase cIMBeanBase) {
        if (cIMBeanBase == null) {
            return null;
        }
        return (CIMBeanBase)CIMBeanUtil.createBean(cIMBeanBase.getCIMObjectPath());
    }

    private void createEvent(CIMBean cIMBean, CIMBean cIMBean2, Filter filter) {
        String string = filter.getAction();
        if (string != null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
                FilterAction filterAction = (FilterAction)clazz.newInstance();
                FilterActionInfo filterActionInfo = new FilterActionInfo(this.mf, this.pg, filter.getFilterID(), filter.getTopic());
                filterAction.doAction(cIMBean, cIMBean2, filterActionInfo);
            }
            catch (Exception exception) {}
        } else {
            ArrayList<CIMBean> arrayList = new ArrayList<CIMBean>(2);
            arrayList.add(cIMBean);
            if (cIMBean2 != null) {
                arrayList.add(cIMBean2);
            }
            if (Report.debug.isEnabled(TAG)) {
                Report.debug.log("Evaluating State Change Event for " + filter.getTopic());
            }
            this.pg.evaluate(arrayList);
        }
    }

    CIMBeanPersistence initPersistence() {
        try {
            this.name = this.mf.getName();
            this.className = this.mf.getClassName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this.persistence != null) {
            return this.persistence;
        }
        try {
            this.persistence = PersistenceService.getService().getCIMBeanPersistence();
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Error Finding Persistence");
        }
        return this.persistence;
    }

    private static class DevTypeData {
        private PolicyGroup s_pg;
        private Vector s_filters;
        private Vector s_msg_filters;

        DevTypeData(PolicyGroup policyGroup, Vector vector, Vector vector2) {
            this.s_pg = policyGroup;
            this.s_filters = vector;
            this.s_msg_filters = vector2;
        }

        PolicyGroup getPolicyGroup() {
            return this.s_pg;
        }

        Vector getFilters() {
            return this.s_filters;
        }

        Vector getMsgCodeFilters() {
            return this.s_msg_filters;
        }
    }
}

