/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.mf;

import com.sun.jade.apps.diags.lib.DeviceDiagnosableHelper;
import com.sun.jade.apps.diags.lib.DiagnosableHelper;
import com.sun.jade.apps.topology.lib.DeviceTopologyHelperImpl;
import com.sun.jade.cim.diag.TestTemplate;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.device.util.BeanHandler;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.device.util.DeviceHandler;
import com.sun.jade.device.util.DeviceReportExceptionParser;
import com.sun.jade.device.util.DeviceStore;
import com.sun.jade.device.util.ReportParser;
import com.sun.jade.event.DefinitionEventGenerator;
import com.sun.jade.logic.health.HealthMonitor;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.mf.MFAdmin;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.mf.ServiceException;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.logic.view.ViewHelper;
import com.sun.jade.logic.view.ViewHelperImpl;
import com.sun.jade.logic.wbem.CIMBeanHelper;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Properties;

public abstract class AbstractMF
implements MF {
    private MFAdmin admin = new Admin(this);
    private MFStatus status = MFStatus.NO_CONTACT;
    private boolean started;
    private ReportGenerator reportGenerator;
    private HealthMonitor healthMonitor;
    private ViewHelper viewHelper;
    private CIMBeanHelper healthHelper;
    private DiagnosableHelper diagHelper;
    private DeviceHandler devHandler;
    private DeviceStore deviceStore;
    private Properties properties;
    private BeanHandler[] beanHandlers;
    private DeviceTopologyHelperImpl topologyHelper;
    private static final String sccs_id = "@(#)AbstractMF.java\t1.47 12/06/02 SMI";

    protected AbstractMF(Properties properties) {
        this.properties = properties;
        this.resolveIP(this.properties);
    }

    public abstract String getClassName();

    public abstract String getName();

    public abstract LocalizedMessage getCaption();

    public abstract LocalizedMessage getDescription();

    public final String getManagerName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        return string;
    }

    public final Properties getProperties() {
        return this.properties;
    }

    public final void setProperties(Properties properties) throws IllegalArgumentException {
        this.properties = properties;
    }

    public final ServiceHelper[] getServiceHelpers() throws RemoteException {
        int n = 0;
        if (this.viewHelper != null) {
            ++n;
        }
        if (this.topologyHelper != null) {
            ++n;
        }
        if (this.healthHelper != null) {
            ++n;
        }
        if (this.diagHelper != null) {
            ++n;
        }
        ServiceHelper[] serviceHelperArray = new ServiceHelper[n];
        int n2 = 0;
        if (this.viewHelper != null) {
            serviceHelperArray[n2++] = this.viewHelper;
        }
        if (this.topologyHelper != null) {
            serviceHelperArray[n2++] = this.topologyHelper;
        }
        if (this.healthHelper != null) {
            serviceHelperArray[n2++] = this.healthHelper;
        }
        if (this.diagHelper != null) {
            serviceHelperArray[n2++] = this.diagHelper;
        }
        return serviceHelperArray;
    }

    public final ServiceHelper getServiceHelper(String string) throws RemoteException {
        Class<?> clazz;
        ServiceHelper[] serviceHelperArray = this.getServiceHelpers();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Report.warning.log(classNotFoundException.toString());
            return null;
        }
        int n = 0;
        while (n < serviceHelperArray.length) {
            if (clazz.isInstance(serviceHelperArray[n])) {
                return serviceHelperArray[n];
            }
            ++n;
        }
        return null;
    }

    public final MFAdmin getAdmin() {
        return this.admin;
    }

    protected final void setDeviceReport(ReportGenerator reportGenerator) {
        String string;
        if (this.viewHelper == null) {
            this.viewHelper = this.newViewHelper();
        }
        if (this.healthMonitor == null) {
            this.healthMonitor = this.newHealthMonitor();
        }
        if (this.topologyHelper == null) {
            this.topologyHelper = this.newTopologyHelper();
        }
        this.deviceStore = new DeviceStore(this);
        this.beanHandlers = new BeanHandler[2];
        this.beanHandlers[0] = this.topologyHelper.getBeanHandler();
        this.beanHandlers[1] = this.healthMonitor.getBeanHandler();
        String string2 = this.properties.getProperty("discovered");
        if (string2 != null && !"".equals(string2.trim()) && (string = this.deviceStore.getReport()) != null) {
            BeanHandler[] beanHandlerArray = new BeanHandler[]{this.beanHandlers[0]};
            ReportParser reportParser = new ReportParser();
            reportParser.setReport(string);
            reportParser.parseReport(beanHandlerArray);
            this.status = this.topologyHelper.getParsedMFStatus();
        }
        this.reportGenerator = reportGenerator;
        DeviceHandler.addDevice(reportGenerator, this);
        this.started = true;
    }

    protected void updateDeviceReport(String string) {
    }

    public final void updateBean(CIMBean cIMBean) {
        this.healthMonitor.updateBean(cIMBean);
    }

    protected final void addDiagnosticTest(TestTemplate testTemplate) {
        if (this.diagHelper == null) {
            this.diagHelper = new DeviceDiagnosableHelper(this);
        }
        ((DeviceDiagnosableHelper)this.diagHelper).addDiagnosticTest(testTemplate);
    }

    public void updateDeviceConfig() {
        DeviceConfig deviceConfig = StoradeEnvironment.getDeviceConfig();
        if (deviceConfig != null) {
            deviceConfig.store();
        } else {
            Report.error.log("No device configuration available for update.");
        }
    }

    public DeviceStore getDeviceStore() {
        return this.deviceStore;
    }

    public final void updateStatus(String string, ReportParser reportParser, DeviceReportExceptionParser deviceReportExceptionParser) {
        if (string == null) {
            Report.error.log("AbstractMF.updateStatus: get null report for " + this.getName());
            return;
        }
        deviceReportExceptionParser.parse(string);
        if ("OK".equals(deviceReportExceptionParser.getReturnCode())) {
            Object object;
            if (this.beanHandlers != null) {
                this.deviceStore.parseReport(reportParser);
                this.deviceStore.saveReport(string);
                reportParser.setReport(string);
                reportParser.parseReport(this.beanHandlers);
            }
            if (this.topologyHelper != null && !this.status.equals(object = this.topologyHelper.getParsedMFStatus())) {
                this.status = object;
                this.healthMonitor.updateSystemStatus(this.status);
            }
            if ((object = this.properties.getProperty("discovered")) == null || "".equals(((String)object).trim())) {
                Report.debug.log("Discover event for " + this.getName());
                Properties properties = DevInfo.getDeviceProperties(this.properties.getProperty("type"));
                String string2 = properties.getProperty("RESOURCE_TYPE");
                if ("host".equals(string2)) {
                    DefinitionEventGenerator.generateHostEvent(this, 6);
                } else {
                    DefinitionEventGenerator.generateDeviceEvent(this, 1);
                }
                this.properties.setProperty("discovered", new Date().toString());
                this.updateDeviceConfig();
            }
        } else {
            Report.debug.log("Got report with return code failure. " + deviceReportExceptionParser.getExceptionReason());
            if (deviceReportExceptionParser.getExceptionReason() != null) {
                try {
                    this.status = new MFStatus(deviceReportExceptionParser.getExceptionReason());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.status = MFStatus.UNKNOWN;
                }
            } else {
                this.status = MFStatus.UNKNOWN;
            }
            this.healthMonitor.updateSystemStatus(this.status);
        }
    }

    protected MFAdmin newMFAdmin() {
        return new Admin(this);
    }

    protected HealthMonitor newHealthMonitor() {
        return new HealthMonitor(this);
    }

    protected ViewHelper newViewHelper() {
        return new ViewHelperImpl(this);
    }

    protected DeviceTopologyHelperImpl newTopologyHelper() {
        return new DeviceTopologyHelperImpl(this);
    }

    protected final String resolveIP(Properties properties) {
        String string;
        String string2;
        InetAddress inetAddress;
        boolean bl = false;
        String string3 = properties.getProperty("ip");
        try {
            inetAddress = InetAddress.getByName(string3);
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = properties.getProperty("ipno");
            if (string2 == null) {
                throw new IllegalArgumentException("Unknown ip " + string3);
            }
            string3 = string2;
            try {
                inetAddress = InetAddress.getByName(string3);
            }
            catch (UnknownHostException unknownHostException2) {
                throw new IllegalArgumentException("Unknown ip " + string3);
            }
        }
        String string4 = properties.getProperty("ipno");
        if (string4 == null || !string4.equals(string2)) {
            properties.setProperty("ipno", string2);
            bl = true;
        }
        if ((string = properties.getProperty("logicalName")) == null) {
            properties.setProperty("logicalName", inetAddress.getHostName());
            this.updateDeviceConfig();
        }
        if (bl) {
            bl = true;
        }
        return string3;
    }

    protected void shutdown() {
    }

    private class Admin
    implements MFAdmin {
        private AbstractMF mf;

        Admin(AbstractMF abstractMF2) {
            this.mf = abstractMF2;
        }

        public MFStatus getStatus() {
            return AbstractMF.this.status;
        }

        public boolean isStarted() {
            return AbstractMF.this.started;
        }

        public void startService() throws ServiceException {
            if (AbstractMF.this.started) {
                return;
            }
            if (AbstractMF.this.reportGenerator != null) {
                AbstractMF.this.setDeviceReport(AbstractMF.this.reportGenerator);
            }
        }

        public void stopService() throws ServiceException {
            if (!AbstractMF.this.started) {
                return;
            }
            AbstractMF.this.shutdown();
            if (AbstractMF.this.devHandler == null) {
                AbstractMF.this.devHandler = DeviceHandler.getDeviceHandler();
            }
            AbstractMF.this.devHandler.removeDevice(this.mf);
            AbstractMF.this.devHandler = null;
            AbstractMF.this.healthHelper = null;
            AbstractMF.this.started = false;
        }
    }
}

