/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.logic.wbem;

import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMReference;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.device.util.ReportSearcher;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.logic.wbem.CIMBeanHelper;
import com.sun.jade.logic.wbem.IndicationListener;
import com.sun.jade.mediator.DeviceHelper;
import com.sun.jade.mediator.DeviceManager;
import com.sun.jade.mediator.Filter;
import com.sun.jade.mediator.FilterParseException;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class CIMBeanHelperImpl
implements CIMBeanHelper {
    private DeviceManager device;
    private MF currentMF;

    public CIMBeanHelperImpl(DeviceManager deviceManager, MF mF) throws RemoteException, IllegalArgumentException {
        if (deviceManager == null) {
            throw new IllegalArgumentException("DeviceManager reference is null");
        }
        this.device = deviceManager;
        this.currentMF = mF;
    }

    public String getHelperName() throws RemoteException {
        return "CIMBeanHelper";
    }

    public MF getMF() throws RemoteException {
        return this.currentMF;
    }

    public CIMReference getManagedSystem() throws RemoteException {
        CIMObjectPath cIMObjectPath = null;
        cIMObjectPath = DeviceHelper.getSystemObjectPath(this.device);
        return new CIMReference(cIMObjectPath);
    }

    public void setAccess(Principal principal, Object object) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public CIMBean[] enumerateBeans(CIMObjectPath cIMObjectPath) throws RemoteException {
        ArrayList arrayList = null;
        CIMBean[] cIMBeanArray = null;
        String string = cIMObjectPath.getObjectName();
        DeviceReport.DeviceGraph deviceGraph = this.device.getGraph();
        ArrayList arrayList2 = deviceGraph.getBeans();
        try {
            arrayList = ReportSearcher.enumerateBeans(string, arrayList2);
            if (arrayList != null) {
                cIMBeanArray = arrayList.toArray(new CIMBean[arrayList.size()]);
            }
        }
        catch (Exception exception) {
            Report.error.log(exception.toString());
        }
        return cIMBeanArray;
    }

    public CIMReference[] enumerateBeanNames(CIMObjectPath cIMObjectPath) throws RemoteException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public CIMBean getBean(CIMObjectPath cIMObjectPath) throws RemoteException {
        CIMBean cIMBean = null;
        String string = cIMObjectPath.getObjectName();
        DeviceReport.DeviceGraph deviceGraph = this.device.getGraph();
        if (deviceGraph != null) {
            ArrayList arrayList = deviceGraph.getBeans();
            try {
                cIMBean = ReportSearcher.findBean(cIMObjectPath, arrayList);
            }
            catch (Exception exception) {
                Report.error.log(exception.toString());
            }
        }
        return cIMBean;
    }

    public String subscribeForIndication(String string, String string2, IndicationListener indicationListener) throws RemoteException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String subscribeForIndication(String string, String string2) throws RemoteException {
        String string3 = null;
        try {
            Filter filter = new Filter(string, string2, this.device.getType(), this.device.getName());
            string3 = this.device.addFilter(filter);
        }
        catch (FilterParseException filterParseException) {
            Report.error.log(filterParseException.getLocalizedMessage());
        }
        catch (StorAdeException storAdeException) {
            Report.info.log(storAdeException.getLocalizedMessage());
        }
        catch (Exception exception) {
            Report.error.log(exception.toString());
        }
        return string3;
    }

    public void unsubscribeIndication(String string) throws RemoteException {
        this.device.removeFilter(string);
    }

    public CIMBean[] getAssociatedBeans(CIMObjectPath cIMObjectPath) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public CIMBean[] getAssociatedBeans(CIMObjectPath cIMObjectPath, String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public CIMBean[] getAssociations(CIMObjectPath cIMObjectPath) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public CIMBean[] getAssociations(CIMObjectPath cIMObjectPath, String string) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Vector getRelatedObjects(CIMObjectPath cIMObjectPath) throws RemoteException {
        Vector vector = null;
        DeviceReport.DeviceGraph deviceGraph = this.device.getGraph();
        if (deviceGraph != null) {
            ArrayList arrayList = deviceGraph.getBeans();
            Hashtable hashtable = deviceGraph.getAssociations();
            vector = new Vector();
            try {
                vector = ReportSearcher.getRelatedObjects(cIMObjectPath, arrayList, hashtable);
            }
            catch (Exception exception) {
                Report.error.log(exception.toString());
                vector = null;
            }
        }
        return vector;
    }
}

