/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.mediator;

import com.sun.jade.cim.bean.CIM_SystemDevice;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.device.util.DevInfo;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.event.EventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.mediator.DeviceManager;
import com.sun.jade.mediator.EventPoster;
import com.sun.jade.mediator.Filter;
import com.sun.jade.mediator.FilterChecker;
import com.sun.jade.message.MessageCode;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.jade.util.log.Report;
import com.sun.wbem.cim.CIMObjectPath;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class DeviceHelper {
    static ArrayList getDeviceMSEs(DeviceManager deviceManager) {
        String string = deviceManager.getSystemData();
        DeviceReport deviceReport = new DeviceReport(string);
        ArrayList arrayList = (ArrayList)deviceReport.toBeans();
        return arrayList;
    }

    static ArrayList getSystemAndDevices(DeviceManager deviceManager, ArrayList arrayList) {
        CIMBean cIMBean = DeviceHelper.getSystemObject(deviceManager, arrayList);
        ArrayList arrayList2 = DeviceHelper.getSystemDevices(arrayList);
        if (cIMBean != null) {
            arrayList2.add(cIMBean);
        }
        return arrayList2;
    }

    static CIMBean getSystemObject(DeviceManager deviceManager, ArrayList arrayList) {
        CIMBean cIMBean = null;
        Properties properties = DevInfo.getDeviceProperties(deviceManager.getType().toLowerCase());
        String string = properties.getProperty("CLASS_NAME");
        int n = 0;
        while (n < arrayList.size()) {
            cIMBean = (CIMBean)arrayList.get(n);
            String string2 = cIMBean.toString();
            int n2 = string2.indexOf(string);
            if (n2 > -1) {
                arrayList.remove(n);
                break;
            }
            ++n;
        }
        return cIMBean;
    }

    public static CIMObjectPath getSystemObjectPath(DeviceManager deviceManager) {
        CIMObjectPath cIMObjectPath = null;
        ArrayList arrayList = deviceManager.getGraph().getBeans();
        CIMBean cIMBean = null;
        Properties properties = DevInfo.getDeviceProperties(deviceManager.getType().toLowerCase());
        try {
            String string = properties.getProperty("CLASS_NAME");
            int n = 0;
            while (n < arrayList.size()) {
                cIMBean = (CIMBean)arrayList.get(n);
                String string2 = cIMBean.toString();
                int n2 = string2.indexOf(string);
                if (n2 > -1) {
                    cIMObjectPath = cIMBean.getCIMObjectPath();
                    break;
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {
            MessageCode messageCode = new MessageCode("app.sade3.resource.error", 1);
            Object[] objectArray = new Object[]{"CLASS_NAME", deviceManager.getType()};
            Report.error.log(messageCode.toString(objectArray));
        }
        return cIMObjectPath;
    }

    static ArrayList getSystemDevices(ArrayList arrayList) {
        ArrayList<CIMBean> arrayList2 = new ArrayList<CIMBean>();
        int n = 0;
        while (n < arrayList.size()) {
            CIMBean cIMBean = (CIMBean)arrayList.get(n);
            if (cIMBean instanceof CIM_SystemDevice) {
                CIMObjectPath cIMObjectPath = ((CIM_SystemDevice)cIMBean).getPartComponent();
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    CIMBean cIMBean2 = (CIMBean)arrayList.get(n2);
                    CIMObjectPath cIMObjectPath2 = cIMBean2.getCIMObjectPath();
                    if (cIMObjectPath.equals((Object)cIMObjectPath2)) {
                        arrayList2.add(cIMBean2);
                        arrayList.remove(n2);
                        --n2;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (arrayList2.size() == 0) {
            arrayList2 = null;
        }
        return arrayList2;
    }

    static String determineType(String string) {
        String string2 = null;
        int n = string.indexOf(":");
        if (n != -1) {
            string2 = string.substring(0, n);
        } else {
            MessageCode messageCode = new MessageCode("app.sade3.resource.error", 2);
            Object[] objectArray = new Object[]{string};
            Report.error.log(messageCode.toString(objectArray));
        }
        return string2;
    }

    static String determineType(Properties properties) {
        String string = properties.getProperty("type");
        if (string == null) {
            MessageCode messageCode = new MessageCode("app.sade3.resource.error", 7);
            Report.error.log(messageCode.toString());
        }
        return string;
    }

    static boolean isDiscovered(Properties properties) {
        boolean bl = false;
        String string = properties.getProperty("discovered");
        if (string != null && string.trim().length() > 0) {
            bl = true;
        }
        return bl;
    }

    private static void setDiscoveryDate(Properties properties) {
        if (properties != null) {
            Date date = new Date();
            String string = date.toString();
            properties.setProperty("discovered", string);
            DeviceConfig deviceConfig = StoradeEnvironment.getDeviceConfig();
            deviceConfig.updateDevice(properties);
            deviceConfig.store();
        }
    }

    static void sendConnectionStatusEvent(DeviceManager deviceManager, String string) {
        String string2 = ".private.device.Communication" + string + "." + deviceManager.getType();
        EventPoster eventPoster = new EventPoster(deviceManager.getName(), string2);
        eventPoster.postComEvent();
    }

    static void sendDiscoveryEvent(DeviceManager deviceManager) {
        String string = ".definition.create.device." + deviceManager.getCategory() + "." + deviceManager.getSpecificType();
        MessageCode messageCode = new MessageCode("app.sade3.resource.information", 5);
        Object[] objectArray = new Object[]{deviceManager.getType(), deviceManager.getName()};
        DeviceHelper.createAndPost(deviceManager, string, "DeviceDiscovery", messageCode.getMessageCode(), objectArray);
        DeviceHelper.setDiscoveryDate(deviceManager.getProperties());
    }

    static void sendAuditEvent(DeviceManager deviceManager) {
        String string = "..definition.audit.device";
        MessageCode messageCode = new MessageCode("app.sade3.resource.information", 6);
        Object[] objectArray = new Object[]{deviceManager.getType(), deviceManager.getName()};
        DeviceHelper.createAndPost(deviceManager, string, "Audit", messageCode.getMessageCode(), objectArray);
    }

    static void createAndPost(DeviceManager deviceManager, String string, String string2, String string3, Object[] objectArray) {
        Properties properties = DevInfo.getDeviceProperties(deviceManager.getType().toLowerCase());
        String string4 = properties.getProperty("MF.class");
        int n = 3;
        try {
            ArrayList arrayList = DeviceHelper.getDeviceMSEs(deviceManager);
            CIMBean cIMBean = DeviceHelper.getSystemObject(deviceManager, arrayList);
            ArrayList arrayList2 = DeviceHelper.getSystemDevices(arrayList);
            arrayList2.add(0, cIMBean);
            EventData eventData = new EventData(deviceManager.getName(), string2, string, cIMBean.getCIMObjectPath(), n, string4, deviceManager.getName(), arrayList2);
            eventData.setOtherData(arrayList);
            eventData.setDescriptionCode(string3);
            eventData.setDescriptionInfo(objectArray);
            EventGenerator.generateEvent(eventData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageCode messageCode = new MessageCode("app.sade3.resource.error", 3);
            Object[] objectArray2 = new Object[]{string2, illegalArgumentException.toString()};
            Report.error.log(messageCode.toString(objectArray2));
        }
    }

    static void addFilter(DeviceManager deviceManager, Filter filter) throws StorAdeException {
        Vector vector = deviceManager.getFilters();
        if (filter != null) {
            int n = 0;
            while (n < vector.size()) {
                if (filter.equals((Filter)vector.get(n))) {
                    Object[] objectArray = new Object[]{filter.getTopic()};
                    throw new StorAdeException("resource.warning", 1, objectArray);
                }
                ++n;
            }
        } else {
            throw new StorAdeException("resource.warning", 2);
        }
        String string = deviceManager.getName() + ":filter" + System.currentTimeMillis();
        filter.setFilterID(string);
        vector.add(filter);
    }

    static void removeFilter(DeviceManager deviceManager, String string) {
        Vector vector = deviceManager.getFilters();
        if (string != null && vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Filter filter = (Filter)vector.get(n);
                if (string.equals(filter.getFilterID())) {
                    vector.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
    }

    static void checkFilters(DeviceManager deviceManager) {
        Vector vector = deviceManager.getFilters();
        if (vector != null) {
            try {
                FilterChecker filterChecker = new FilterChecker(deviceManager);
                int n = 0;
                while (n < vector.size()) {
                    Filter filter = (Filter)vector.get(n);
                    filterChecker.evaluate(filter);
                    ++n;
                }
            }
            catch (StorAdeException storAdeException) {
                Report.error.log(storAdeException.getLocalizedMessage());
            }
        }
    }
}

