/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.mediator;

import com.sun.jade.device.util.DeviceReport;
import com.sun.jade.logic.service.StorAdeException;
import com.sun.jade.mediator.DeviceHelper;
import com.sun.jade.mediator.Filter;
import java.util.Properties;
import java.util.Vector;

public class DeviceManager {
    private Vector filterList;
    private String deviceKey;
    protected String deviceName;
    protected String deviceType;
    protected String specificType;
    protected String deviceCategory;
    protected Properties deviceProperties;
    protected String priorData = null;
    protected String currentData = null;
    private String newData = null;
    private DeviceReport.DeviceGraph currentGraph = null;
    private DeviceReport.DeviceGraph priorGraph = null;
    private DeviceReport.DeviceGraph newGraph = null;
    private boolean goodConnection;
    private boolean sentDiscoveryEvent;
    protected boolean eventsActive;

    protected DeviceManager(String string, boolean bl) {
        this.deviceKey = string;
        this.filterList = null;
        this.goodConnection = false;
        this.sentDiscoveryEvent = bl;
        this.specificType = this.deviceType = DeviceHelper.determineType(string);
        this.deviceCategory = this.deviceType;
        this.eventsActive = true;
    }

    protected DeviceManager(String string) {
        this.deviceKey = string;
        this.filterList = null;
        this.goodConnection = false;
        this.sentDiscoveryEvent = false;
        this.specificType = this.deviceType = DeviceHelper.determineType(string);
        this.deviceCategory = this.deviceType;
        this.eventsActive = true;
    }

    protected DeviceManager(Properties properties) {
        this.deviceKey = this.deviceKey;
        this.filterList = null;
        this.goodConnection = false;
        this.deviceProperties = properties;
        this.sentDiscoveryEvent = DeviceHelper.isDiscovered(properties);
        this.specificType = this.deviceType = DeviceHelper.determineType(properties);
        this.deviceCategory = this.deviceType;
        this.eventsActive = true;
    }

    protected void startup(int n) {
        Polling polling = new Polling(n, this);
        polling.start();
    }

    protected String getNewData() {
        return null;
    }

    private void moveData() {
        this.priorData = this.currentData;
        this.priorGraph = this.currentGraph;
        this.currentData = this.newData;
        this.currentGraph = this.newGraph;
        this.newData = null;
        this.newGraph = null;
    }

    public final synchronized void updateData() {
        this.newData = this.getNewData();
        if (this.newData == null || this.newData.startsWith("FAILURE")) {
            if (this.goodConnection) {
                this.goodConnection = false;
                DeviceHelper.sendConnectionStatusEvent(this, "Lost");
            }
        } else {
            DeviceReport deviceReport = new DeviceReport(this.newData);
            this.newGraph = deviceReport.toGraph();
            this.moveData();
            if (!this.goodConnection) {
                this.goodConnection = true;
                DeviceHelper.sendConnectionStatusEvent(this, "Gained");
            }
            if (!this.sentDiscoveryEvent) {
                DeviceHelper.sendDiscoveryEvent(this);
                this.sentDiscoveryEvent = true;
            }
            if (this.currentData != null && this.priorData != null && this.eventsActive) {
                DeviceHelper.checkFilters(this);
            }
            this.priorGraph = null;
        }
    }

    public synchronized String addFilter(Filter filter) throws StorAdeException {
        if (this.filterList == null) {
            this.filterList = new Vector();
        }
        DeviceHelper.addFilter(this, filter);
        return filter.getFilterID();
    }

    public synchronized void removeFilter(String string) {
        DeviceHelper.removeFilter(this, string);
    }

    public synchronized DeviceReport.DeviceGraph getGraph() {
        return this.currentGraph;
    }

    synchronized DeviceReport.DeviceGraph getPriorGraph() {
        return this.priorGraph;
    }

    public String getSystemData() {
        return this.currentData;
    }

    public String getPriorData() {
        return this.priorData;
    }

    public String getKey() {
        return this.deviceKey;
    }

    public String getName() {
        return this.deviceName;
    }

    public void setName(String string) {
        this.deviceName = string;
    }

    public String getType() {
        return this.deviceType;
    }

    public String getSpecificType() {
        return this.specificType;
    }

    public String getCategory() {
        return this.deviceCategory;
    }

    public Vector getFilters() {
        return this.filterList;
    }

    void enableEvents() {
        this.eventsActive = true;
    }

    void disableEvents() {
        this.eventsActive = false;
    }

    public boolean areEventsEnabled() {
        return this.eventsActive;
    }

    public Properties getProperties() {
        return this.deviceProperties;
    }

    protected class Polling
    extends Thread {
        private DeviceManager currentDevice;
        private int pollingInterval;
        private static final int MILLISECONDS = 1000;

        Polling(int n, DeviceManager deviceManager2) {
            this.currentDevice = deviceManager2;
            this.pollingInterval = n;
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.currentDevice.updateData();
                        if (this.pollingInterval == 0) {
                            return;
                        }
                        Polling.sleep(this.pollingInterval * 1000);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

