/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.mediator;

import com.sun.jade.device.util.ReportSearcher;
import com.sun.jade.mediator.FilterParseException;
import com.sun.jade.mediator.FilterParser;
import com.sun.wbem.cim.CIMObjectPath;
import java.util.Vector;

public class Filter {
    private String filterID;
    private String deviceType;
    private String deviceName;
    private String topic;
    private String className;
    private Vector predicates;
    private Vector attributesToPost;
    private boolean checksDelta;
    private Vector MSEList;
    private String action;

    public Filter(String string, String string2, String string3, String string4) throws FilterParseException {
        this.filterID = string;
        this.topic = string2;
        this.deviceType = string3;
        this.deviceName = string4;
        FilterParser filterParser = new FilterParser(string);
        this.className = filterParser.getClassName();
        this.predicates = filterParser.getPredicateList();
        this.attributesToPost = filterParser.getAttributeList();
        this.checksDelta = filterParser.getDeltaCheckStatus();
        this.MSEList = new Vector();
    }

    public void addCOP(CIMObjectPath cIMObjectPath) {
        this.MSEList.add(cIMObjectPath);
    }

    public void removeCOP(CIMObjectPath cIMObjectPath) {
        int n = 0;
        while (n < this.MSEList.size()) {
            if (ReportSearcher.matchCOPs(cIMObjectPath, (CIMObjectPath)this.MSEList.get(n))) {
                this.MSEList.remove(n);
                break;
            }
            ++n;
        }
    }

    public boolean postedForElement(CIMObjectPath cIMObjectPath) {
        boolean bl = false;
        int n = 0;
        while (n < this.MSEList.size()) {
            if (ReportSearcher.matchCOPs(cIMObjectPath, (CIMObjectPath)this.MSEList.get(n))) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getTopic() {
        return this.topic;
    }

    public Vector getPredicates() {
        return this.predicates;
    }

    public void setFilterID(String string) {
        this.filterID = string;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public boolean usesDelta() {
        return this.checksDelta;
    }

    public boolean equals(Object object) {
        Filter filter = (Filter)object;
        boolean bl = true;
        if (this.predicates.size() != filter.getPredicates().size()) {
            bl = false;
        } else {
            int n = 0;
            while (n < this.predicates.size()) {
                if (!this.predicates.get(n).equals(filter.getPredicates().get(n))) {
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    private void display() {
        System.out.println(this.filterID);
        System.out.println("\n");
    }

    public static void main(String[] stringArray) {
        String string = "SELECT ALL FROM StorEdgeT3_TemperatureSensor StorEdgeT3_DiskDrive WHERE StorEdgeT3_TemperatureSensor.Name == \"diskDrive\" AND StorEdgeT3_TemperatureSensor.CurrentReading < 45.0";
        String string2 = "SELECT ALL FROM StorEdgeT3_TemperatureSensor WHERE StorEdgeT3_TemperatureSensor.CurrentReading < 45";
        try {
            Filter filter = new Filter(string, ".t3.undertemp", "t3", "purple11");
            filter.display();
            Filter filter2 = new Filter(string2, ".t3.undertemp", "t3", "purple11");
            filter2.display();
            System.out.println("The result of filter1.equals(filter2) is " + filter.equals(filter2));
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }
}

