/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.mediator;

import com.sun.jade.mediator.FilterParseException;
import com.sun.jade.mediator.Predicate;
import java.util.StringTokenizer;
import java.util.Vector;

public class FilterParser {
    private String query;
    private Vector attributeList;
    private String instanceType;
    private Vector predicateList;
    private String className;
    private Vector tokenVector;
    private boolean checksDelta;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int EQUAL_TO = 3;
    public static final int NOT_EQUAL_TO = 4;
    public static final int GREATER_THAN_OR_EQUAL = 5;
    public static final int LESS_THAN_OR_EQUAL = 6;
    public static final int DELTA = 7;
    public static final String ISA = "ISA";
    public static final String SOURCE_INST = "SourceInstance";
    public static final String PREVIOUS_INST = "PreviousInstance";

    public FilterParser(String string) throws FilterParseException {
        this.query = string;
        this.tokenVector = new Vector();
        this.predicateList = new Vector();
        this.className = null;
        this.checksDelta = false;
        this.tokenizeQuery(string);
        this.setClauses();
        this.verifyFilter();
    }

    private void tokenizeQuery(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.tokenVector.add(stringTokenizer.nextToken());
        }
    }

    private void setClauses() throws FilterParseException {
        try {
            int n = 0;
            while (n < this.tokenVector.size()) {
                Predicate predicate;
                String string = (String)this.tokenVector.get(n);
                if (string.equalsIgnoreCase("SELECT")) {
                    this.attributeList = this.determineAttributes(n);
                } else if (string.equalsIgnoreCase("FROM")) {
                    this.instanceType = this.determineInstance(n);
                } else if (string.equalsIgnoreCase("WHERE") || string.equalsIgnoreCase("AND")) {
                    predicate = this.determinePredicate(n, 1);
                    if (predicate != null) {
                        this.predicateList.add(predicate);
                    }
                } else if (string.equalsIgnoreCase("OR") && (predicate = this.determinePredicate(n, 2)) != null) {
                    this.predicateList.add(predicate);
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Object[] objectArray = new Object[]{this.query};
            throw new FilterParseException("resource.warning", 9, objectArray);
        }
    }

    private Vector determineAttributes(int n) throws FilterParseException {
        Vector<String> vector = new Vector<String>();
        String string = (String)this.tokenVector.get(n + 1);
        if (string.equals("*")) {
            vector.add(string);
        } else if (string.equalsIgnoreCase("NONE")) {
            vector.add(string);
        } else {
            if (string.equalsIgnoreCase("FROM")) {
                Object[] objectArray = new Object[]{this.query};
                throw new FilterParseException("resource.warning", 10, objectArray);
            }
            ++n;
            while (n < this.tokenVector.size()) {
                string = (String)this.tokenVector.get(n);
                if (string.equalsIgnoreCase("FROM")) break;
                vector.add(string);
                ++n;
            }
        }
        return vector;
    }

    private String determineInstance(int n) throws FilterParseException {
        String string = null;
        String string2 = null;
        boolean bl = false;
        ++n;
        while (n < this.tokenVector.size()) {
            string2 = (String)this.tokenVector.get(n);
            if (string2.equalsIgnoreCase("WHERE")) {
                if (bl) break;
                Object[] objectArray = new Object[]{this.query};
                throw new FilterParseException("resource.warning", 11, objectArray);
            }
            if (bl) {
                Object[] objectArray = new Object[]{this.query};
                throw new FilterParseException("resource.warning", 12, objectArray);
            }
            string = string2;
            bl = true;
            ++n;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Predicate determinePredicate(int n, int n2) throws FilterParseException {
        Predicate predicate = null;
        String string = (String)this.tokenVector.get(n + 1);
        if (SOURCE_INST.equalsIgnoreCase(string)) {
            string = (String)this.tokenVector.get(n + 2);
            if (!ISA.equalsIgnoreCase(string)) return predicate;
            this.className = (String)this.tokenVector.get(n + 3);
            return predicate;
        }
        int n3 = string.indexOf(".");
        if (n3 <= 0) {
            Object[] objectArray = new Object[]{string, this.query};
            throw new FilterParseException("resource.warning", 14, objectArray);
        }
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        int n4 = this.setOperator((String)this.tokenVector.get(n + 2));
        string = (String)this.tokenVector.get(n + 3);
        n3 = string.indexOf(".");
        if (n3 <= 0) {
            Object object = this.convertToObject(string);
            return new Predicate(this.className, string3, n4, object, n2);
        }
        String string4 = string.substring(0, n3);
        String string5 = string.substring(n3 + 1);
        if (SOURCE_INST.equalsIgnoreCase(string2) && PREVIOUS_INST.equalsIgnoreCase(string4) || PREVIOUS_INST.equalsIgnoreCase(string2) && SOURCE_INST.equalsIgnoreCase(string4)) {
            if (string5.equals(string3)) {
                predicate = new Predicate(this.className, string3, 7, null, n2);
                this.checksDelta = true;
                return predicate;
            }
            Object[] objectArray = new Object[]{this.query};
            throw new FilterParseException("resource.warning", 13, objectArray);
        }
        Object object = this.convertToObject(string);
        return new Predicate(this.className, string3, n4, object, n2);
    }

    private String stripQuotes(String string) throws FilterParseException {
        String string2 = null;
        if (string.substring(0, 1).equals("\"")) {
            if (string.substring(string.length() - 1, string.length()).equals("\"")) {
                string2 = string.substring(1, string.length() - 1);
            } else {
                Object[] objectArray = new Object[]{string, this.query};
                throw new FilterParseException("resource.warning", 15, objectArray);
            }
        }
        return string2;
    }

    private Object convertToObject(String string) throws FilterParseException {
        Object object = null;
        if (string.substring(0, 1).equals("\"")) {
            object = this.stripQuotes(string);
        } else if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
            object = new Boolean(string);
        } else {
            if (string.indexOf(".") > -1) {
                try {
                    object = new Float(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] objectArray = new Object[]{string, "Float", this.query};
                    throw new FilterParseException("resource.warning", 16, objectArray);
                }
            }
            try {
                object = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[]{string, "Integer", this.query};
                throw new FilterParseException("resource.warning", 16, objectArray);
            }
        }
        return object;
    }

    private int setOperator(String string) throws FilterParseException {
        int n = 0;
        if (string.equals("!=") || string.equals("<>")) {
            n = 4;
        } else if (string.equals("==")) {
            n = 3;
        } else if (string.equals("<")) {
            n = 2;
        } else if (string.equals(">")) {
            n = 1;
        } else if (string.equals("<=")) {
            n = 6;
        } else if (string.equals(">=")) {
            n = 5;
        } else if (string.equals("DELTA")) {
            n = 7;
            this.checksDelta = true;
        } else {
            Object[] objectArray = new Object[]{string, this.query};
            throw new FilterParseException("resource.warning", 17, objectArray);
        }
        return n;
    }

    private boolean verifyFilter() throws FilterParseException {
        boolean bl = true;
        if (this.className == null) {
            Object[] objectArray = new Object[]{this.query};
            throw new FilterParseException("resource.warning", 18, objectArray);
        }
        int n = 0;
        while (n < this.predicateList.size()) {
            Predicate predicate = (Predicate)this.predicateList.get(n);
            if (!predicate.getClassName().equals(this.className)) {
                Object[] objectArray = new Object[]{this.query};
                throw new FilterParseException("resource.warning", 19, objectArray);
            }
            ++n;
        }
        return bl;
    }

    public String getClassName() {
        return this.className;
    }

    public Vector getAttributeList() {
        return this.attributeList;
    }

    public Vector getPredicateList() {
        return this.predicateList;
    }

    public boolean getDeltaCheckStatus() {
        return this.checksDelta;
    }

    private void display() {
        int n = 0;
        while (n < this.attributeList.size()) {
            System.out.println("Attributes to get: " + this.attributeList.get(n));
            ++n;
        }
        if (this.instanceType != null) {
            System.out.println("Type of instance: " + this.instanceType);
        }
        int n2 = 0;
        while (n2 < this.predicateList.size()) {
            Predicate predicate = (Predicate)this.predicateList.get(n2);
            System.out.println();
            System.out.println("Class    : " + predicate.getClassName());
            System.out.println("Attribute: " + predicate.getAttributeName());
            System.out.println("Operator : " + predicate.getOperator());
            System.out.println("TargetVal: " + predicate.getTargetValue());
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        try {
            FilterParser filterParser = new FilterParser("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA StorEdgeT3_TemperatureSensor AND SourceInstance.CurrentReading <> PreviousInstance.CurrentReading OR SourceInstance.Type == 5");
            filterParser.display();
        }
        catch (FilterParseException filterParseException) {
            System.out.println(filterParseException.toString());
        }
    }
}

