/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.util.log.Report;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class EventCondition
extends Condition {
    public static final String TYPE_COND = "EventType";
    public static final String TOPIC_LEVELS_COND = "EventTopicLevels";
    public static final String TOPIC_CONTAINS_COND = "EventTopicContains";
    public static final String TOPIC_ENDS_WITH_COND = "EventTopicEndsWith";
    public static final String SUBJECT_COND = "EventSubject";
    public static final String DESCRIPTION_CODE_COND = "DescriptionCode";
    private String eventConditionType;
    private String eventComparator;
    private boolean evaluateCollection = false;

    public EventCondition(String string) {
        super(string);
    }

    public EventCondition(String string, String string2, String string3, boolean bl) {
        this(string);
        if (!this.validEventConditionType(string2)) {
            String string4 = this.conditionName + "condition must define a valid" + " EventCondType.  <" + string2 + " > is not valid.";
            Report.error.log(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string3 == null) {
            String string5 = this.conditionName + "condition must define an" + " EventCondComparator.";
            Report.error.log(string5);
            throw new IllegalArgumentException(string5);
        }
        this.eventConditionType = string2.trim();
        this.eventComparator = string3.trim();
        this.evaluateCollection = bl;
    }

    public boolean evaluate(Collection collection, Context context) {
        return this.evaluateCollection;
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) {
        boolean bl = false;
        if (this.eventComparator == null) {
            String string = "This " + this.conditionName + " cannot be evaluated." + "  The fromProperties must be invoked first to set the " + " event condition type and event condition comparator.";
            Report.error.log(string);
            throw new IllegalStateException(string);
        }
        if (TYPE_COND.equalsIgnoreCase(this.eventConditionType)) {
            if (this.eventComparator.equalsIgnoreCase(nSMEvent.getType())) {
                bl = true;
            }
        } else if (TOPIC_LEVELS_COND.equalsIgnoreCase(this.eventConditionType)) {
            StringBuffer stringBuffer = new StringBuffer(nSMEvent.getTopic());
            int n = 0;
            if (stringBuffer.length() > 0) {
                n = 1;
            }
            int n2 = 0;
            while (n2 < stringBuffer.length()) {
                if (".".equals(String.valueOf(stringBuffer.charAt(n2)))) {
                    ++n;
                }
                ++n2;
            }
            if (String.valueOf(n).equals(this.eventComparator)) {
                bl = true;
            }
        } else if (TOPIC_CONTAINS_COND.equalsIgnoreCase(this.eventConditionType)) {
            String string = nSMEvent.getTopic().toUpperCase();
            if (string != null && string.indexOf(this.eventComparator.toUpperCase()) != -1) {
                bl = true;
            }
        } else if (TOPIC_ENDS_WITH_COND.equalsIgnoreCase(this.eventConditionType)) {
            String string = nSMEvent.getTopic().toUpperCase();
            if (string != null && string.endsWith(this.eventComparator.toUpperCase())) {
                bl = true;
            }
        } else if (SUBJECT_COND.equals(this.eventConditionType)) {
            if (this.eventComparator.equalsIgnoreCase(nSMEvent.getSubject())) {
                bl = true;
            }
        } else if (DESCRIPTION_CODE_COND.equalsIgnoreCase(this.eventConditionType) && this.eventComparator.equalsIgnoreCase(nSMEvent.getDescriptionCode())) {
            bl = true;
        }
        return bl;
    }

    public void fromProperties(Properties properties) {
        this.eventConditionType = properties.getProperty("Condition." + this.conditionName.trim() + ".EventCondType");
        if (!this.validEventConditionType(this.eventConditionType)) {
            String string = this.conditionName + " condition must define a valid" + " EventCondType.  <" + this.eventConditionType + " > is not valid.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        this.eventComparator = properties.getProperty("Condition." + this.conditionName.trim() + ".EventCondComparator");
        if (this.eventComparator == null) {
            String string = this.conditionName + "condition must define an " + " EventCondComparator.";
            Report.error.log(string);
            throw new IllegalArgumentException(string);
        }
        this.evaluateCollection = Boolean.getBoolean(properties.getProperty("Condition." + this.conditionName.trim() + ".EvaluateCollection"));
    }

    private boolean validEventConditionType(String string) throws IllegalArgumentException {
        boolean bl = false;
        if (TYPE_COND.equalsIgnoreCase(string) || TOPIC_LEVELS_COND.equalsIgnoreCase(string) || TOPIC_CONTAINS_COND.equalsIgnoreCase(string) || TOPIC_ENDS_WITH_COND.equalsIgnoreCase(string) || SUBJECT_COND.equalsIgnoreCase(string) || DESCRIPTION_CODE_COND.equalsIgnoreCase(string)) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        System.out.println("\nEventCondition Unit Test Start\n");
        try {
            EventCondition eventCondition;
            Object object;
            NSMEvent nSMEvent = new NSMEvent();
            nSMEvent.setTopic("state.update.health.array.t3.system");
            nSMEvent.setType("State");
            nSMEvent.setSubject("My T3");
            nSMEvent.setDescriptionCode("Code 1234");
            EventCondition eventCondition2 = new EventCondition("TestEventTypeCond", TYPE_COND, "State", false);
            EventCondition eventCondition3 = new EventCondition("TestEventTopicLevelCond", TOPIC_LEVELS_COND, "6", false);
            EventCondition eventCondition4 = new EventCondition("TestEventTopicContainCond", TOPIC_CONTAINS_COND, "t3", false);
            EventCondition eventCondition5 = new EventCondition("TestEventTopicEndsCond", TOPIC_ENDS_WITH_COND, "system", false);
            EventCondition eventCondition6 = new EventCondition("TestEventSubjectCond", SUBJECT_COND, "My T3", false);
            EventCondition eventCondition7 = new EventCondition("TestEventDescCodeCond", DESCRIPTION_CODE_COND, "Code 1234", false);
            Vector<EventCondition> vector = new Vector<EventCondition>();
            vector.addElement(eventCondition2);
            vector.addElement(eventCondition3);
            vector.addElement(eventCondition4);
            vector.addElement(eventCondition5);
            vector.addElement(eventCondition6);
            vector.addElement(eventCondition7);
            int n = 0;
            while (n < vector.size()) {
                object = new Context();
                eventCondition = (EventCondition)vector.elementAt(n);
                if (eventCondition.evaluate(nSMEvent, (Context)object)) {
                    System.out.println(eventCondition.getConditionName() + " PASSED");
                } else {
                    System.out.println(eventCondition.getConditionName() + " FAILED");
                }
                ++n;
            }
            object = new Properties();
            eventCondition = new EventCondition("TestEventTypeCond2");
            ((Properties)object).setProperty("Condition.TestEventTypeCond2.EventCondType", TYPE_COND);
            ((Properties)object).setProperty("Condition.TestEventTypeCond2.EventCondComparator", "NotTheType");
            ((Properties)object).setProperty("Condition.TestEventTypeCond2.EvaluateCollection", "false");
            eventCondition.fromProperties((Properties)object);
            ((Properties)object).clear();
            EventCondition eventCondition8 = new EventCondition("TestEventTopicLevelCond2");
            ((Properties)object).setProperty("Condition.TestEventTopicLevelCond2.EventCondType", TOPIC_LEVELS_COND);
            ((Properties)object).setProperty("Condition.TestEventTopicLevelCond2.EventCondComparator", "2");
            ((Properties)object).setProperty("Condition.TestEventTopicLevelCond2.EvaluateCollection", "false");
            eventCondition8.fromProperties((Properties)object);
            ((Properties)object).clear();
            EventCondition eventCondition9 = new EventCondition("TestEventTopicContainCond2");
            ((Properties)object).setProperty("Condition.TestEventTopicContainCond2.EventCondType", TOPIC_CONTAINS_COND);
            ((Properties)object).setProperty("Condition.TestEventTopicContainCond2.EventCondComparator", "NotPartOfTopic");
            ((Properties)object).setProperty("Condition.TestEventTopicContainCond2.EvaluateCollection", "false");
            eventCondition9.fromProperties((Properties)object);
            ((Properties)object).clear();
            EventCondition eventCondition10 = new EventCondition("TestEventTopicEndsCond2");
            ((Properties)object).setProperty("Condition.TestEventTopicEndsCond2.EventCondType", TOPIC_ENDS_WITH_COND);
            ((Properties)object).setProperty("Condition.TestEventTopicEndsCond2.EventCondComparator", "NotTheEnding");
            ((Properties)object).setProperty("Condition.TestEventTopicEndsCond2.EvaluateCollection", "false");
            eventCondition10.fromProperties((Properties)object);
            ((Properties)object).clear();
            EventCondition eventCondition11 = new EventCondition("TestEventSubjectCond2");
            ((Properties)object).setProperty("Condition.TestEventSubjectCond2.EventCondType", SUBJECT_COND);
            ((Properties)object).setProperty("Condition.TestEventSubjectCond2.EventCondComparator", "NotTheSubject");
            ((Properties)object).setProperty("Condition.TestEventSubjectCond2.EvaluateCollection", "false");
            eventCondition11.fromProperties((Properties)object);
            ((Properties)object).clear();
            EventCondition eventCondition12 = new EventCondition("TestEventDescCodeCond2");
            ((Properties)object).setProperty("Condition.TestEventDescCodeCond2.EventCondType", DESCRIPTION_CODE_COND);
            ((Properties)object).setProperty("Condition.TestEventDescCodeCond2.EventCondComparator", "NotTheCode");
            ((Properties)object).setProperty("Condition.TestEventDescCodeCond2.EvaluateCollection", "false");
            eventCondition12.fromProperties((Properties)object);
            ((Properties)object).clear();
            Vector<EventCondition> vector2 = new Vector<EventCondition>();
            vector2.addElement(eventCondition);
            vector2.addElement(eventCondition8);
            vector2.addElement(eventCondition9);
            vector2.addElement(eventCondition10);
            vector2.addElement(eventCondition11);
            vector2.addElement(eventCondition12);
            int n2 = 0;
            while (n2 < vector2.size()) {
                Context context = new Context();
                EventCondition eventCondition13 = (EventCondition)vector2.elementAt(n2);
                if (!eventCondition13.evaluate(nSMEvent, context)) {
                    System.out.println(eventCondition13.getConditionName() + " PASSED");
                } else {
                    System.out.println(eventCondition13.getConditionName() + " FAILED");
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception caught while unit testing.");
            exception.printStackTrace();
        }
        System.out.println("\nEventCondition Unit Test End\n");
    }
}

