/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.util.log.Report;
import java.util.Iterator;

public class EventHelper {
    public static final String ALERT_CREATE = ".alert.create.";

    public static boolean isModificationEvent(NSMEvent nSMEvent) {
        if (nSMEvent == null) {
            return false;
        }
        return ModificationEventData.eventIsOfThisType(nSMEvent);
    }

    public static boolean isAlertEvent(NSMEvent nSMEvent) {
        if (nSMEvent == null) {
            return false;
        }
        return AlertEventData.eventIsOfThisType(nSMEvent);
    }

    public static boolean isDefinitionEvent(NSMEvent nSMEvent) {
        if (nSMEvent == null) {
            return false;
        }
        return DefinitionEventData.eventIsOfThisType(nSMEvent);
    }

    public static boolean isDeletionEvent(NSMEvent nSMEvent) {
        if (nSMEvent == null) {
            return false;
        }
        return DeletionEventData.eventIsOfThisType(nSMEvent);
    }

    public static boolean isPrivateEvent(NSMEvent nSMEvent) {
        if (nSMEvent == null) {
            return false;
        }
        return nSMEvent.getTopic().startsWith("private", 1);
    }

    public static boolean isModificationEvent(String string) {
        return string.startsWith("property", 1) || string.startsWith("state", 1) || string.startsWith("statistics", 1);
    }

    public static boolean isAlertEvent(String string) {
        return string.startsWith("alert", 1);
    }

    public static boolean isDefinitionEvent(String string) {
        return string.startsWith("definition", 1);
    }

    public static boolean isPrivateEvent(String string) {
        return string.startsWith("private", 1);
    }

    public static boolean isClearAlert(String string) {
        return string.startsWith("alert.clear", 1);
    }

    public static Alarm findMostRecentAlarm(Iterator iterator, String string, String string2) {
        long l = 0L;
        Alarm alarm = null;
        while (iterator.hasNext()) {
            Alarm alarm2 = (Alarm)iterator.next();
            NSMEvent nSMEvent = alarm2.getEvent();
            long l2 = nSMEvent.getSourceTime();
            if (l2 <= l || !nSMEvent.getTopic().equals(string) || !nSMEvent.getType().equals(string2)) continue;
            alarm = alarm2;
            l = l2;
        }
        return alarm;
    }

    public static String buildAlarmTopic(String string) {
        String string2 = ALERT_CREATE;
        int n = string2.length() - 1;
        string2 = string2 + string.substring(n);
        return string2;
    }

    public static Alarm clearAlarm(String string, String string2, String string3) {
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
            Iterator iterator = genericPersistence.retrieveEventsBySubject(string, 3);
            Alarm alarm = EventHelper.findMostRecentAlarm(iterator, EventHelper.buildAlarmTopic(string2), string3);
            if (alarm != null) {
                EventHelper.setClear(alarm);
                genericPersistence.updateAlarm(alarm);
            }
            return alarm;
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Unable to clear Alarm");
            return null;
        }
    }

    public static void setClear(Alarm alarm) {
        if (alarm != null) {
            alarm.setIsCleared(true);
            alarm.setClearTime(System.currentTimeMillis());
        }
    }

    public static void updateCorrelatedEvents(Alarm alarm, NSMEvent nSMEvent) {
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
            NSMEvent nSMEvent2 = alarm.getEvent();
            String[] stringArray = nSMEvent2.getCorrelatedEvents();
            String[] stringArray2 = new String[stringArray.length + 1];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
            stringArray2[stringArray.length] = nSMEvent.getEventID();
            nSMEvent2.setCorrelatedEvents(stringArray2);
            genericPersistence.updateEvent(nSMEvent2);
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"Unable to update Alarm");
        }
    }
}

