/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.apps.persistence.service.StatisticsPersistence;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Context;
import com.sun.jade.policy.DelegateCondition;
import com.sun.jade.policy.StatisticEvaluator;
import com.sun.jade.policy.StatisticInfo;
import com.sun.jade.policy.UnitTestHelper;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMObjectPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class HistoricHealthCondition
extends DelegateCondition {
    private int timeWindow;
    private StatisticEvaluator eval;
    private static boolean unitTesting = false;
    private static StatisticsPersistence statisticsPersistence = null;
    private static final int MILLISEC_PER_SEC = 1000;
    public static final String TARGET_ATTR = ".TargetAttr";
    public static final String THRESHOLD = ".Threshold";
    public static final String TIME_WINDOW = ".TimeWindow";
    public static final String EVALUATOR_TYPE = ".EvaluatorType";
    private static final String[] propertyNames = new String[]{".TargetAttr", ".Threshold", ".TimeWindow", ".EvaluatorType"};
    private Map propertyValues;
    private static final String sccs_id = "@(#) 1.23 @(#)HistoricHealthCondition.java\t1.23 10/07/02 SMI";

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public HistoricHealthCondition(String string) {
        super(string);
    }

    public boolean evaluate(Collection collection, Context context) {
        if (this.propertyValues == null) {
            Report.error.log(this.getConditionName() + " HistoricHealthCondition properties have not been initialized." + " Check to make sure that fromProperties has been called.");
            return false;
        }
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            CIMBean cIMBean = (CIMBean)iterator.next();
            CIMBean cIMBean2 = null;
            if (iterator.hasNext()) {
                cIMBean2 = (CIMBean)iterator.next();
            }
            if (cIMBean2 == null) {
                return false;
            }
            if (cIMBean != null) {
                CIMObjectPath cIMObjectPath = cIMBean.getCIMObjectPath();
                return this.evaluate(cIMObjectPath, context);
            }
        }
        return false;
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) {
        Report.trace.log("Policy", (Object)("Evaluating " + nSMEvent.getSubject()));
        if (this.propertyValues == null) {
            Report.error.log(this.getConditionName() + " HistoricHealthCondition properties have not been initialized." + " Check to make sure that fromProperties has been called.");
            return false;
        }
        if (nSMEvent instanceof NSMEvent) {
            String string = nSMEvent.getSubject();
            if (string == null) {
                return false;
            }
            CIMObjectPath cIMObjectPath = CIMBeanUtil.parseToCIMObjectPath(string);
            return this.evaluate(cIMObjectPath, context);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean evaluate(CIMObjectPath var1_1, Context var2_2) {
        block8: {
            var3_3 = null;
            var4_4 = null;
            try {
                if (!HistoricHealthCondition.unitTesting) {
                    var3_3 = PersistenceService.getService();
                    var4_4 = var3_3.getStatisticsPersistence();
                } else {
                    var4_4 = HistoricHealthCondition.statisticsPersistence;
                }
            }
            catch (ConnectionException var5_5) {
                Report.error.log(var5_5, (Object)"HistoricHealthCondition: Cannot Connect to Persistence");
                return false;
            }
            var5_6 = new ReferenceForMSE(var1_1);
            var6_7 = new Date();
            var7_8 = new Date(var6_7.getTime() - (long)(this.timeWindow * 1000));
            var8_9 = null;
            try {
                Report.debug.log("Policy", (Object)("Retrieving StatInfo for ->" + (String)this.propertyValues.get(".TargetAttr")));
                Report.debug.log("Policy", (Object)("Start time : " + var7_8.toString() + " End time : " + var6_7.toString()));
                var8_9 = var4_4.getStatisticsByAttr(var5_6, var7_8, var6_7, (String)this.propertyValues.get(".TargetAttr"));
            }
            catch (Exception var9_10) {
                Report.error.log(var9_10, (Object)"Reading Statistics from persistence");
                return false;
            }
            if (var8_9 == null) break block8;
            this.eval.init();
            if (var8_9.hasNext()) ** GOTO lbl32
            Report.debug.log("Policy", (Object)"No records in iterator");
            return false;
lbl-1000:
            // 1 sources

            {
                var9_11 = (StatisticInfo)var8_9.next();
                this.eval.add(var9_11.getOldValue(), var9_11.getNewValue());
lbl32:
                // 2 sources

                ** while (var8_9.hasNext())
            }
lbl33:
            // 1 sources

            var2_2.saveAttr(this.getConditionName(), "currentValue", this.eval.getCurrentValue());
            var2_2.saveAttr(this.getConditionName(), "previousValue", this.eval.getPreviousValue());
            var2_2.saveAttr(this.getConditionName(), "delta", this.eval.getDelta());
            var2_2.saveAttr(this.getConditionName(), "interval_sec", Long.toString(this.timeWindow));
            var2_2.saveAttr(this.getConditionName(), "interval_min", Long.toString(this.timeWindow / 60));
            var2_2.saveAttr(this.getConditionName(), "interval_hrs", Long.toString(this.timeWindow / 3600));
            var2_2.saveAttr(this.getConditionName(), "interval_day", Long.toString(this.timeWindow / 86400));
            if (this.eval.evaluate((String)this.propertyValues.get(".Threshold"))) {
                Report.debug.log("HistoricHealth -> evaluated to true");
                return true;
            }
            Report.debug.log("HistoricHealth -> evaluated to false");
            return false;
        }
        Report.debug.log("Policy", (Object)"Null iterator");
        return false;
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string = this.getConditionName();
        String string2 = (String)this.propertyValues.get(TIME_WINDOW);
        String string3 = (String)this.propertyValues.get(EVALUATOR_TYPE);
        if (this.propertyValues.get(TARGET_ATTR) == null || this.propertyValues.get(THRESHOLD) == null || string2 == null || string3 == null) {
            throw new PropertiesPersistenceException(this.getConditionName() + " HistoricHealthCondition does not specify one or more of TargetAttr, " + " TimeWindow, Threshold, or EvaluatorType.");
        }
        try {
            this.timeWindow = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertiesPersistenceException("Unable to Parse .TimeWindow property for " + this.getConditionName());
        }
        try {
            if (string3.equals("com.sun.jade.policy.StringMatchStatisticEvaluator")) {
                throw new PropertiesPersistenceException("Not implemented");
            }
            Class<?> clazz = Class.forName(string3);
            this.eval = (StatisticEvaluator)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new PropertiesPersistenceException("Unable to instantiate " + string3 + " for HistoricHealthCondition " + string + " - " + exception.getMessage(), exception);
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testHistoricHealthCondition();
    }

    public static class Test
    extends UnitTest {
        public void testHistoricHealthCondition() {
            unitTesting = true;
            try {
                ReferenceForMSE referenceForMSE = new ReferenceForMSE("com.sun.jade.cim.bean.CIM_FibrePort", "DeviceID", "Port", "switch4");
                NSMEvent nSMEvent = UnitTestHelper.createNSMEvent("6", "9");
                HistoricHealthCondition historicHealthCondition = new HistoricHealthCondition("TestCondition");
                HistoricHealthCondition.statisticsPersistence = new StatisticsPersistence(this){
                    private ArrayList al;
                    private final /* synthetic */ Test this$0;
                    {
                        this.this$0 = test;
                        this.al = new ArrayList<E>();
                    }

                    public void storeStatistic(ReferenceForMSE referenceForMSE, StatisticInfo statisticInfo) {
                        this.al.add(statisticInfo);
                    }

                    public Iterator getStatisticsByAttr(ReferenceForMSE referenceForMSE, Date date, Date date2, String string) {
                        return this.al.iterator();
                    }

                    public Iterator getStatisticsByType(ReferenceForMSE referenceForMSE, Date date, Date date2, int n) {
                        return this.al.iterator();
                    }

                    public Iterator getStatisticsByEvent(ReferenceForMSE referenceForMSE, Date date, Date date2, String string, String string2) {
                        return this.al.iterator();
                    }

                    public void storeEvent(NSMEvent nSMEvent) {
                    }

                    public Iterator retrieveEvents(int n) {
                        return null;
                    }

                    public Iterator retrieveEventsBySubject(String string, int n) {
                        return null;
                    }

                    public Iterator retrieveEvents(String string, String string2, int n, int n2) {
                        return null;
                    }

                    public Iterator retrieveEventsByTopic(String string, int n) {
                        return null;
                    }

                    public Iterator retrieveEventsBySubjectType(String string, int n) {
                        return null;
                    }

                    public NSMEvent retrieveEventByID(String string) {
                        return null;
                    }

                    public Alarm retrieveAlarmByID(String string) {
                        return null;
                    }

                    public void updateAlarm(Alarm alarm) {
                    }

                    public void removeEventByID(String string, int n) {
                    }

                    public Iterator retrieveEventsBySystemType(String string, int n) throws ConnectionException {
                        return null;
                    }

                    public Iterator retrieveEventsBySystemName(String string, String string2, int n) throws ConnectionException {
                        return null;
                    }

                    public Iterator retrieveEventsBySystemDevice(String string, String string2, String string3, int n) throws ConnectionException {
                        return null;
                    }

                    public Iterator retrieveAlarmSummary() throws ConnectionException {
                        return null;
                    }

                    public int retrieveNbrEventsBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
                        return -1;
                    }

                    public Object retrieveLastEventBySystemName(String string, String string2, int n, int n2, int n3) throws ConnectionException {
                        return null;
                    }

                    public int retrieveNbrEventsBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
                        return -1;
                    }

                    public Object retrieveLastEventBySystemDevice(String string, String string2, String string3, int n, int n2, int n3) throws ConnectionException {
                        return null;
                    }

                    public HashMap retrieveAlarmSummary(int n, int n2, boolean bl) throws ConnectionException {
                        return null;
                    }

                    public void updateEvent(NSMEvent nSMEvent) {
                    }

                    public void updateCorrelatedEvents(NSMEvent nSMEvent) {
                    }
                };
                Context context = new Context();
                StatisticInfo statisticInfo = new StatisticInfo(nSMEvent, "InvalidTransmissionWords");
                statisticInfo.setOldValue("9");
                statisticInfo.setNewValue("11");
                statisticsPersistence.storeStatistic(referenceForMSE, statisticInfo);
                Properties properties = new Properties();
                properties.setProperty("Condition.TestCondition.EvaluatorType", "com.sun.jade.policy.IntegerStatisticEvaluator");
                properties.setProperty("Condition.TestCondition.Threshold", "2");
                properties.setProperty("Condition.TestCondition.TimeWindow", "5");
                properties.setProperty("Condition.TestCondition.TargetAttr", "InvalidTransmissionWords");
                historicHealthCondition.fromProperties(properties);
                this.assertCondition(historicHealthCondition.evaluate(nSMEvent, context));
                this.assertEquals("9", context.getAttr("TestCondition", "previousValue"));
                this.assertEquals("11", context.getAttr("TestCondition", "currentValue"));
                this.assertEquals("5", context.getAttr("TestCondition", "interval_sec"));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.EvaluatorType", "com.sun.jade.policy.IntegerStatisticEvaluator");
                properties.setProperty("Condition.TestCondition.Threshold", "5");
                properties.setProperty("Condition.TestCondition.TimeWindow", "5");
                properties.setProperty("Condition.TestCondition.TargetAttr", "InvalidTransmissionWords");
                historicHealthCondition.fromProperties(properties);
                this.assertCondition(!historicHealthCondition.evaluate(nSMEvent, context));
                statisticInfo = new StatisticInfo(nSMEvent, "InvalidTransmissionWords");
                statisticInfo.setOldValue("11");
                statisticInfo.setNewValue("15");
                statisticsPersistence.storeStatistic(referenceForMSE, statisticInfo);
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.EvaluatorType", "com.sun.jade.policy.IntegerStatisticEvaluator");
                properties.setProperty("Condition.TestCondition.Threshold", "5");
                properties.setProperty("Condition.TestCondition.TimeWindow", "5");
                properties.setProperty("Condition.TestCondition.TargetAttr", "InvalidTransmissionWords");
                historicHealthCondition.fromProperties(properties);
                this.assertCondition(historicHealthCondition.evaluate(nSMEvent, context));
                this.assertEquals("9", context.getAttr("TestCondition", "previousValue"));
                this.assertEquals("15", context.getAttr("TestCondition", "currentValue"));
                this.assertEquals("5", context.getAttr("TestCondition", "interval_sec"));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.EvaluatorType", "com.sun.jade.policy.StringMatchStatisticEvaluator");
                properties.setProperty("Condition.TestCondition.Threshold", "5");
                properties.setProperty("Condition.TestCondition.TimeWindow", "5");
                properties.setProperty("Condition.TestCondition.TargetAttr", "Caption");
                try {
                    historicHealthCondition.fromProperties(properties);
                    this.fail("Accepts bad properties");
                }
                catch (PropertiesPersistenceException propertiesPersistenceException) {
                    // empty catch block
                }
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.EvaluatorType", "IntegerStatisticEvaluator");
                properties.setProperty("Condition.TestCondition.Threshold", "5");
                properties.setProperty("Condition.TestCondition.TimeWindow", "5");
                properties.setProperty("Condition.TestCondition.TargetAttr", "ttr");
                try {
                    historicHealthCondition.fromProperties(properties);
                    this.fail("Accepts bad properties");
                }
                catch (PropertiesPersistenceException propertiesPersistenceException) {
                    // empty catch block
                }
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.Threshold", "5");
                properties.setProperty("Condition.TestCondition.TimeWindow", "5");
                properties.setProperty("Condition.TestCondition.TargetAttr", "ttr");
                try {
                    historicHealthCondition.fromProperties(properties);
                    this.fail("Accepts bad properties");
                }
                catch (PropertiesPersistenceException propertiesPersistenceException) {
                    // empty catch block
                }
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.EvaluatorType", "com.sun.jade.policy.IntegerStatisticEvaluator");
                properties.setProperty("Condition.TestCondition.Threshold", "abc");
                properties.setProperty("Condition.TestCondition.TimeWindow", "abc");
                properties.setProperty("Condition.TestCondition.TargetAttr", "ttr");
                try {
                    historicHealthCondition.fromProperties(properties);
                    this.fail("Accepts bad properties");
                }
                catch (PropertiesPersistenceException propertiesPersistenceException) {}
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.fail(exception.toString());
            }
        }
    }
}

