/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.apps.persistence.service.ConnectionException;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanUtil;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.EventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.policy.Condition;
import com.sun.jade.policy.Context;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.SequenceNumberGenerator;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMObjectPath;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class NoMatchingEventCondition
extends Condition {
    private int timeWindow;
    private String SeverityProperty;
    private String EventTopic;
    private String EventType;
    private String DescriptionCode;
    private static final int MILLISEC_PER_SEC = 1000;
    public static final String TIME_WINDOW = ".TimeWindow";
    public static final String EVENT_TOPIC = ".EventTopic";
    public static final String EVENT_TYPE = ".EventType";
    public static final String SEVERITY = ".MinimumSeverity";
    public static final String DESCRIPTION_CODE = ".DescriptionCode";
    private static final String[] propertyNames = new String[]{".TimeWindow", ".EventTopic", ".EventType", ".MinimumSeverity", ".DescriptionCode"};
    private Map propertyValues;
    private static final String sccs_id = "(#)%I%D%E";

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public NoMatchingEventCondition(String string) {
        super(string);
    }

    public boolean evaluate(Collection collection, Context context) throws Exception {
        if (this.propertyValues == null) {
            Report.error.log(this.getConditionName() + " NoMatchingEventCondition properties have not been initialized." + " Check to make sure that fromProperties has been called.");
            return false;
        }
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            CIMBean cIMBean = (CIMBean)iterator.next();
            CIMBean cIMBean2 = null;
            if (iterator.hasNext()) {
                cIMBean2 = (CIMBean)iterator.next();
            }
            if (cIMBean2 == null) {
                return true;
            }
            if (cIMBean != null) {
                CIMObjectPath cIMObjectPath = cIMBean.getCIMObjectPath();
                return this.evaluate(cIMObjectPath);
            }
        }
        return true;
    }

    public boolean evaluate(NSMEvent nSMEvent, Context context) throws Exception {
        Report.trace.log("Policy", (Object)("Evaluating " + nSMEvent.getSubject()));
        if (this.propertyValues == null) {
            Report.error.log(this.getConditionName() + " NoMatchingEventCondition properties have not been initialized." + " Check to make sure that fromProperties has been called.");
            return false;
        }
        if (nSMEvent instanceof NSMEvent) {
            String string = nSMEvent.getSubject();
            if (string == null) {
                return true;
            }
            CIMObjectPath cIMObjectPath = CIMBeanUtil.parseToCIMObjectPath(string);
            return this.evaluate(cIMObjectPath);
        }
        return true;
    }

    private boolean evaluate(CIMObjectPath cIMObjectPath) {
        boolean bl = true;
        PersistenceService persistenceService = null;
        GenericPersistence genericPersistence = null;
        try {
            persistenceService = PersistenceService.getService();
            genericPersistence = persistenceService.getGenericPersistence();
        }
        catch (ConnectionException connectionException) {
            Report.error.log(connectionException, (Object)"NoMatchingEventCondition: Cannot Connect to Persistence");
            return bl;
        }
        ReferenceForMSE referenceForMSE = new ReferenceForMSE(cIMObjectPath);
        long l = new Date().getTime();
        l -= (long)(this.timeWindow * 1000);
        try {
            int n = 3;
            if (this.EventTopic != null && !this.EventTopic.startsWith("alert", 1)) {
                n = 2;
            }
            Iterator iterator = genericPersistence.retrieveEventsBySubject(cIMObjectPath.toString(), n);
            while (iterator.hasNext()) {
                NSMEvent nSMEvent = null;
                if (n == 3) {
                    Alarm alarm = (Alarm)iterator.next();
                    nSMEvent = alarm.getEvent();
                } else {
                    nSMEvent = (NSMEvent)iterator.next();
                }
                long l2 = nSMEvent.getSourceTime();
                if (l2 < l) continue;
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = true;
                boolean bl5 = true;
                String string = nSMEvent.getTopic();
                String string2 = nSMEvent.getType();
                int n2 = nSMEvent.getSeverity();
                EventData eventData = new EventData(nSMEvent);
                String string3 = eventData.getEventCode();
                if (this.EventTopic != null && !this.EventTopic.equals(string)) {
                    bl2 = false;
                }
                if (this.EventType != null && !this.EventType.equals(string2)) {
                    bl3 = false;
                }
                if (this.SeverityProperty != null && n2 < Integer.parseInt(this.SeverityProperty)) {
                    bl4 = false;
                }
                if (this.DescriptionCode != null && !this.DescriptionCode.equalsIgnoreCase(string3)) {
                    bl5 = false;
                }
                if (!bl2 || !bl3 || !bl4 || !bl5) continue;
                bl = false;
                break;
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Retrieving Events from persistence");
        }
        return bl;
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string = this.getConditionName();
        String string2 = (String)this.propertyValues.get(TIME_WINDOW);
        this.SeverityProperty = (String)this.propertyValues.get(SEVERITY);
        this.EventTopic = (String)this.propertyValues.get(EVENT_TOPIC);
        this.EventType = (String)this.propertyValues.get(EVENT_TYPE);
        this.DescriptionCode = (String)this.propertyValues.get(DESCRIPTION_CODE);
        if (string2 == null) {
            throw new PropertiesPersistenceException(this.getConditionName() + " NoMatchingEventCondition does not specify the TimeWindow.");
        }
        try {
            this.timeWindow = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PropertiesPersistenceException("Unable to Parse .TimeWindow property for " + this.getConditionName());
        }
    }

    public static void main(String[] stringArray) {
        Test test = new Test();
        test.testNoMatchingEventCondition();
    }

    public static class Test
    extends UnitTest {
        public void testNoMatchingEventCondition() {
            try {
                PersistenceService persistenceService = PersistenceService.getService();
                GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
                ReferenceForMSE referenceForMSE = new ReferenceForMSE("com.sun.jade.cim.bean.StorEdgeT3_DiskDrive", "DeviceID", "T3", "purple12");
                NSMEvent nSMEvent = new NSMEvent();
                nSMEvent.setSubject(referenceForMSE.getCIMObjectPath().toString());
                nSMEvent.setSource("testSource");
                nSMEvent.setTopic(".alert.create.test");
                nSMEvent.setSeverity(5);
                nSMEvent.setType("StateChangeAlert");
                nSMEvent.setSourceTime(new Date().getTime() - 5000L);
                genericPersistence.storeEvent(nSMEvent);
                nSMEvent = new NSMEvent();
                nSMEvent.setSubject(referenceForMSE.getCIMObjectPath().toString());
                nSMEvent.setSource("testSource");
                nSMEvent.setTopic(".state.test");
                nSMEvent.setSeverity(5);
                nSMEvent.setType(".state.update");
                nSMEvent.setSourceTime(new Date().getTime() - 5000L);
                genericPersistence.storeEvent(nSMEvent);
                nSMEvent = new NSMEvent();
                nSMEvent.setSubject(referenceForMSE.getCIMObjectPath().toString());
                nSMEvent.setSource("testSource");
                nSMEvent.setTopic(".testTopic");
                nSMEvent.setSourceTime(new Date().getTime());
                NoMatchingEventCondition noMatchingEventCondition = new NoMatchingEventCondition("TestCondition");
                Properties properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(!noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "1");
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.MinimumSeverity", String.valueOf(4));
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(!noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.MinimumSeverity", String.valueOf(6));
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.EventTopic", ".state.test");
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(!noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.EventTopic", ".junk");
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.EventTopic", ".alert.create.test");
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(!noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.EventTopic", ".state.test");
                properties.setProperty("Condition.TestCondition.EventType", ".state.update");
                noMatchingEventCondition.fromProperties(properties);
                this.assertCondition(!noMatchingEventCondition.evaluate(nSMEvent, new Context()));
                properties = new Properties();
                properties.setProperty("Condition.TestCondition.TimeWindow", "500");
                properties.setProperty("Condition.TestCondition.DescriptionCode", "TestCode");
                properties.setProperty("Condition.TestCondition.EventTopic", "foo.bar");
                noMatchingEventCondition.fromProperties(properties);
                ModificationEventData modificationEventData = new ModificationEventData(1, "source123456", SequenceNumberGenerator.createSequenceNumber("source123456"), referenceForMSE.getCIMObjectPath().toString(), System.currentTimeMillis(), "foo.bar", "type", null, null, System.currentTimeMillis(), "TestCode", null, null, null);
                EventGenerator.generateEvent(modificationEventData);
                this.assertCondition(!noMatchingEventCondition.evaluate(nSMEvent, new Context()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

