/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.cim.bean.CIM_LogicalDevice;
import com.sun.jade.cim.bean.CIM_PhysicalElement;
import com.sun.jade.cim.bean.CIM_System;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.cim.util.CIMBeanImpl;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.EventConstants;
import com.sun.jade.event.EventData;
import com.sun.jade.event.EventGenerator;
import com.sun.jade.event.ModificationEventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.message.MessageCode;
import com.sun.jade.policy.Action;
import com.sun.jade.policy.ActionNotExecutedException;
import com.sun.jade.policy.Context;
import com.sun.jade.policy.EventHelper;
import com.sun.jade.policy.UnitTestHelper;
import com.sun.jade.policy.util.DescriptionInfoParser;
import com.sun.jade.services.event.AbstractEventSubscriber;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.SequenceNumberGenerator;
import com.sun.jade.util.jini.BaseServiceFinder;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.topology.TopologyBean;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMObjectPath;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class NotifyAction
extends Action {
    public static final String POLICY_SERVICE = "PolicyService";
    public static final String PROPERTY_EVENT_TOPIC = ".EventTopic";
    public static final String PROPERTY_EVENT_TYPE = ".EventType";
    public static final String PROPERTY_SEVERITY = ".Severity";
    public static final String PROPERTY_URL = ".URL";
    public static final String PROPERTY_ALERT_TYPE = ".AlertType";
    public static final String PROPERTY_EVENT_FORMAT = ".EventFormat";
    public static final String PROPERTY_DESCRIPTION = "description";
    public static final String PROPERTY_PROBABLE_CAUSE = "probableCause";
    public static final String PROPERTY_CAUSE_DESCRIPTION = "probableCauseDescription";
    public static final String PROPERTY_DESCRIPTION_INFO = "info";
    public static final String PROPERTY_DESCRIPTION_INFOATTRIBUTE = ".DescriptionInfo";
    public static final String PROPERTY_RECOMMENDED_ACTION = "recommendedAction";
    public static final String PROPERTY_DESCRIPTION_CODE = ".DescriptionCode";
    public static final String PROPERTY_AUDIT = ".Audit";
    public static final String ALERT_FORMAT = "Alert";
    public static final String SOURCE_FROM_EVENT = "$event";
    public static final String EVENT_FORMAT = "Event";
    private static final String[] propertyNames = new String[]{".EventTopic", ".EventType", ".Severity", ".Audit", ".URL", ".AlertType", ".EventFormat", "description", "probableCause", ".DescriptionCode", ".DescriptionInfo", "probableCauseDescription"};
    private Map propertyValues;
    private String auditProperty;
    private String topicProperty;
    private String typeProperty;
    private String urlProperty;
    private String severityProperty;
    private String alertTypeProperty;
    private String eventFormatProperty;
    private String descriptionCodeProperty;
    private String descriptionInfoProperty;
    private String descriptionInfoAttributeProperty;
    private String recommendedActionProperty;
    private String descriptionCode;
    private Object[] descriptionInfo;
    private Object[] descriptionInfoAttributes;
    private boolean unitTesting = false;
    private EventData testEventData;
    public static final String sccs_id = "@(#)NotifyAction.java\t1.32 02/26/03 SMI";

    public static String[] getPropertyNames() {
        return propertyNames;
    }

    public NotifyAction(String string) {
        super(string);
        Report.trace.log("Policy", (Object)("Instantiating NotifyAction (" + string + ")"));
    }

    public void doAction(Collection collection, Context context) throws ActionNotExecutedException {
        Object object;
        Report.trace.log("Policy", (Object)("NotifyAction(" + this.getActionName() + ")->doAction(Collection)"));
        CIMBean cIMBean = null;
        CIMBean cIMBean2 = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        Object var7_7 = null;
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            cIMBean = (CIMBean)iterator.next();
            cIMBean2 = null;
            if (iterator.hasNext()) {
                cIMBean2 = (CIMBean)iterator.next();
            }
            cIMObjectPath = cIMBean.getCIMObjectPath();
            if (cIMBean2 != null && !cIMObjectPath.equals((Object)(cIMObjectPath2 = cIMBean2.getCIMObjectPath()))) {
                throw new ActionNotExecutedException("The CIM Object path of the objects in the collection do not match " + cIMObjectPath.toString() + " != " + cIMObjectPath2.toString());
            }
        }
        boolean bl = false;
        if (EventHelper.isClearAlert(this.topicProperty) && (object = EventHelper.clearAlarm(cIMObjectPath.toString(), this.topicProperty, this.typeProperty)) == null) {
            Report.info.log(new ActionNotExecutedException("Cannot find Alert Create for requested Alert Clear"));
            bl = true;
        }
        object = this.retrieveSubjectEnclosureIP(cIMBean);
        if (!bl) {
            this.doAction(cIMObjectPath.toString(), (String)object, cIMBean, cIMBean2, null, null, context);
        }
    }

    public void doAction(NSMEvent nSMEvent, Context context) throws ActionNotExecutedException {
        EventData eventData;
        Report.trace.log("Policy", (Object)("NotifyAction(" + this.getActionName() + ")->doAction(NSMEvent)"));
        String string = nSMEvent.getTopic();
        String string2 = nSMEvent.getType();
        String string3 = null;
        long l = 0L;
        String[] stringArray = null;
        CIMBean cIMBean = null;
        CIMBean cIMBean2 = null;
        CIMBean[] cIMBeanArray = null;
        String string4 = null;
        if (EventHelper.isAlertEvent(nSMEvent)) {
            eventData = new AlertEventData(nSMEvent);
            string3 = eventData.getSubject();
            stringArray = new String[]{eventData.getEventID()};
            string4 = eventData.getSubjectEnclosureIP();
        } else if (EventHelper.isDefinitionEvent(nSMEvent)) {
            eventData = new DefinitionEventData(nSMEvent);
            string3 = eventData.getSubject();
            stringArray = new String[]{eventData.getEventID()};
            cIMBeanArray = ((DefinitionEventData)eventData).getDefinedObjects();
            if (cIMBeanArray != null && cIMBeanArray.length == 1) {
                cIMBean = cIMBeanArray[0];
            }
            string4 = eventData.getSubjectEnclosureIP();
        } else if (EventHelper.isDeletionEvent(nSMEvent)) {
            eventData = new DeletionEventData(nSMEvent);
            string3 = eventData.getSubject();
            stringArray = new String[]{eventData.getEventID()};
            cIMBeanArray = ((DeletionEventData)eventData).getDeletedObjects();
            if (cIMBeanArray != null && cIMBeanArray.length == 1) {
                cIMBean = cIMBeanArray[0];
            }
            string4 = eventData.getSubjectEnclosureIP();
        } else if (EventHelper.isModificationEvent(nSMEvent)) {
            eventData = new ModificationEventData(nSMEvent);
            string3 = eventData.getSubject();
            stringArray = new String[]{eventData.getEventID()};
            cIMBean = ((ModificationEventData)eventData).getCurrentInstance();
            cIMBean2 = ((ModificationEventData)eventData).getPreviousInstance();
            string4 = eventData.getSubjectEnclosureIP();
        } else if (EventHelper.isPrivateEvent(nSMEvent)) {
            eventData = new ModificationEventData(nSMEvent);
            string3 = eventData.getSubject();
            stringArray = new String[]{eventData.getEventID()};
            cIMBean = ((ModificationEventData)eventData).getCurrentInstance();
            cIMBean2 = ((ModificationEventData)eventData).getPreviousInstance();
            string4 = eventData.getSubjectEnclosureIP();
        }
        boolean bl = false;
        if (EventHelper.isClearAlert(this.topicProperty)) {
            Alarm alarm = EventHelper.clearAlarm(string3, this.topicProperty, this.typeProperty);
            if (alarm == null) {
                Report.info.log(new ActionNotExecutedException("Cannot find Alert Create for requested Alert Clear for action " + this.getActionName()));
                bl = true;
            } else {
                EventHelper.updateCorrelatedEvents(alarm, nSMEvent);
            }
        }
        if (string4 == null) {
            string4 = this.retrieveSubjectEnclosureIP(cIMBean);
        }
        if (!bl) {
            this.doAction(string3, string4, cIMBean, cIMBean2, stringArray, cIMBeanArray, context);
        }
    }

    private String retrieveSubjectEnclosureIP(CIMBean cIMBean) {
        String string = null;
        Properties properties = cIMBean.toProperties();
        String string2 = null;
        String string3 = null;
        if (cIMBean instanceof CIM_System) {
            string3 = properties.getProperty("Name");
            string2 = properties.getProperty("CreationClassName");
        } else if (cIMBean instanceof CIM_LogicalDevice) {
            string3 = properties.getProperty("SystemName");
            string2 = properties.getProperty("SystemCreationClassName");
        } else if (cIMBean instanceof CIM_PhysicalElement) {
            return null;
        }
        TopologyBean topologyBean = TopologyBean.get(com.sun.jade.ui.util.Properties.getDomain());
        TopologyNode topologyNode = topologyBean.getNode(string2, string3);
        if (topologyNode != null) {
            MF mF = topologyNode.getMF();
            try {
                Properties properties2 = mF.getProperties();
                string = properties2.getProperty("ipno");
            }
            catch (RemoteException remoteException) {
                Report.error.log(remoteException.getMessage() + "Unable to retrieve IP Address of Device.");
            }
            Report.trace.log("subjectEnclosureIP = " + string);
        }
        return string;
    }

    private void doAction(String string, String string2, CIMBean cIMBean, CIMBean cIMBean2, String[] stringArray, CIMBean[] cIMBeanArray, Context context) throws ActionNotExecutedException {
        Object object;
        int n = Integer.parseInt(this.severityProperty);
        String string3 = EventConstants.SOURCE_PREFIX + "/" + POLICY_SERVICE + "/" + this.getActionName();
        String string4 = "UNKNOWN";
        long l = System.currentTimeMillis();
        ArrayList<CIMBean> arrayList = new ArrayList<CIMBean>();
        if (cIMBean != null) {
            arrayList.add(cIMBean);
        } else if (cIMBeanArray != null) {
            int n2 = 0;
            while (n2 < cIMBeanArray.length) {
                arrayList.add(cIMBeanArray[n2]);
                ++n2;
            }
        }
        arrayList.addAll(context.getCollection());
        if (this.descriptionInfoAttributes != null) {
            this.descriptionInfo = DescriptionInfoParser.fillDescriptionInfoValues(this.descriptionInfoAttributes, arrayList);
        }
        LocalizedString localizedString = null;
        LocalizedString localizedString2 = null;
        LocalizedString localizedString3 = null;
        AlertEventData.CauseInformation[] causeInformationArray = null;
        if (this.descriptionCode != null) {
            LocalizedString[] localizedStringArray;
            LocalizedString[] localizedStringArray2;
            object = new MessageCode(this.descriptionCode);
            localizedString = ((MessageCode)object).getLocalizedStringMessage(this.descriptionInfo);
            localizedString2 = ((MessageCode)object).getLocalizedStringProperty(PROPERTY_PROBABLE_CAUSE);
            localizedString3 = ((MessageCode)object).getLocalizedStringProperty("recommendedActions");
            if (localizedString2 == null) {
                localizedStringArray2 = null;
            } else {
                LocalizedString[] localizedStringArray3 = new LocalizedString[1];
                localizedStringArray2 = localizedStringArray3;
                localizedStringArray3[0] = localizedString2;
            }
            LocalizedString[] localizedStringArray4 = localizedStringArray2;
            if (localizedString3 == null) {
                localizedStringArray = null;
            } else {
                LocalizedString[] localizedStringArray5 = new LocalizedString[1];
                localizedStringArray = localizedStringArray5;
                localizedStringArray5[0] = localizedString3;
            }
            LocalizedString[] localizedStringArray6 = localizedStringArray;
            causeInformationArray = new AlertEventData.CauseInformation[]{new AlertEventData.CauseInformation(localizedStringArray4, localizedStringArray6, this.urlProperty)};
        }
        object = null;
        if (EventHelper.isModificationEvent(this.topicProperty)) {
            object = new ModificationEventData(n, string3, string, this.topicProperty, this.typeProperty, stringArray, localizedString, null, cIMBean2, cIMBean);
        } else if (EventHelper.isAlertEvent(this.topicProperty)) {
            object = new AlertEventData(n, string3, SequenceNumberGenerator.createSequenceNumber(string3), string, System.currentTimeMillis(), this.topicProperty, this.typeProperty, stringArray, localizedString, System.currentTimeMillis(), this.descriptionCode, "", causeInformationArray);
        } else if (EventHelper.isDefinitionEvent(this.topicProperty)) {
            if (cIMBeanArray == null) {
                cIMBeanArray = new CIMBean[]{cIMBean};
            }
            object = new DefinitionEventData(n, string3, SequenceNumberGenerator.createSequenceNumber(string3), string, System.currentTimeMillis(), this.topicProperty, this.typeProperty, stringArray, localizedString, System.currentTimeMillis(), this.descriptionCode, this.isAuditEvent(), "", cIMBeanArray);
        } else if (EventHelper.isPrivateEvent(this.topicProperty)) {
            object = new ModificationEventData(n, string3, string, this.topicProperty, this.typeProperty, stringArray, localizedString, null, cIMBean2, cIMBean);
        }
        if (object == null) {
            throw new ActionNotExecutedException("Event Type not compatible with NotifyAction " + this.getActionName());
        }
        ((EventData)object).setSubjectEnclosureIP(string2);
        EventGenerator.generateEvent((EventData)object);
        if (this.unitTesting) {
            System.out.println("Recording Event Data");
            this.testEventData = object;
        }
    }

    public Properties toProperties() throws PropertiesPersistenceException {
        Properties properties = super.toProperties();
        this.writeProperties(properties, propertyNames, this.propertyValues);
        return properties;
    }

    private boolean isAuditEvent() {
        if (this.auditProperty == null) {
            return false;
        }
        return Boolean.getBoolean(this.auditProperty);
    }

    public void fromProperties(Properties properties) throws PropertiesPersistenceException {
        this.propertyValues = this.readProperties(properties, propertyNames);
        String string = this.getActionName();
        this.topicProperty = (String)this.propertyValues.get(PROPERTY_EVENT_TOPIC);
        this.typeProperty = (String)this.propertyValues.get(PROPERTY_EVENT_TYPE);
        this.urlProperty = (String)this.propertyValues.get(PROPERTY_URL);
        this.severityProperty = (String)this.propertyValues.get(PROPERTY_SEVERITY);
        this.alertTypeProperty = (String)this.propertyValues.get(PROPERTY_ALERT_TYPE);
        this.eventFormatProperty = (String)this.propertyValues.get(PROPERTY_EVENT_FORMAT);
        this.descriptionCodeProperty = (String)this.propertyValues.get(PROPERTY_DESCRIPTION_CODE);
        this.descriptionInfoAttributeProperty = (String)this.propertyValues.get(PROPERTY_DESCRIPTION_INFOATTRIBUTE);
        this.auditProperty = (String)this.propertyValues.get(PROPERTY_AUDIT);
        if (this.topicProperty == null || this.typeProperty == null || this.severityProperty == null) {
            throw new PropertiesPersistenceException(string + " Action must define all of " + PROPERTY_SEVERITY + "," + PROPERTY_EVENT_TOPIC + ", and " + PROPERTY_EVENT_TYPE);
        }
        Properties properties2 = null;
        if (this.descriptionCodeProperty != null) {
            properties2 = this.getMessageCodes(this.descriptionCodeProperty);
        }
        if (this.descriptionInfoAttributeProperty != null) {
            this.descriptionInfoAttributes = DescriptionInfoParser.getDescriptionInfo(this.descriptionInfoAttributeProperty);
        }
    }

    private Properties getMessageCodes(String string) {
        Report.trace.log("Policy", (Object)("Description Code Property " + string));
        MessageCode messageCode = null;
        int n = string.lastIndexOf(".");
        if (n == -1) {
            messageCode = new MessageCode(string);
        } else {
            String string2 = string.substring(0, n);
            int n2 = -1;
            try {
                if (n < string.length() - 1) {
                    String string3 = string.substring(n + 1);
                    n2 = Integer.valueOf(string3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = "Invalid DescriptionCode property, " + string + ", in policy property file for NotifyAction " + this.getActionName() + ".";
                throw new IllegalArgumentException(string4);
            }
            messageCode = new MessageCode(string2, n2);
        }
        this.descriptionCode = messageCode.getMessageCode();
        Report.trace.log("Policy", (Object)messageCode.toString());
        return messageCode.getMessageProperties();
    }

    public String getTopicProperty() {
        return this.topicProperty;
    }

    public String getTypeProperty() {
        return this.typeProperty;
    }

    public String getSeverityProperty() {
        return this.severityProperty;
    }

    public String getAlertTypeProperty() {
        return this.alertTypeProperty;
    }

    public String getEventFormatProperty() {
        return this.eventFormatProperty;
    }

    public String getDescriptionCodeProperty(String string) {
        return this.descriptionCodeProperty;
    }

    public void setTopicProperty(String string) {
        this.topicProperty = string;
    }

    public void setTypeProperty(String string) {
        this.typeProperty = string;
    }

    public void setSeverityProperty(String string) {
        this.severityProperty = string;
    }

    public void setAlertTypeProperty(String string) {
        this.alertTypeProperty = string;
    }

    public void setEventFormatProperty(String string) {
        this.eventFormatProperty = string;
    }

    public void setDescriptionCodeProperty(String string) {
        this.descriptionCodeProperty = string;
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Action action;
        Object object3;
        Object object4;
        try {
            object4 = ".alert.create.health.array.t3.disk";
            object3 = new Properties();
            ((Properties)object3).setProperty("Action.Test.EventTopic", ".alert.create.health.array.t3.disk");
            ((Properties)object3).setProperty("Action.Test.EventType", "StateChangeAlert");
            ((Properties)object3).setProperty("Action.Test.Severity", Integer.toString(5));
            ((Properties)object3).setProperty("Action.Test.AlertType", "");
            ((Properties)object3).setProperty("Action.Test.DescriptionCode", "23060110");
            ((Properties)object3).setProperty("Action.Test.DescriptionInfo", "0-$StorEdgeT3_DiskDrive.DeviceID,1-$StorEdgeT3_DiskDrive.SystemName");
            action = new NotifyAction("Test");
            ((NotifyAction)action).unitTesting = true;
            ((NotifyAction)action).fromProperties((Properties)object3);
            object2 = new CIMInstance();
            object2.setClassName("TestCI");
            object = new CIMBeanImpl((CIMInstance)object2);
            Vector<CIMBeanImpl> vector = new Vector<CIMBeanImpl>();
            vector.add((CIMBeanImpl)object);
            Context context = new Context();
            ((NotifyAction)action).doAction(vector, context);
            System.out.println("Event Data -> " + ((NotifyAction)action).testEventData.getSubject() + " " + ((NotifyAction)action).testEventData.getTopic() + " " + ((NotifyAction)action).testEventData.getType());
            ((NotifyAction)action).fromProperties((Properties)object3);
            AbstractEventSubscriber abstractEventSubscriber = new AbstractEventSubscriber(){

                public void notify(AbstractEvent abstractEvent) {
                    AlertEventData alertEventData = new AlertEventData((NSMEvent)abstractEvent);
                    AlertEventData.CauseInformation[] causeInformationArray = alertEventData.getCauseInformation();
                    LocalizedString[] localizedStringArray = causeInformationArray[0].getProbableCauses();
                    int n = 0;
                    while (localizedStringArray != null && n < localizedStringArray.length) {
                        System.out.println("ProbableCause = " + localizedStringArray[n].toString());
                        ++n;
                    }
                    LocalizedString[] localizedStringArray2 = causeInformationArray[0].getRecommendedActions();
                    int n2 = 0;
                    while (localizedStringArray2 != null && n2 < localizedStringArray2.length) {
                        System.out.println("RecommendedAction = " + localizedStringArray2[n2].toString());
                        ++n2;
                    }
                }
            };
            BaseServiceFinder.getEventService2().subscribe(abstractEventSubscriber, ".alert");
            ((NotifyAction)action).doAction(vector, context);
            System.out.println("Event Data -> " + ((NotifyAction)action).testEventData.getSubject() + " " + ((NotifyAction)action).testEventData.getTopic() + " " + ((NotifyAction)action).testEventData.getType() + " " + ((NotifyAction)action).testEventData.getDescription() + " " + ((NotifyAction)action).testEventData.getEventCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object4 = new Properties();
        ((Properties)object4).setProperty("Action.a.Type", "com.sun.jade.policy.NotifyAction");
        ((Properties)object4).setProperty("Action.a.EventTopic", ".state.test");
        ((Properties)object4).setProperty("Action.a.ActionOrder", "2");
        ((Properties)object4).setProperty("Action.a.Severity", "3");
        ((Properties)object4).setProperty("Action.a.EventType", "StateChangeEvent");
        ((Properties)object4).setProperty("Action.a.DescriptionCode", "24010110");
        ((Properties)object4).setProperty("Action.a.DescriptionInfo", "0-$CIM_FibrePort.DeviceID,1-$CIM_FibrePort.SystemName,2-$TestCondition.previousValue,3-$TestCondition.currentValue,4-$TestCondition.interval_min");
        object3 = new AbstractEventSubscriber(){

            public void notify(AbstractEvent abstractEvent) {
                if (abstractEvent == null) {
                    System.err.println("Event is null");
                    return;
                }
                ModificationEventData modificationEventData = new ModificationEventData(abstractEvent);
                if (modificationEventData == null) {
                    System.err.println("Event Data is null");
                }
                String string = modificationEventData.getDescription().toString();
                System.out.println(string);
            }
        };
        try {
            action = Action.newInstance("a", (Properties)object4);
            object2 = new Context();
            ((Context)object2).saveAttr("TestCondition", "interval_sec", "300");
            ((Context)object2).saveAttr("TestCondition", "interval_min", "5");
            ((Context)object2).saveAttr("TestCondition", "currentValue", "70");
            ((Context)object2).saveAttr("TestCondition", "previousValue", "30");
            object = UnitTestHelper.createNSMEvent("30", "70");
            BaseServiceFinder.getEventService2().subscribe((AbstractEventSubscriber)object3, ".state");
            action.doAction((NSMEvent)object, (Context)object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

