/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.policy;

import com.sun.jade.policy.Policy;
import com.sun.jade.policy.PolicyException;
import com.sun.jade.policy.PolicyGroup;
import com.sun.jade.policy.PolicyRule;
import com.sun.jade.policy.PolicyService;
import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.PropertiesPersister;
import com.sun.jade.util.log.Report;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class PolicyServiceImpl
implements PolicyService {
    private String policies_directory;
    private Vector policyList;
    private static final String POLICY_DIR_NAME = "policies";
    private static PolicyServiceImpl policyServiceImplInstance = null;
    private static final String POLICY_INSTANTIATION_ERROR_MSG = "Attempting to instantiate PolicyService from Properties";

    private PolicyServiceImpl() throws PolicyException {
        Object var1_1 = null;
        try {
            this.policies_directory = PropertiesPersister.getSaveDir() + File.separator + POLICY_DIR_NAME;
            this.policyList = new Vector();
            this.init();
        }
        catch (PropertiesPersistenceException propertiesPersistenceException) {
            Exception exception = propertiesPersistenceException.getNestedException();
            if (exception != null) {
                Report.error.log(exception, (Object)POLICY_INSTANTIATION_ERROR_MSG);
            } else {
                Report.error.log(propertiesPersistenceException, (Object)POLICY_INSTANTIATION_ERROR_MSG);
            }
            throw new PolicyException("Unable to start Policy Service", propertiesPersistenceException);
        }
        Report.trace.log("Policy", (Object)"PolicyService Started...");
    }

    public static PolicyServiceImpl getService() throws PolicyException {
        if (policyServiceImplInstance == null) {
            policyServiceImplInstance = new PolicyServiceImpl();
        }
        return policyServiceImplInstance;
    }

    private void init() throws PropertiesPersistenceException {
        File file = new File(this.policies_directory);
        if (!file.isDirectory()) {
            throw new PropertiesPersistenceException("The Policy Properties Directory does not exist: " + this.policies_directory);
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (!fileArray[n].isFile()) {
                Report.error.log("Policy", (Object)("The file " + fileArray[n].getName() + " does not exist"));
            } else if (!fileArray[n].isDirectory()) {
                PolicyRule policyRule = new PolicyRule();
                try {
                    PropertiesPersister.restoreProperties(policyRule, file.getName() + File.separator + fileArray[n].getName());
                    this.policyList.add(policyRule);
                    Report.trace.log("Policy", (Object)("Policy: " + policyRule.getCommonName() + " loaded."));
                }
                catch (PropertiesPersistenceException propertiesPersistenceException) {
                    Report.error.log("PolicyServiceImpl: ERROR: Unable to load Policy File: " + fileArray[n].getName());
                }
            }
            ++n;
        }
    }

    public PolicyGroup getPolicyGroup(String string, String string2) {
        PolicyGroup policyGroup = new PolicyGroup(string);
        Report.trace.log("Policy", (Object)("Created new PolicyGroup:" + string));
        Report.trace.log("Policy", (Object)("PolicyRoleSelector = " + string2));
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "&");
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(stringTokenizer.nextToken());
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Iterator iterator2 = this.policyList.iterator();
            while (iterator2.hasNext()) {
                Policy policy = (Policy)iterator2.next();
                Set set = policy.getPolicyRoles();
                if (!set.contains(string3)) continue;
                policyGroup.addPolicy(policy);
            }
        }
        return policyGroup;
    }

    public static void main(String[] stringArray) {
        try {
            Policy policy;
            PolicyServiceImpl policyServiceImpl = PolicyServiceImpl.getService();
            PolicyGroup policyGroup = policyServiceImpl.getPolicyGroup("StorAdeSwitch_System", "Loop");
            policyGroup.activate();
            System.out.println(policyGroup);
            Collection collection = policyGroup.getPolicies();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                policy = (PolicyRule)iterator.next();
                System.out.println("The FILTER is " + ((PolicyRule)policy).getFilter());
            }
            policy = policyServiceImpl.getPolicyGroup("StorEdgeT3_System", "Disk&&T3");
            ((PolicyGroup)policy).activate();
            Vector vector = new Vector();
            vector = ((PolicyGroup)policy).getGroupFilters();
            int n = 0;
            while (n < vector.size()) {
                System.out.println("FILTER No. " + n + "= " + vector.elementAt(n).toString());
                ++n;
            }
        }
        catch (PolicyException policyException) {
            policyException.printStackTrace();
        }
    }
}

