/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.services.notification.LogServiceAdapter;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class EventCache {
    private static final String COMP_NAME = "EventCache";
    private final String EXTENSION = ".ev";
    private final String BAD_EXTENSION = ".bad";
    private final String payloadPath;
    private final String writtenExtension;
    private static List filesBeingProcessed = new ArrayList();
    private static final String sccs_id = "@(#)EventCache.java\t1.2 01/11/02 SMI";

    public EventCache(String string, String string2) {
        this.payloadPath = string;
        this.writtenExtension = string2;
    }

    public void writeEvent(AbstractEvent abstractEvent, String string) {
        NSMEvent nSMEvent = (NSMEvent)abstractEvent;
        if (string == null) {
            string = "";
        }
        String string2 = this.payloadPath + "/" + nSMEvent.getSourceSequenceNumber() + string + ".ev";
        try {
            String string3 = null;
            string3 = nSMEvent.getPayload() == null ? "No\nPayload" : nSMEvent.getPayload().toString();
            File file = new File(string2);
            LogServiceAdapter.log("trace", COMP_NAME, "Writing event " + nSMEvent.getEventID() + " to file " + file.getName());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println(string3);
            printStream.flush();
            printStream.close();
            fileOutputStream.close();
            File file2 = new File(string2);
            File file3 = new File(string2 + this.writtenExtension);
            LogServiceAdapter.log("trace", COMP_NAME, "Renaming event to file " + file3.getName());
            boolean bl = file2.renameTo(file3);
            if (!bl) {
                LogServiceAdapter.log("error", COMP_NAME, "Could not rename file " + file2.getAbsolutePath() + "/" + file2.getName() + " to " + file3.getAbsolutePath() + "/" + file3.getName() + ".  This file will not be sent to Notifier.");
            }
        }
        catch (IOException iOException) {
            LogServiceAdapter.log("error", COMP_NAME, "Failed to write event payload to file " + string2, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getUnprocessedFiles(final FilenameFilter filenameFilter) {
        File[] fileArray = null;
        EventCache eventCache = this;
        synchronized (eventCache) {
            block4: {
                fileArray = new File(this.payloadPath).listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return (filenameFilter == null || filenameFilter.accept(file, string)) && string.endsWith(EventCache.this.writtenExtension) && !EventCache.this.beingProcessed(new File(file.getAbsoluteFile() + "/" + string));
                    }
                });
                if (fileArray.length != 0) break block4;
                File[] fileArray2 = null;
                return fileArray2;
            }
            this.markAsBeingProcessed(fileArray, true);
        }
        return fileArray;
    }

    public synchronized void markAsBeingProcessed(File[] fileArray, boolean bl) {
        int n = 0;
        while (n < fileArray.length) {
            if (bl) {
                filesBeingProcessed.add(fileArray[n]);
            } else {
                filesBeingProcessed.remove(fileArray[n]);
            }
            ++n;
        }
    }

    private synchronized boolean beingProcessed(File file) {
        return filesBeingProcessed.contains(file);
    }

    public void deleteFiles(File[] fileArray) {
        int n = 0;
        while (n < fileArray.length) {
            this.deleteFile(fileArray[n]);
            ++n;
        }
    }

    public void deleteFile(File file) {
        LogServiceAdapter.log("trace", COMP_NAME, "Deleting file " + file.getName());
        boolean bl = file.delete();
        if (!bl) {
            LogServiceAdapter.log("error", COMP_NAME, "Deletion of file " + file + " failed.");
        } else {
            this.markAsBeingProcessed(new File[]{file}, false);
        }
    }

    public void markFileAsBad(File file) {
        LogServiceAdapter.log("trace", COMP_NAME, "Renaming file " + file.getName() + " to " + file.getName() + ".bad");
        File file2 = new File(file.getAbsoluteFile() + ".bad");
        if (!file.renameTo(file2)) {
            LogServiceAdapter.log("error", COMP_NAME, "Rename of file " + file + " to " + file2 + " failed.  Will try to delete.");
            this.deleteFile(file);
        } else {
            this.markAsBeingProcessed(new File[]{file}, false);
        }
    }
}

