/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification;

import com.sun.jade.services.event.EventService;
import com.sun.jade.services.notification.JadeESContractReactor;
import com.sun.jade.services.notification.JadeFilter;
import com.sun.jade.util.jini.BaseServiceFinder;
import com.sun.netstorage.mgmt.service.notification.SelectorSpecification;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.Notifier;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.SelectorManager;
import java.util.HashMap;
import java.util.Map;

public class JadeESSelectorManager
implements SelectorManager {
    private static EventService eventService;
    private static Map reactors;
    private static Map filters;

    public void create(SelectorSpecification selectorSpecification, long l, Notifier notifier) {
        if (eventService == null) {
            JadeESSelectorManager.createEventService();
        }
        JadeFilter jadeFilter = JadeESSelectorManager.getFilter(selectorSpecification);
        JadeESContractReactor jadeESContractReactor = new JadeESContractReactor(jadeFilter, l, notifier);
        String[] stringArray = selectorSpecification.getTopics();
        int n = 0;
        while (n < stringArray.length) {
            eventService.subscribePublic(jadeESContractReactor, stringArray[n]);
            ++n;
        }
        jadeESContractReactor.setTopics(stringArray);
        reactors.put(new Long(l), jadeESContractReactor);
    }

    public void destroy(long l) {
        JadeESContractReactor jadeESContractReactor = (JadeESContractReactor)reactors.remove(new Long(l));
        String[] stringArray = jadeESContractReactor.getTopics();
        int n = 0;
        while (n < stringArray.length) {
            eventService.unsubscribe(jadeESContractReactor, stringArray[n]);
            ++n;
        }
    }

    private static void createEventService() {
        eventService = BaseServiceFinder.getEventService2();
    }

    private static JadeFilter getFilter(SelectorSpecification selectorSpecification) {
        String string = selectorSpecification.getCriteria();
        if (filters.containsKey(string)) {
            return (JadeFilter)filters.get(string);
        }
        JadeFilter jadeFilter = null;
        if (string != null && !string.equals("")) {
            jadeFilter = new JadeFilter();
            jadeFilter.setCriteria(selectorSpecification);
        }
        filters.put(string, jadeFilter);
        return jadeFilter;
    }

    static {
        reactors = new HashMap();
        filters = new HashMap();
    }
}

