/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification;

import com.sun.jade.services.notification.LogServiceAdapter;
import fr.dyade.jdring.AlarmEntry;
import fr.dyade.jdring.AlarmListener;
import fr.dyade.jdring.AlarmManager;
import fr.dyade.jdring.PastDateException;

public class Scheduler {
    public static final String COMP_NAME = "Scheduler";
    private static AlarmManager mgr = new AlarmManager();

    public static Ticket scheduleTask(int n, Runnable runnable) {
        return Scheduler.scheduleTask(n, true, runnable);
    }

    public static Ticket scheduleTask(int n, boolean bl, Runnable runnable) {
        try {
            AlarmEntry alarmEntry = mgr.addAlarm(n, bl, (AlarmListener)new TaskRunner(runnable));
            Ticket ticket = new Ticket(alarmEntry);
            return ticket;
        }
        catch (PastDateException pastDateException) {
            LogServiceAdapter.log("error", COMP_NAME, "Was unable to schedule NetConnect because of incorrect date.", (Exception)((Object)pastDateException));
            return null;
        }
    }

    public static Ticket scheduleTask(int n, int n2, Runnable runnable) {
        try {
            AlarmEntry alarmEntry = mgr.addAlarm(n2, n, -1, -1, -1, -1, (AlarmListener)new TaskRunner(runnable));
            Ticket ticket = new Ticket(alarmEntry);
            return ticket;
        }
        catch (PastDateException pastDateException) {
            LogServiceAdapter.log("error", COMP_NAME, "Was unable to schedule NetConnect because of incorrect date.", (Exception)((Object)pastDateException));
            return null;
        }
    }

    private static class TaskRunner
    implements AlarmListener {
        private Runnable task;

        public TaskRunner(Runnable runnable) {
            this.task = runnable;
        }

        public void handleAlarm(AlarmEntry alarmEntry) {
            LogServiceAdapter.log("trace", Scheduler.COMP_NAME, "handleAlarm()");
            Thread thread = new Thread(this.task);
            thread.start();
        }
    }

    public static class Ticket {
        private AlarmEntry alarmEntry;

        public Ticket(AlarmEntry alarmEntry) {
            this.alarmEntry = alarmEntry;
        }

        public void cancel() {
            mgr.removeAlarm(this.alarmEntry);
        }
    }
}

