/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification.regex;

import com.sun.jade.util.log.Report;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Expression {
    static final String LIKE = "LIKE";
    static final String EQ = "=";
    static final String NE = "!=";
    static final String GT = ">";
    static final String GE = ">=";
    static final String LT = "<";
    static final String LE = "<=";
    String type;
    String operator;
    String value;
    Object object;

    public Expression(String string, String string2, String string3) {
        this.type = string;
        this.operator = string2;
        this.value = string3;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    private Object getResult() throws IllegalAccessException, InvocationTargetException {
        if (this.object == null) {
            throw new IllegalStateException("No object");
        }
        Object object = null;
        Method[] methodArray = this.object.getClass().getMethods();
        if (methodArray != null) {
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (method.getName().equals("get" + this.type) && method.getParameterTypes().length == 0) {
                    try {
                        object = method.invoke(this.object, (Object[])null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Report.error.log("Cannot introspect object");
                        throw illegalAccessException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Report.error.log("Cannot introspect object");
                        throw invocationTargetException;
                    }
                }
                ++n;
            }
        }
        return object;
    }

    private boolean evaluateLike(Object object) {
        Pattern pattern = Pattern.compile(this.value);
        Matcher matcher = pattern.matcher(object.toString());
        return matcher.matches();
    }

    private boolean evaluateEQ(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            Integer n2 = new Integer(this.value);
            return n.intValue() == n2.intValue();
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            Float f2 = new Float(this.value);
            return f.floatValue() == f2.floatValue();
        }
        return object.equals(this.value);
    }

    private boolean evaluateNE(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            Integer n2 = new Integer(this.value);
            return n.intValue() != n2.intValue();
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            Float f2 = new Float(this.value);
            return f.floatValue() != f2.floatValue();
        }
        return !object.equals(this.value);
    }

    private boolean evaluateGT(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            Integer n2 = new Integer(this.value);
            return n > n2;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            Float f2 = new Float(this.value);
            return f.floatValue() > f2.floatValue();
        }
        throw new IllegalArgumentException();
    }

    private boolean evaluateGE(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            Integer n2 = new Integer(this.value);
            return n >= n2;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            Float f2 = new Float(this.value);
            return f.floatValue() >= f2.floatValue();
        }
        throw new IllegalArgumentException();
    }

    private boolean evaluateLT(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            Integer n2 = new Integer(this.value);
            return n < n2;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            Float f2 = new Float(this.value);
            return f.floatValue() < f2.floatValue();
        }
        throw new IllegalArgumentException();
    }

    private boolean evaluateLE(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            Integer n2 = new Integer(this.value);
            return n <= n2;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            Float f2 = new Float(this.value);
            return f.floatValue() <= f2.floatValue();
        }
        throw new IllegalArgumentException();
    }

    public boolean evaluate() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        boolean bl = false;
        Object object = this.getResult();
        Report.debug.log("Criteria: " + this);
        Report.debug.log("Evaluating: " + object);
        if (object == null) {
            return false;
        }
        if (LIKE.equals(this.operator)) {
            bl = this.evaluateLike(object);
        } else if (EQ.equals(this.operator)) {
            bl = this.evaluateEQ(object);
        } else if (NE.equals(this.operator)) {
            bl = this.evaluateNE(object);
        } else if (GT.equals(this.operator)) {
            bl = this.evaluateGT(object);
        } else if (GE.equals(this.operator)) {
            bl = this.evaluateGE(object);
        } else if (LT.equals(this.operator)) {
            bl = this.evaluateLT(object);
        } else if (LE.equals(this.operator)) {
            bl = this.evaluateLE(object);
        } else {
            throw new IllegalArgumentException("Unknown operator: " + this.operator);
        }
        return bl;
    }

    public String toString() {
        return this.type + " " + this.operator + " " + this.value;
    }
}

