/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification.srs;

import com.sun.jade.cim.bean.CIM_System;
import com.sun.jade.cim.util.CIMBean;
import com.sun.jade.event.AlertEventData;
import com.sun.jade.event.DefinitionEventData;
import com.sun.jade.event.DeletionEventData;
import com.sun.jade.event.EventData;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.services.notification.LogServiceAdapter;
import com.sun.jade.services.notification.ModificationException;
import com.sun.jade.services.notification.Modifier;
import com.sun.jade.services.notification.NotificationProperties;
import com.sun.jade.services.notification.srs.SRSUtils;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SRSModifier
implements Modifier {
    private static final String COMP_NAME = "SRSModifier";
    private static final String PROP_PREFIX = "SRSModifier".toLowerCase();
    private static final String IP_IDENTIFYING_DESCRIPTION = "IP Address";
    private static Hashtable deviceInfo = new Hashtable();
    public static final String sccs_id = "@(#)SRSModifier.java\t1.10 10/21/02 SMI";

    public void modify(AbstractEvent abstractEvent) throws ModificationException {
        NSMEvent nSMEvent = (NSMEvent)abstractEvent;
        String string = nSMEvent.getTopic();
        if (string.startsWith(".alert.create")) {
            this.modifyAlert(nSMEvent);
        } else if (string.startsWith(".definition.create")) {
            this.modifyDefinitionOrDeletion(nSMEvent, true);
        } else if (string.startsWith(".definition.delete")) {
            this.modifyDefinitionOrDeletion(nSMEvent, false);
        }
    }

    private void modifyAlert(NSMEvent nSMEvent) throws ModificationException {
        Object object;
        AlertEventData alertEventData = null;
        try {
            alertEventData = new AlertEventData(nSMEvent);
        }
        catch (Exception exception) {
            throw new ModificationException("Failed to create AlertEventData from event.", exception);
        }
        String string = nSMEvent.getEventID();
        String string2 = SRSUtils.getTimestamp(new Date(nSMEvent.getSourceTime()));
        String string3 = "O";
        String string4 = "" + (new Integer(nSMEvent.getSeverity()) + 1);
        String string5 = nSMEvent.getType();
        String string6 = alertEventData.getSubjectEnclosureIP();
        try {
            object = InetAddress.getByName(string6);
            string6 = ((InetAddress)object).getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = alertEventData.getDescription().getLocalizedMessage();
        if (object == null) {
            throw new ModificationException("Alert had no description.");
        }
        String string7 = alertEventData.getSubjectEnclosureIP();
        String string8 = "    <alarm source=\"" + string7 + "\" provider=\"" + "RASAGENT" + "\" module=\"" + string6 + "\" alarm_id=\"" + string + "\" timestamp=\"" + string2 + "\" state=\"" + string3 + "\" severity=\"" + string4 + "\" type=\"" + string5 + "\">\n" + "        " + (String)object + "\n" + "    </alarm>\n";
        nSMEvent.setPayload(string8);
    }

    private String getDescription(Object[] objectArray, String string) {
        String string2 = "No Description.";
        if (string == null) {
            return string2;
        }
        return "Description not implemented.";
    }

    private void modifyDefinitionOrDeletion(NSMEvent nSMEvent, boolean bl) throws ModificationException {
        EventData eventData = null;
        if (bl) {
            try {
                eventData = new DefinitionEventData(nSMEvent);
            }
            catch (Exception exception) {
                throw new ModificationException("Failed to create DefinitionEventData from event.", exception);
            }
        }
        try {
            eventData = new DeletionEventData(nSMEvent);
        }
        catch (Exception exception) {
            throw new ModificationException("Failed to create DeletionEventData from event.", exception);
        }
        String string = SRSUtils.getTimestamp(new Date(nSMEvent.getSourceTime()));
        String string2 = "INCREMENTAL";
        String string3 = null;
        CIMBean[] cIMBeanArray = null;
        cIMBeanArray = bl ? ((DefinitionEventData)eventData).getDefinedObjects() : ((DeletionEventData)eventData).getDeletedObjects();
        if (cIMBeanArray != null) {
            int n = 0;
            while (n < cIMBeanArray.length) {
                CIMBean cIMBean = cIMBeanArray[n];
                if (cIMBean instanceof CIM_System) {
                    Object object;
                    String string4;
                    CIM_System cIM_System = (CIM_System)cIMBean;
                    String string5 = bl ? "ADD" : "REMOVE";
                    String string6 = this.getType(cIM_System.getCreationClassName());
                    String string7 = string4 = eventData.getSubjectEnclosureIP();
                    try {
                        object = InetAddress.getByName(string4);
                        string7 = ((InetAddress)object).getHostName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = string7;
                    if (this.isSanDevice(cIM_System.getCreationClassName())) {
                        String string8 = "SAN_" + string6;
                        string3 = "        <group name=\"" + string8 + "\" type=\"" + string6.toLowerCase() + "\">\n";
                        string3 = string3 + "          <node action=\"" + string5 + "\" address=\"" + string4 + "\" name=\"" + string7 + "\" model=\"" + string6.toLowerCase() + "\" serial=\"" + (String)object + "\"/>\n";
                        string3 = string3 + "        </group>\n";
                        break;
                    }
                    throw new ModificationException("Devices of type " + cIM_System.getCreationClassName() + " are not yet supported by the SRSModifier.");
                }
                ++n;
            }
        }
        String string9 = "    <topology type=\"" + string2 + "\">\n" + "      <provider name=\"" + "RASAGENT" + "\" vendor=\"" + "Sun Microsystems Inc." + "\" version=\"" + SRSUtils.PROVIDER_VERSION + "\" description=\"" + "Diagnostic Expert" + "\"/>\n" + string3 + "    </topology>\n";
        nSMEvent.setPayload(string9);
    }

    private boolean isSanDevice(String string) {
        DeviceInfo deviceInfo = (DeviceInfo)SRSModifier.deviceInfo.get(string);
        return deviceInfo != null && deviceInfo.isSan();
    }

    private String getType(String string) {
        DeviceInfo deviceInfo = (DeviceInfo)SRSModifier.deviceInfo.get(string);
        if (deviceInfo == null) {
            return "UnknownDevice";
        }
        return deviceInfo.getType();
    }

    static {
        String string = "";
        Properties properties = NotificationProperties.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(PROP_PREFIX + ".deviceInfo")) continue;
            String string3 = (String)properties.get(string2);
            DeviceInfo deviceInfo = new DeviceInfo(string3);
            LogServiceAdapter.log("trace", COMP_NAME, deviceInfo.toString());
            SRSModifier.deviceInfo.put(deviceInfo.getClassName(), deviceInfo);
        }
    }

    private static class DeviceInfo {
        private String className;
        private String type;
        private boolean isSan;

        public DeviceInfo(String string) {
            int n = string.indexOf(44);
            int n2 = string.indexOf(44, n + 1);
            this.className = string.substring(0, n);
            this.type = string.substring(n + 1, n2);
            this.isSan = new Boolean(string.substring(n2 + 1));
        }

        public String getClassName() {
            return this.className;
        }

        public String getType() {
            return this.type;
        }

        public boolean isSan() {
            return this.isSan;
        }

        public String toString() {
            return "DeviceInfo:className=" + this.className + ",type=" + this.type + ",isSan=" + this.isSan;
        }
    }
}

