/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification.srs;

import com.sun.jade.event.NSMEvent;
import com.sun.jade.services.notification.EventCache;
import com.sun.jade.services.notification.LogServiceAdapter;
import com.sun.jade.services.notification.ModificationException;
import com.sun.jade.services.notification.NWSNotifier;
import com.sun.jade.services.notification.Scheduler;
import com.sun.jade.services.notification.srs.SRSNotifierManager;
import com.sun.jade.services.notification.srs.SRSNotifierSpecification;
import com.sun.jade.services.notification.srs.SRSUtils;
import com.sun.jade.util.http.EnhancedURLConnection;
import com.sun.netstorage.mgmt.service.event.AbstractEvent;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class SRSNotifier
extends NWSNotifier
implements Runnable {
    public static final String COMP_NAME = "SRSNotifier";
    private static final String SRS_EXTENSION = ".srs";
    private static EventCache cache = null;
    private static int sequenceNumber = 0;
    private static SRSNotifierManager manager;
    private SRSNotifierSpecification SRSSpec;
    private static Scheduler.Ticket retryTicket;
    private static Object retryTicketLock;
    private static boolean paused;
    private Vector discoveredDevices = new Vector();
    private static final String sccs_id = "@(#)SRSNotifier.java\t1.13 11/14/02 SMI";

    public SRSNotifier(SRSNotifierSpecification sRSNotifierSpecification) throws ContractSpecificationException {
        super(sRSNotifierSpecification);
        this.SRSSpec = sRSNotifierSpecification;
        cache = new EventCache(SRSNotifierManager.getPayloadPath(), SRS_EXTENSION);
    }

    protected static void setSRSNotifierManager(SRSNotifierManager sRSNotifierManager) {
        manager = sRSNotifierManager;
    }

    public void notify(AbstractEvent abstractEvent) {
        NSMEvent nSMEvent = (NSMEvent)abstractEvent;
        if (paused) {
            LogServiceAdapter.log("trace", COMP_NAME, "Received notification of event " + nSMEvent.getEventID() + " but I am paused.  Discarding...");
            return;
        }
        LogServiceAdapter.log("trace", COMP_NAME, "Received notification of event " + nSMEvent.getEventID() + " sending to SRS.");
        String string = abstractEvent.getTopic();
        if (string.startsWith(".definition.create") || string.startsWith(".definition.audit")) {
            String string2 = abstractEvent.getSubject();
            if (this.discoveredDevices.contains(string2)) {
                return;
            }
            this.discoveredDevices.addElement(string2);
        }
        try {
            this.preNotify(abstractEvent);
        }
        catch (ModificationException modificationException) {
            LogServiceAdapter.log("error", COMP_NAME, "PreNotify failed due to an exception while modifying an event's payload.  This event will be ignored.", modificationException);
            Exception exception = modificationException.getNestedException();
            if (exception != null) {
                LogServiceAdapter.log("error", COMP_NAME, "Nested Exception was: ", exception);
            }
            this.logEvent(nSMEvent);
            return;
        }
        nSMEvent.setPayload(SRSNotifier.getSRSMessage(nSMEvent));
        cache.writeEvent(abstractEvent, null);
        this.runSRS();
    }

    private void runSRS() {
    }

    private static String getSRSMessage(NSMEvent nSMEvent) {
        String string = SRSUtils.getTimestamp(new Date(nSMEvent.getSourceTime()));
        String string2 = "<?xml version=\"1.0\" encoding=\"US-ASCII\" standalone=\"no\"?>\n<!DOCTYPE srs_station_message SYSTEM \"http://localhost/srs_station_message.dtd\">\n  <srs_station_message seq_no=\"" + sequenceNumber + "\" timestamp=\"" + string + "\" sourceIP=\"" + SRSUtils.getSourceIP() + "\" sourceName=\"" + "Diagnostic Expert" + "\">\n" + nSMEvent.getPayload() + "  </srs_station_message>\n";
        ++sequenceNumber;
        return string2;
    }

    protected static void sendHeartbeat(int n) {
        if (manager.isPaused()) {
            return;
        }
        LogServiceAdapter.log("trace", COMP_NAME, "Sending Heartbeat");
        NSMEvent nSMEvent = new NSMEvent("lubdub", "notifier", ".private.devnull");
        nSMEvent.setSourceTime(System.currentTimeMillis());
        String string = "    <heartbeat period=\"" + SRSNotifierManager.getHeartbeatInterval() + "\" />\n";
        nSMEvent.setPayload(string);
        String string2 = SRSNotifier.getSRSMessage(nSMEvent);
        nSMEvent.setPayload(string2);
        SRSNotifier.transmitMessageToSRS((String)nSMEvent.getPayload(), manager.getNotifierProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int transmitFileToSRS(File file) {
        Object object;
        String string;
        block12: {
            LogServiceAdapter.log("trace", COMP_NAME, "Reading file " + file.getName() + " for transmission to SRS.");
            string = null;
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(file));
            object = null;
            string = "";
            while ((object = bufferedReader.readLine()) != null) {
                string = string + (String)object + "\n";
            }
            Object var7_6 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block12;
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    LogServiceAdapter.log("error", COMP_NAME, "Exception while trying to read event from file " + file.getName(), exception);
                    int n = -2;
                    Object var7_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        object = manager.getNotifierProperties();
        return SRSNotifier.transmitMessageToSRS(string, (Properties)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int transmitMessageToSRS(String string, Properties properties) {
        int n;
        block11: {
            n = -1;
            PrintStream printStream = null;
            EnhancedURLConnection enhancedURLConnection = null;
            URLConnection uRLConnection = null;
            LogServiceAdapter.log("trace", COMP_NAME, "Transmitting message to SRS. Props: \n" + properties);
            LogServiceAdapter.log("trace", COMP_NAME, "Message=\n" + string);
            System.out.println("Sending Message: " + string);
            try {
                enhancedURLConnection = new EnhancedURLConnection(properties);
                uRLConnection = enhancedURLConnection.getUnconnectedConnection();
                printStream = new PrintStream(uRLConnection.getOutputStream(), true);
            }
            catch (Exception exception) {
                LogServiceAdapter.log("error", COMP_NAME, "Exception while trying to create SRS http connection with properties " + properties, exception);
                return n;
            }
            LogServiceAdapter.log("trace", COMP_NAME, "Sending message to SRS:\n" + string);
            printStream.print(string);
            uRLConnection.connect();
            InputStream inputStream = uRLConnection.getInputStream();
            inputStream.read();
            inputStream.close();
            Object var8_9 = null;
            try {
                n = ((HttpURLConnection)uRLConnection).getResponseCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LogServiceAdapter.log("trace", COMP_NAME, "Got Response Code " + n);
            printStream.close();
            {
                break block11;
                catch (Exception exception) {
                    LogServiceAdapter.log("error", COMP_NAME, "Exception while writing message to SRS http connection with properties " + properties, exception);
                    Object var8_10 = null;
                    try {
                        n = ((HttpURLConnection)uRLConnection).getResponseCode();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    LogServiceAdapter.log("trace", COMP_NAME, "Got Response Code " + n);
                    printStream.close();
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    n = ((HttpURLConnection)uRLConnection).getResponseCode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LogServiceAdapter.log("trace", COMP_NAME, "Got Response Code " + n);
                printStream.close();
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = retryTicketLock;
        synchronized (object) {
            if (paused) {
                LogServiceAdapter.log("trace", COMP_NAME, "Executing scheduled retry, but am paused.  Will not execute.  Event will be left in cache for delivery once resumed.");
            } else {
                LogServiceAdapter.log("trace", COMP_NAME, "Executing scheduled retry.");
            }
            retryTicket = null;
        }
        this.runSRS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void scheduleRetry() {
        Object object = retryTicketLock;
        synchronized (object) {
            Scheduler.Ticket ticket;
            if (retryTicket != null) {
                LogServiceAdapter.log("trace", COMP_NAME, "Cancelling scheduled retry.");
                this.unschedule();
            }
            int n = SRSNotifierManager.getRetryInterval();
            LogServiceAdapter.log("trace", COMP_NAME, "Scheduling retry of SRS transfer in " + n + " minutes.");
            retryTicket = ticket = Scheduler.scheduleTask(n, false, (Runnable)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void unschedule() {
        Object object = retryTicketLock;
        synchronized (object) {
            if (retryTicket == null) {
                return;
            }
            retryTicket.cancel();
            retryTicket = null;
        }
    }

    public void resume() {
        paused = false;
    }

    public void pause() {
        paused = true;
        this.unschedule();
    }

    static {
        retryTicketLock = new Object();
        paused = false;
    }
}

