/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.services.notification.srs;

import com.sun.jade.services.notification.srs.SRSHeartbeat;
import com.sun.jade.services.notification.srs.SRSNotifier;
import com.sun.jade.services.notification.srs.SRSNotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.Notifier;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.NotifierManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;

public class SRSNotifierManager
implements NotifierManager {
    private static Properties myProps = null;
    private static SRSHeartbeat heartbeat;
    private static Timer timer;
    private HashMap notifiers = new HashMap();
    private boolean isPaused;
    private static final String sccs_id = "@(#)SRSNotifierManager.java\t1.7 10/21/02 SMI";

    public Notifier create(NotifierSpecification notifierSpecification, long l) throws ContractSpecificationException {
        SRSNotifier sRSNotifier = new SRSNotifier((SRSNotifierSpecification)notifierSpecification);
        SRSNotifier.setSRSNotifierManager(this);
        this.notifiers.put(new Long(l), sRSNotifier);
        if (this.isPaused()) {
            sRSNotifier.pause();
        } else {
            sRSNotifier.resume();
        }
        if (heartbeat == null) {
            this.startHeartbeat();
        }
        return sRSNotifier;
    }

    public void destroy(long l, boolean bl) throws ContractSpecificationException {
        SRSNotifier sRSNotifier = (SRSNotifier)this.notifiers.remove(new Long(l));
        if (sRSNotifier == null) {
            throw new ContractSpecificationException(202);
        }
        sRSNotifier.unschedule();
    }

    protected static String getPayloadPath() {
        return myProps.getProperty("payloadPath");
    }

    protected static int getRetryInterval() {
        return new Integer(myProps.getProperty("retryInterval"));
    }

    protected static int getHeartbeatInterval() {
        return new Integer(myProps.getProperty("heartbeatInterval"));
    }

    public void setNotifierProperties(Properties properties) {
        myProps = properties;
        if (heartbeat != null) {
            this.checkHeartbeat();
        }
    }

    public Properties getNotifierProperties() {
        return myProps;
    }

    public void resume() {
        this.isPaused = false;
        Iterator iterator = this.notifiers.values().iterator();
        while (iterator.hasNext()) {
            Notifier notifier = (Notifier)iterator.next();
            notifier.resume();
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pause() {
        this.isPaused = true;
        Iterator iterator = this.notifiers.values().iterator();
        while (iterator.hasNext()) {
            Notifier notifier = (Notifier)iterator.next();
            notifier.pause();
        }
    }

    public void modify(long l, NotifierSpecification notifierSpecification) throws ContractSpecificationException {
        this.destroy(l, false);
        SRSNotifier sRSNotifier = (SRSNotifier)this.create(notifierSpecification, l);
        sRSNotifier.scheduleRetry();
    }

    private void checkHeartbeat() {
        int n = SRSNotifierManager.getHeartbeatInterval();
        if (n == 0) {
            return;
        }
        int n2 = heartbeat.getInterval();
        if (n2 != n) {
            this.stopHeartbeat();
            this.startHeartbeat();
        }
    }

    private void startHeartbeat() {
        int n = SRSNotifierManager.getHeartbeatInterval();
        if (n == 0) {
            return;
        }
        heartbeat = new SRSHeartbeat(n);
        timer.schedule((TimerTask)heartbeat, new Date(), (long)(n * 60000));
    }

    private void stopHeartbeat() {
        int n = SRSNotifierManager.getHeartbeatInterval();
        if (n == 0) {
            return;
        }
        if (heartbeat == null) {
            return;
        }
        heartbeat.cancel();
    }

    static {
        timer = new Timer(true);
    }
}

