/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.taskManager;

import com.sun.jade.taskManager.Controller;
import com.sun.jade.taskManager.TaskManager;
import com.sun.jade.taskManager.TaskResultListener;
import com.sun.jade.taskManager.Taskable;

public class Task {
    private static TaskManager taskManager = TaskManager.getInstance();
    private int priority = 0;
    Taskable taskable;
    private Controller controller;
    private String name;
    private String user;
    private String description;
    private long maxDuration = Long.MAX_VALUE;

    public Task(Taskable taskable) {
        this(taskable, (Controller)null);
    }

    public Task(Taskable taskable, String string) {
        this(taskable, null, string);
    }

    public Task(Taskable taskable, Controller controller) {
        this(taskable, controller, null);
    }

    public Task(Taskable taskable, Controller controller, String string) {
        this.taskable = taskable;
        this.controller = controller;
        this.name = string;
    }

    public static int activeCount() {
        return taskManager.activeCount();
    }

    public static int activeCount(String string) {
        return taskManager.activeCount(string);
    }

    public static Task[] currentTasks() {
        return taskManager.currentTasks();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
        taskManager.evaluateTaskPosition(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public void start() {
        taskManager.start(this);
    }

    public boolean abort() {
        return taskManager.abort(this);
    }

    public long getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(long l) {
        this.maxDuration = l;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void addListener(TaskResultListener taskResultListener) {
        taskManager.addListener(taskResultListener);
    }

    public void removeListener(TaskResultListener taskResultListener) {
        taskManager.removeListener(taskResultListener);
    }

    public static Task[] enumerate() {
        return taskManager.enumerate();
    }

    public static Task[] enumerateByUser(String string) {
        return taskManager.enumerateByUser(string);
    }

    public static Task[] enumerate(Controller controller) {
        return taskManager.enumerateByController(controller);
    }
}

