/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.taskManager;

import com.sun.jade.taskManager.Controller;
import com.sun.jade.taskManager.Task;
import com.sun.jade.taskManager.TaskResult;
import com.sun.jade.taskManager.TaskResultListener;
import com.sun.jade.util.log.Report;
import java.util.Vector;

class TaskManager {
    private static TaskManager taskManager;
    private Object lock = new Object();
    private Vector queuedTasks = new Vector();
    private Vector runningTasks = new Vector();
    private Vector listeners = new Vector();

    private TaskManager() {
    }

    static TaskManager getInstance() {
        if (taskManager == null) {
            taskManager = new TaskManager();
        }
        return taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int activeCount() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.queuedTasks.size() + this.runningTasks.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int activeCount(String string) {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.queuedTasks.size()) {
                Task task = (Task)this.queuedTasks.get(n2);
                if (string != null && string.equals(task.getUser())) {
                    ++n;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.runningTasks.size()) {
                Task task = (Task)this.runningTasks.get(n3);
                if (string != null && string.equals(task.getUser())) {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int activeCount(Controller controller) {
        int n = 0;
        Object object = this.lock;
        synchronized (object) {
            int n2 = 0;
            while (n2 < this.queuedTasks.size()) {
                Task task = (Task)this.queuedTasks.get(n2);
                if (task.getController() == controller) {
                    ++n;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.runningTasks.size()) {
                Task task = (Task)this.runningTasks.get(n3);
                if (task.getController() == controller) {
                    ++n;
                }
                ++n3;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task[] currentTasks() {
        Object object = this.lock;
        synchronized (object) {
            Object[] objectArray = new Task[this.runningTasks.size()];
            this.runningTasks.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(Task task) {
        Object object = this.lock;
        synchronized (object) {
            if (task.getController() == null || this.runningTasks.size() == 0) {
                new Thread(new RunnableTask(this, task)).start();
            } else {
                System.out.println("TASK IS QUEUED");
                this.insertTaskInQueue(task);
                this.activateNext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean abort(Task task) {
        Object object = this.lock;
        synchronized (object) {
            int n = 0;
            while (n < this.queuedTasks.size()) {
                Task task2 = (Task)this.queuedTasks.get(n);
                if (task == task2) {
                    this.queuedTasks.removeElementAt(n);
                    return true;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.runningTasks.size()) {
                Task task3 = (Task)this.runningTasks.get(n2);
                if (task == task3) {
                    return task3.taskable.abort();
                }
                ++n2;
            }
            return false;
        }
    }

    void addListener(TaskResultListener taskResultListener) {
        this.listeners.add(taskResultListener);
    }

    void removeListener(TaskResultListener taskResultListener) {
        this.listeners.remove(taskResultListener);
    }

    private void notifyListeners(TaskResult taskResult) {
        int n = 0;
        while (n < this.listeners.size()) {
            TaskResultListener taskResultListener = (TaskResultListener)this.listeners.get(n);
            try {
                taskResultListener.notify(taskResult);
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Error notifying listener");
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateNext(Controller controller) {
        Object object = this.lock;
        synchronized (object) {
            Task task;
            if (this.queuedTasks.size() == 0) {
                return;
            }
            boolean bl = false;
            int n = 0;
            while (n < this.runningTasks.size()) {
                task = (Task)this.runningTasks.get(n);
                if (controller != null && controller == task.getController()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                task = (Task)this.queuedTasks.remove(0);
                new Thread(new RunnableTask(this, task)).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateNext() {
        Object object = this.lock;
        synchronized (object) {
            Controller[] controllerArray = Controller.enumerate();
            if (controllerArray != null) {
                int n = 0;
                while (n < controllerArray.length) {
                    this.activateNext(controllerArray[n]);
                    ++n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void evaluateTaskPosition(Task task) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = 0;
            while (n < this.queuedTasks.size()) {
                Task task2 = (Task)this.queuedTasks.get(n);
                if (task == task2) {
                    this.queuedTasks.removeElementAt(n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.insertTaskInQueue(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertTaskInQueue(Task task) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = task.getPriority();
            int n2 = 0;
            while (n2 < this.queuedTasks.size()) {
                Task task2 = (Task)this.queuedTasks.get(n2);
                if (n > task2.getPriority()) {
                    this.queuedTasks.insertElementAt(task, n2);
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.queuedTasks.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task[] enumerate() {
        Object object = this.lock;
        synchronized (object) {
            Vector vector = new Vector(this.queuedTasks.size() + this.runningTasks.size());
            vector.addAll(this.queuedTasks);
            vector.addAll(this.runningTasks);
            Object[] objectArray = new Task[vector.size()];
            vector.copyInto(objectArray);
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task[] enumerateByUser(String string) {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < this.queuedTasks.size()) {
                Task task = (Task)this.queuedTasks.get(n);
                if (string != null && string.equals(task.getUser())) {
                    vector.add(task);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.runningTasks.size()) {
                object2 = (Task)this.runningTasks.get(n2);
                if (string != null && string.equals(((Task)object2).getUser())) {
                    vector.add(object2);
                }
                ++n2;
            }
            object2 = new Task[vector.size()];
            vector.copyInto((Object[])object2);
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task[] enumerateByController(Controller controller) {
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < this.queuedTasks.size()) {
                Task task = (Task)this.queuedTasks.get(n);
                if (controller == task.getController()) {
                    vector.add(task);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.runningTasks.size()) {
                object2 = (Task)this.runningTasks.get(n2);
                if (controller == ((Task)object2).getController()) {
                    vector.add(object2);
                }
                ++n2;
            }
            object2 = new Task[vector.size()];
            vector.copyInto((Object[])object2);
            Object object3 = object2;
            return object3;
        }
    }

    private class RunnableTask
    implements Runnable {
        private TaskManager taskManager;
        private Task task;
        private long startTime = System.currentTimeMillis();

        RunnableTask(TaskManager taskManager2, Task task) {
            this.taskManager = taskManager2;
            this.task = task;
            TaskManager.this.runningTasks.add(task);
        }

        public void run() {
            long l;
            System.out.println("TASK MANAGER RUN");
            while ((l = System.currentTimeMillis() - this.startTime) <= this.task.getMaxDuration()) {
                boolean bl = this.task.taskable.run();
                TaskResult taskResult = this.task.taskable.getResult();
                if (bl) {
                    this.taskManager.notifyListeners(taskResult);
                }
                if (!taskResult.isComplete()) continue;
            }
            TaskManager.this.runningTasks.remove(this.task);
            this.taskManager.activateNext();
        }
    }
}

