/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.diags.monitor.model;

import com.sun.jade.apps.diags.exec.DiagnosticTestService;
import com.sun.jade.apps.diags.lib.DiagnosticResultEvent;
import com.sun.jade.apps.diags.lib.DiagnosticResultListener;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.ui.diags.TestServiceFinder;
import com.sun.jade.ui.diags.monitor.model.TestEvent;
import com.sun.jade.ui.diags.monitor.model.TestListener;
import com.sun.jade.ui.util.UserID;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class MonitorModel
implements DiagnosticResultListener {
    private static Hashtable controllers = new Hashtable();
    private Vector listeners = new Vector();

    private MonitorModel(String string, String string2, Locale locale) throws RemoteException {
        this.init(string, string2, locale);
    }

    private void init(String string, String string2, Locale locale) throws RemoteException {
        if (!InstallerServiceFinder.isStandAlone()) {
            UnicastRemoteObject.exportObject(this);
        }
        DiagnosticTestService diagnosticTestService = TestServiceFinder.get(string);
        diagnosticTestService.openSession(string2, this, locale);
    }

    public static synchronized MonitorModel get(String string) throws RemoteException {
        return MonitorModel.get(string, UserID.get());
    }

    public static synchronized MonitorModel get(String string, String string2) throws RemoteException {
        return MonitorModel.get(string, string2, Locale.getDefault());
    }

    public static synchronized MonitorModel get(String string, String string2, Locale locale) throws RemoteException {
        Hashtable hashtable = (Hashtable)controllers.get(string);
        if (hashtable != null) {
            MonitorModel monitorModel = (MonitorModel)hashtable.get(string2);
            if (monitorModel != null) {
                return monitorModel;
            }
            MonitorModel monitorModel2 = new MonitorModel(string, string2, locale);
            hashtable.put(string2, monitorModel2);
            return monitorModel2;
        }
        MonitorModel monitorModel = new MonitorModel(string, string2, locale);
        Hashtable<String, MonitorModel> hashtable2 = new Hashtable<String, MonitorModel>();
        hashtable2.put(string2, monitorModel);
        controllers.put(string, hashtable2);
        return monitorModel;
    }

    public void notify(DiagnosticResultEvent diagnosticResultEvent) {
        DiagnosticResult diagnosticResult = diagnosticResultEvent.getResult();
        String string = diagnosticResultEvent.getuserId();
        TestEvent testEvent = new TestEvent(null, null, string, diagnosticResult, -1);
        ReferenceForMSE referenceForMSE = diagnosticResult.getMse();
        if (referenceForMSE != null) {
            testEvent.setMSEName(referenceForMSE.getCreationClassName() + "/" + referenceForMSE.getKeyValue());
        }
        int n = 0;
        while (n < this.listeners.size()) {
            TestListener testListener = (TestListener)this.listeners.elementAt(n);
            testListener.notify(testEvent);
            ++n;
        }
    }

    public void addTestEventListener(TestListener testListener) {
        this.listeners.add(testListener);
    }

    public void removeTestEventListener(TestListener testListener) {
        this.listeners.remove(testListener);
    }
}

