/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.login;

import com.iplanet.sso.SSOTokenManager;
import com.sun.jade.ui.login.Constants;
import com.sun.jade.ui.login.User;
import com.sun.jade.util.log.Report;
import com.sun.management.services.authentication.ConsoleCallbackHandler;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.SessionRepository;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.management.services.authentication.UserRolePrincipal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserChecker {
    private UserChecker() {
    }

    public static User isValidUser(HttpServletRequest httpServletRequest, String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        User user = null;
        HttpSession httpSession = httpServletRequest.getSession();
        try {
            String string3 = InetAddress.getLocalHost().getHostName();
            PasswordCredential passwordCredential = new PasswordCredential(string2);
            UserDataObject userDataObject = new UserDataObject();
            userDataObject.setHost(string3);
            userDataObject.setUser(string);
            userDataObject.setUserCredential(passwordCredential);
            userDataObject.setRole("no_role");
            httpSession.setAttribute("userobject", (Object)userDataObject);
            httpSession.setAttribute("clientconv", (Object)"data_entry_complete");
            ConsoleCallbackHandler consoleCallbackHandler = new ConsoleCallbackHandler(httpSession, httpServletRequest.getLocale());
            LoginContext loginContext = new LoginContext("ConsoleLogin", (CallbackHandler)consoleCallbackHandler);
            loginContext.login();
            user = new User();
            user.setPassword(string2);
            user.setUsername(string);
            String[] stringArray = userDataObject.getRolelist();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null && stringArray.length != 0) {
                int n = 0;
                while (n < stringArray.length) {
                    if (UserChecker.isStorADERole(stringArray[n])) {
                        arrayList.add(stringArray[n]);
                    }
                    ++n;
                }
                String[] stringArray2 = new String[arrayList.size()];
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    stringArray2[n2] = (String)arrayList.get(n2);
                    ++n2;
                }
                user.setAllRoles(stringArray2);
                if (stringArray2.length == 1) {
                    user.setCurrentRole(stringArray2[0]);
                }
            }
        }
        catch (LoginException loginException) {
            Report.trace.log("log in failed for user: " + string);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log("log in failed for unknown host");
        }
        return user;
    }

    public static User isValidUser(HttpServletRequest httpServletRequest, String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        User user = null;
        HttpSession httpSession = httpServletRequest.getSession();
        try {
            String string4 = InetAddress.getLocalHost().getHostName();
            PasswordCredential passwordCredential = new PasswordCredential(string2);
            UserDataObject userDataObject = new UserDataObject();
            userDataObject.setHost(string4);
            userDataObject.setUser(string);
            userDataObject.setUserCredential(passwordCredential);
            userDataObject.setRole("no_role");
            httpSession.setAttribute("userobject", (Object)userDataObject);
            httpSession.setAttribute("clientconv", (Object)"data_entry_complete");
            ConsoleCallbackHandler consoleCallbackHandler = new ConsoleCallbackHandler(httpSession, httpServletRequest.getLocale());
            LoginContext loginContext = new LoginContext("ConsoleLogin", (CallbackHandler)consoleCallbackHandler);
            loginContext.login();
            String[] stringArray = userDataObject.getRolelist();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null && stringArray.length != 0) {
                int n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n] != null && UserChecker.isStorADERole(stringArray[n])) {
                        arrayList.add(stringArray[n]);
                    }
                    ++n;
                }
                String[] stringArray2 = new String[arrayList.size()];
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    stringArray2[n2] = (String)arrayList.get(n2);
                    ++n2;
                }
                boolean bl = false;
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (string3.equals(stringArray2[n3])) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    user = new User();
                    user.setPassword(string2);
                    user.setUsername(string);
                    user.setAllRoles(stringArray2);
                    user.setCurrentRole(string3);
                }
            }
        }
        catch (LoginException loginException) {
            loginException.printStackTrace();
            Report.error.log("log in failed for user: " + string);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log("log in failed for unknown host");
        }
        return user;
    }

    public static User getUser(HttpServletRequest httpServletRequest) {
        UserRolePrincipal userRolePrincipal;
        Object object;
        Object object2;
        try {
            object2 = SSOTokenManager.getInstance();
            object = object2.createSSOToken(httpServletRequest);
            userRolePrincipal = (UserRolePrincipal)object.getPrincipal();
        }
        catch (Exception exception) {
            return null;
        }
        if (userRolePrincipal == null) {
            return null;
        }
        object2 = new User();
        object = userRolePrincipal.getRoleName();
        String string = userRolePrincipal.getName();
        if (string == null) {
            string = "nobody";
        }
        ((User)object2).setUsername(string);
        if (object != null) {
            ((User)object2).setCurrentRole((String)object);
        }
        return object2;
    }

    public static boolean removeUserSession(HttpServletRequest httpServletRequest) {
        try {
            HttpSession httpSession = httpServletRequest.getSession(false);
            SessionRepository.removeSession((HttpSession)httpSession);
            return true;
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"remove session in lockhart ");
            return false;
        }
    }

    private static boolean isStorADERole(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < Constants.STORADE_ROLES.length) {
            if (string.equals(Constants.STORADE_ROLES[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        UserChecker.isValidUser(null, "admin", "admin");
    }
}

