/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.notification;

import com.sun.jade.ui.notification.EmailAdditionForm;
import com.sun.jade.ui.notification.EmailUtilities;
import com.sun.jade.ui.notification.TopicAnalyzer;
import com.sun.jade.util.jini.BaseServiceFinder;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.notification.CriteriaParser;
import com.sun.netstorage.mgmt.service.notification.ContractSpecification;
import com.sun.netstorage.mgmt.service.notification.ContractSpecificationException;
import com.sun.netstorage.mgmt.service.notification.NotifierSpecification;
import com.sun.netstorage.mgmt.service.notification.SelectorSpecification;
import com.sun.netstorage.mgmt.service.notification.email.EmailNotifierSpecification;
import com.sun.netstorage.mgmt.service.nsm.notification.domestic.NotificationService;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class EmailAdditionAction
extends Action {
    private static final String topicResource = "com.sun.jade.event.resources.EmailTopics";

    public ActionForward perform(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Locale locale = this.getLocale(httpServletRequest);
        String string = httpServletRequest.getParameter("submitControl");
        String string2 = ((EmailAdditionForm)actionForm).getEmailAddress();
        String string3 = "";
        if (string != null) {
            if (string.equals("add")) {
                string3 = this.addContract(actionForm, locale) ? "?action=add&notificationId=" + URLEncoder.encode(string2) : "?action=errorAdd";
            } else if (string.equals("delete")) {
                string3 = this.deleteContract(actionForm) ? "?action=delete&notificationId=" + URLEncoder.encode(string2) : "?action=errorDelete";
            } else if (string.equals("update")) {
                string3 = this.modifyContract(actionForm, locale) ? "?action=update&notificationId=" + URLEncoder.encode(string2) : "?action=errorUpdate";
            }
        }
        String string4 = "/jsp/emailMaintenance.jsp" + string3;
        return new ActionForward(string4, true);
    }

    private boolean deleteContract(ActionForm actionForm) {
        String string = ((EmailAdditionForm)actionForm).getId();
        NotificationService notificationService = BaseServiceFinder.getNotificationService();
        if (notificationService != null) {
            try {
                long l = Long.parseLong(string);
                notificationService.removeContract(l, true);
                return true;
            }
            catch (Exception exception) {
                Report.error.log(exception, (Object)"Error while removing a contract");
            }
        }
        return false;
    }

    private boolean addContract(ActionForm actionForm, Locale locale) {
        NotificationService notificationService = BaseServiceFinder.getNotificationService();
        if (notificationService != null) {
            try {
                notificationService.addContract(this.getContract(actionForm, locale));
                return true;
            }
            catch (ContractSpecificationException contractSpecificationException) {
                Report.error.log(contractSpecificationException, (Object)"Error while adding a contract");
            }
        }
        return false;
    }

    private boolean modifyContract(ActionForm actionForm, Locale locale) {
        boolean bl = this.deleteContract(actionForm);
        if (!bl) {
            return bl;
        }
        bl = this.addContract(actionForm, locale);
        return bl;
    }

    private ContractSpecification getContract(ActionForm actionForm, Locale locale) {
        NotificationService notificationService = BaseServiceFinder.getNotificationService();
        if (notificationService == null) {
            return null;
        }
        EmailNotifierSpecification emailNotifierSpecification = new EmailNotifierSpecification();
        String string = ((EmailAdditionForm)actionForm).getEmailAddress();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        emailNotifierSpecification.setFrom(EmailUtilities.getFromField());
        emailNotifierSpecification.setTo(stringArray);
        emailNotifierSpecification.setLocale(locale);
        String string2 = ((EmailAdditionForm)actionForm).getServiceType();
        if ("Pager".equals(string2)) {
            emailNotifierSpecification.setIsPager("yes");
        } else {
            emailNotifierSpecification.setIsPager("no");
        }
        emailNotifierSpecification.setEmailFormatter("com.sun.jade.services.notification.email.StorADEEmailFormatter");
        SelectorSpecification selectorSpecification = new SelectorSpecification();
        String string3 = this.getCriteriaString(actionForm);
        selectorSpecification.setCriteria(string3);
        String[] stringArray2 = ((EmailAdditionForm)actionForm).getTopics();
        stringArray2 = TopicAnalyzer.expand(stringArray2, topicResource);
        selectorSpecification.setTopics(stringArray2);
        ContractSpecification contractSpecification = new ContractSpecification();
        String string4 = ((EmailAdditionForm)actionForm).getId();
        try {
            long l = Long.parseLong(string4);
            contractSpecification.setID(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        contractSpecification.setDescription("Email Notification Contract");
        contractSpecification.setNotifierSpecification((NotifierSpecification)emailNotifierSpecification);
        contractSpecification.setSelectorSpecification(selectorSpecification);
        return contractSpecification;
    }

    private String getCriteriaString(ActionForm actionForm) {
        String[] stringArray = ((EmailAdditionForm)actionForm).getDevices();
        String string = ((EmailAdditionForm)actionForm).getSeverity();
        String string2 = "";
        if (stringArray != null && !"all".equals(stringArray[0])) {
            string2 = "Subject LIKE  .*" + stringArray[0] + ".* ";
        }
        if (string != null && !"all".equals(string)) {
            String string3 = (String)CriteriaParser.SEVERITY_MAP.get(string);
            if (string3 == null) {
                Report.error.log("Cannot find corresponding value for severity: " + string);
            } else {
                if (!"".equals(string2)) {
                    string2 = string2 + " AND ";
                }
                string2 = string2 + string3;
            }
        }
        return string2;
    }

    private void viewOutput(ActionForm actionForm) {
        System.out.println("Entry Info: ");
        System.out.println("\tService Type: " + ((EmailAdditionForm)actionForm).getServiceType());
        System.out.println("\tEmail Address: " + ((EmailAdditionForm)actionForm).getEmailAddress());
        System.out.println("\tDevices: ");
        String[] stringArray = ((EmailAdditionForm)actionForm).getDevices();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("\t\t" + stringArray[n]);
            ++n;
        }
        System.out.println("\tSeverity: " + ((EmailAdditionForm)actionForm).getSeverity());
        String[] stringArray2 = ((EmailAdditionForm)actionForm).getTopics();
        System.out.println("\tEvents: ");
        int n2 = 0;
        while (n2 < stringArray2.length) {
            System.out.println("\t\t" + stringArray2[n2]);
            ++n2;
        }
    }
}

