/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.notification;

import com.sun.jade.ui.notification.EmailTestForm;
import com.sun.jade.ui.notification.EmailUtilities;
import com.sun.jade.ui.util.LocaleToCharsetMap;
import com.sun.jade.ui.util.MessageLocalizer;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class EmailTestAction
extends Action {
    private static final int ERROR_1 = 1;
    private static final int ERROR_2 = 2;

    public ActionForward perform(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        ActionErrors actionErrors = new ActionErrors();
        try {
            int n = this.sendEmail(actionForm, httpServletRequest, actionErrors);
            PrintWriter printWriter = httpServletResponse.getWriter();
            String string = ((EmailTestForm)actionForm).getSMTPServer();
            actionForm.reset(actionMapping, httpServletRequest);
            String string2 = "jsp/emailTest.jsp?SMTPServer=" + URLEncoder.encode(string) + "&status=" + n;
            String string3 = "<script language=\"JavaScript\"> window.location='" + string2 + "'</script>";
            printWriter.println(string3);
        }
        catch (Exception exception) {
            actionErrors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error"));
        }
        if (!actionErrors.empty()) {
            this.saveErrors(httpServletRequest, actionErrors);
            String string = "error";
            httpServletResponse.getWriter().println(string);
            return null;
        }
        return null;
    }

    private int sendEmail(ActionForm actionForm, HttpServletRequest httpServletRequest, ActionErrors actionErrors) {
        Locale locale = httpServletRequest.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string = httpServletRequest.getParameter("charset");
        String string2 = "com.sun.jade.ui.resources.Internal";
        Localizer localizer = new Localizer(string2);
        if (locale != null) {
            localizer.setLocale(locale);
        }
        MessageLocalizer messageLocalizer = new MessageLocalizer(localizer);
        String string3 = "Unknown Host";
        try {
            string3 = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray = new String[]{string3};
        String string4 = messageLocalizer.getLocalizedMessage("message.testEmail", stringArray);
        String string5 = EmailUtilities.getFromField();
        String string6 = ((EmailTestForm)actionForm).getEmailAddress();
        String string7 = ((EmailTestForm)actionForm).getMessage();
        if (string != null) {
            try {
                string7 = new String(string7.getBytes("8859_1"), string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Report.error.log(unsupportedEncodingException, (Object)"Invalid encoding");
            }
        }
        if (string7.trim().equals("")) {
            string7 = "Test Message";
        }
        Properties properties = System.getProperties();
        String string8 = ((EmailTestForm)actionForm).getSMTPServer();
        properties.put("mail.smtp.host", string8);
        try {
            Session session = Session.getDefaultInstance((Properties)properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(string5));
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string6, (boolean)false));
            mimeMessage.setSubject(MimeUtility.encodeText((String)string4, (String)LocaleToCharsetMap.getCharsetEmail(locale), null));
            mimeMessage.setText(string7, LocaleToCharsetMap.getCharsetEmail(locale));
            Transport.send((Message)mimeMessage);
        }
        catch (SendFailedException sendFailedException) {
            actionErrors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error, cannot send email"));
            Report.error.log(sendFailedException, (Object)"SMTP Error");
            Exception exception = sendFailedException.getNextException();
            if (exception instanceof SendFailedException) {
                return 2;
            }
            if (exception instanceof MessagingException) {
                return 1;
            }
            return 2;
        }
        catch (MessagingException messagingException) {
            actionErrors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error, cannot send email"));
            Report.error.log(messagingException, (Object)"SMTP Error");
            return 1;
        }
        catch (Exception exception) {
            actionErrors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error, cannot send email"));
            Report.error.log(exception, (Object)"SMTP Error");
            return 3;
        }
        return 0;
    }

    private void viewOutput(ActionForm actionForm) {
        System.out.println("Email Test Info: ");
        System.out.println("\tEmail Address: " + ((EmailTestForm)actionForm).getSMTPServer());
        System.out.println("\tEmail Address: " + ((EmailTestForm)actionForm).getEmailAddress());
        System.out.println("\tMessage: " + ((EmailTestForm)actionForm).getMessage());
    }
}

