/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.topology.tree;

import com.sun.jade.ui.topology.tree.TreeNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class DefaultTreeNode
implements Serializable,
TreeNode {
    protected Object userObject;
    protected TreeNode parent;
    protected Vector children;

    public DefaultTreeNode() {
    }

    public DefaultTreeNode(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(DefaultTreeNode defaultTreeNode) {
        this.parent = defaultTreeNode;
    }

    public Iterator getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.iterator();
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public boolean isNodeAncestor(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        TreeNode treeNode2 = this;
        do {
            if (treeNode2 != treeNode) continue;
            return true;
        } while ((treeNode2 = treeNode2.getParent()) != null);
        return false;
    }

    public void insert(DefaultTreeNode defaultTreeNode, int n) {
        if (defaultTreeNode == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(defaultTreeNode)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        DefaultTreeNode defaultTreeNode2 = (DefaultTreeNode)defaultTreeNode.getParent();
        if (defaultTreeNode2 != null) {
            defaultTreeNode2.remove(defaultTreeNode);
        }
        defaultTreeNode.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(defaultTreeNode, n);
    }

    public void add(DefaultTreeNode defaultTreeNode) {
        this.insert(defaultTreeNode, this.getChildCount());
    }

    public void remove(DefaultTreeNode defaultTreeNode) {
        if (defaultTreeNode == null) {
            throw new IllegalArgumentException("the child is null");
        }
        boolean bl = false;
        int n = 0;
        while (n < this.children.size()) {
            TreeNode treeNode = (TreeNode)this.children.elementAt(n);
            if (treeNode == defaultTreeNode) {
                bl = true;
                this.children.removeElementAt(n);
                break;
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException("the child is not a child of this node");
        }
        defaultTreeNode.setParent(null);
    }
}

