/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.ui.util;

import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ParameterType;
import com.sun.jade.ui.util.NotInRangeException;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import java.math.BigInteger;

public class Converter {
    private static void compare(Object object, Object[] objectArray) throws NotInRangeException {
        if (objectArray == null || objectArray.length < 2) {
            return;
        }
        if (object instanceof UnsignedInt8) {
            if (objectArray[0] instanceof UnsignedInt8) {
                short s = ((UnsignedInt8)object).shortValue();
                short s2 = ((UnsignedInt8)objectArray[0]).shortValue();
                short s3 = ((UnsignedInt8)objectArray[1]).shortValue();
                if (s < s2 || s > s3) {
                    throw new NotInRangeException(object, objectArray[0], objectArray[1]);
                }
            } else {
                Converter.compare64(object, objectArray);
            }
        } else if (object instanceof UnsignedInt16) {
            if (objectArray[0] instanceof UnsignedInt16) {
                int n = ((UnsignedInt16)object).intValue();
                int n2 = ((UnsignedInt16)objectArray[0]).intValue();
                int n3 = ((UnsignedInt16)objectArray[1]).intValue();
                if (n < n2 || n > n3) {
                    throw new NotInRangeException(object, objectArray[0], objectArray[1]);
                }
            } else {
                Converter.compare64(object, objectArray);
            }
        } else if (object instanceof UnsignedInt32) {
            if (objectArray[0] instanceof UnsignedInt32) {
                long l = ((UnsignedInt32)object).longValue();
                long l2 = ((UnsignedInt32)objectArray[0]).longValue();
                long l3 = ((UnsignedInt32)objectArray[1]).longValue();
                if (l < l2 || l > l3) {
                    throw new NotInRangeException(object, objectArray[0], objectArray[1]);
                }
            } else {
                Converter.compare64(object, objectArray);
            }
        } else if (!(object instanceof UnsignedInt64) || objectArray[0] instanceof UnsignedInt64) {
            // empty if block
        }
    }

    private static void compare64(Object object, Object[] objectArray) throws NotInRangeException {
        UnsignedInt64 unsignedInt64 = new UnsignedInt64(object.toString());
        UnsignedInt64 unsignedInt642 = new UnsignedInt64(objectArray[0].toString());
        UnsignedInt64 unsignedInt643 = new UnsignedInt64(objectArray[1].toString());
        if (unsignedInt64.compareTo((BigInteger)unsignedInt642) == -1 || unsignedInt64.compareTo((BigInteger)unsignedInt643) == 1) {
            throw new NotInRangeException(object, objectArray[0], objectArray[1]);
        }
    }

    public static Object getValue(TestParameter testParameter, String string) throws NotInRangeException {
        Object object = testParameter.getDefaultValue();
        Object object2 = null;
        if (object instanceof String) {
            object2 = string;
        } else if (object instanceof Integer) {
            int[] nArray;
            int n = 10;
            if (testParameter.getParameterType().equals(ParameterType.HEX_NUMBER)) {
                n = 16;
            } else if (testParameter.getParameterType().equals(ParameterType.OCTAL_NUMBER)) {
                n = 8;
            }
            int n2 = Integer.parseInt(string, n);
            object2 = new Integer(n2);
            Object[] objectArray = testParameter.getValidValues();
            if (objectArray != null && (n2 < (nArray = new int[]{(Integer)objectArray[0], (Integer)objectArray[1]})[0] || n2 > nArray[1])) {
                throw new NotInRangeException(object2, objectArray[0], objectArray[1]);
            }
        } else if (object instanceof Float) {
            float[] fArray;
            float f = Float.parseFloat(string);
            object2 = new Float(f);
            Object[] objectArray = testParameter.getValidValues();
            if (objectArray != null && (f < (fArray = new float[]{((Float)objectArray[0]).floatValue(), ((Float)objectArray[1]).floatValue()})[0] || f > fArray[1])) {
                throw new NotInRangeException(object2, objectArray[0], objectArray[1]);
            }
        } else if (object instanceof UnsignedInt8) {
            UnsignedInt8 unsignedInt8 = new UnsignedInt8(string);
            Object[] objectArray = testParameter.getValidValues();
            Converter.compare(unsignedInt8, objectArray);
            object2 = new UnsignedInt8(unsignedInt8.shortValue());
        } else if (object instanceof UnsignedInt16) {
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(string);
            Object[] objectArray = testParameter.getValidValues();
            Converter.compare(unsignedInt16, objectArray);
            object2 = new UnsignedInt16(unsignedInt16.intValue());
        } else if (object instanceof UnsignedInt32) {
            UnsignedInt32 unsignedInt32 = new UnsignedInt32(string);
            Object[] objectArray = testParameter.getValidValues();
            Converter.compare(unsignedInt32, objectArray);
            object2 = new UnsignedInt32(unsignedInt32.longValue());
        } else if (object instanceof UnsignedInt64) {
            UnsignedInt64 unsignedInt64 = new UnsignedInt64(string);
            Object[] objectArray = testParameter.getValidValues();
            Converter.compare(unsignedInt64, objectArray);
            object2 = new UnsignedInt64(unsignedInt64.toString());
        } else if (object instanceof Boolean) {
            object2 = string.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        return object2;
    }
}

