/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util;

import com.sun.jade.util.ConfigProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class Config {
    private Properties prop = new Properties();
    private List config = new ArrayList();
    private static final String sccs_id = "@(#)Config.java\t1.3 01/14/02 SMI";

    public Properties getTopLevelProperties() {
        return this.prop;
    }

    public Collection getConfigProperties() {
        return this.config;
    }

    public void addConfigProperties(ConfigProperties configProperties) {
        this.config.add(configProperties);
    }

    public void load(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.load(bufferedReader);
    }

    public void load(BufferedReader bufferedReader) throws IOException {
        Properties properties = this.prop;
        while (true) {
            char c;
            String string;
            if ((string = bufferedReader.readLine()) == null) {
                if (properties == null || properties == this.prop) break;
                this.config.add(properties);
                break;
            }
            if ((string = string.trim()).length() == 0 || string.startsWith("#") || (c = string.charAt(0)) == '\n') continue;
            if (c == '[') {
                int n;
                if (properties != null && properties != this.prop) {
                    this.config.add(properties);
                    properties = null;
                }
                if ((n = string.indexOf(93)) <= 1) continue;
                properties = new ConfigProperties(string.substring(1, n));
                continue;
            }
            if (properties == null) continue;
            String string2 = string;
            String string3 = "";
            int n = string.indexOf("=");
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            properties.setProperty(string2, string3);
        }
    }

    public void store(OutputStream outputStream) throws IOException {
        this.list(new PrintWriter(outputStream));
    }

    public void list(PrintWriter printWriter) {
        this.list(this.prop, printWriter);
        int n = 0;
        while (n < this.config.size()) {
            ConfigProperties configProperties = (ConfigProperties)this.config.get(n);
            printWriter.println();
            printWriter.println("[" + configProperties.getName() + "]");
            this.list(configProperties, printWriter);
            ++n;
        }
        printWriter.flush();
    }

    private void list(Properties properties, PrintWriter printWriter) {
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            printWriter.println(object + "=" + object2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 1) {
                System.err.println("Usage Config <file>");
                System.exit(-1);
            }
            Config config = new Config();
            config.load(new FileInputStream(new File(stringArray[0])));
            config.list(new PrintWriter(System.out));
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

