/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util;

import java.util.Locale;
import java.util.ResourceBundle;

public abstract class LocalizableItem {
    private Locale locale;
    private String name;
    private Object value;
    protected boolean doLocalize;
    protected String resource;

    public LocalizableItem(Locale locale, String string, Object object) {
        this.name = string;
        this.value = object;
        this.doLocalize = true;
    }

    public LocalizableItem(Locale locale, String string, Object object, boolean bl) {
        this.name = string;
        this.value = object;
        this.doLocalize = bl;
    }

    private String getOriginalName() {
        return this.name;
    }

    private String getLocalizedName() {
        String string;
        try {
            ResourceBundle resourceBundle = this.locale == null ? ResourceBundle.getBundle(this.resource) : ResourceBundle.getBundle(this.resource, this.locale);
            string = resourceBundle.getString(this.name);
        }
        catch (Exception exception) {
            string = this.name;
        }
        return string;
    }

    public String getName() {
        String string = null;
        string = this.doLocalize ? this.getLocalizedName() : this.getOriginalName();
        return string;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValueAsHTMLString() {
        String string = "&#20";
        if (this.value != null && this.value.toString() != null) {
            string = this.value.toString();
            boolean bl = true;
            int n = 0;
            while (n < string.length()) {
                if (string.charAt(n) != ' ') {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                return "&#20";
            }
        }
        return string;
    }
}

