/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.cim.bean.NWS_Agent;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.UnsignedInt16;

public final class StoradeEnvironment {
    public static final String DESCRIPTION = "Sun StorEdge Diagnostic Expert";
    public static final String CAPTION = "SSDE";
    public static final String PROGRAM = "Diagnostic Expert";
    public static final String COMPANY = "Sun Microsystems Inc.";
    public static final String BRAND = "StorEdge";
    public static String VERSION = "1.2";
    public static String BUILD = "Development";
    private static String hostId;
    private static CIMDateTime installDate;
    public static final int STATE_STARTING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPING = 2;
    private static int state;
    public static final String sccs_id = "@(#)StoradeEnvironment.java\t1.22 03/28/03 SMI";

    public static String getInstallDirName() {
        return System.getProperty("storade.home");
    }

    public static String getOutputDirName() {
        return System.getProperty("storade.output");
    }

    public static DeviceConfig getDeviceConfig() {
        return DeviceConfig.getSystemConfig();
    }

    public static NWS_Agent getAgentBean() {
        NWS_Agent nWS_Agent = new NWS_Agent();
        nWS_Agent.setRevisionLevel(VERSION);
        nWS_Agent.setResidentHostID(StoradeEnvironment.getHostID());
        nWS_Agent.setName(DESCRIPTION);
        nWS_Agent.setVersion(StoradeEnvironment.getVersion());
        nWS_Agent.setSoftwareElementState(new UnsignedInt16(3));
        nWS_Agent.setSoftwareElementID(StoradeEnvironment.getVersion() + " " + StoradeEnvironment.getHostID());
        nWS_Agent.setTargetOperatingSystem(new UnsignedInt16(29));
        nWS_Agent.setManufacturer(COMPANY);
        nWS_Agent.setBuildNumber(BUILD);
        nWS_Agent.setSerialNumber("1");
        nWS_Agent.setCodeSet(BRAND);
        nWS_Agent.setIdentificationCode(CAPTION);
        nWS_Agent.setLanguageEdition("en");
        nWS_Agent.setInstallDate(StoradeEnvironment.getInstallDate());
        nWS_Agent.setStatus("OK");
        nWS_Agent.setCaption("SSDE " + VERSION);
        nWS_Agent.setDescription(StoradeEnvironment.getDescription());
        return nWS_Agent;
    }

    public static String getDescription() {
        return DESCRIPTION + VERSION + "." + BUILD;
    }

    public static String getVersion() {
        return "Diagnostic Expert " + VERSION + "." + BUILD;
    }

    public static String getHostID() {
        if (hostId != null) {
            return hostId;
        }
        String string = "Unknown";
        try {
            CommandExec commandExec = new CommandExec("hostid");
            commandExec.exec();
            if (commandExec.getReturnValue() == 0 && (string = commandExec.getStandardOutput().trim()).length() == 0) {
                string = "Unknown";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static CIMDateTime getInstallDate() {
        if (installDate != null) {
            return installDate;
        }
        installDate = new CIMDateTime();
        return installDate;
    }

    public static void setState(int n) {
        state = n;
    }

    public static int getState() {
        return state;
    }

    private static void initVersion() throws Exception {
        int n;
        String string;
        CommandExec commandExec = new CommandExec("/bin/pkgparam SUNWsade VERSION");
        if (commandExec.run() == 0 && (string = commandExec.getStandardOutput().trim()).length() != 0 && (n = string.lastIndexOf(46)) > 0) {
            VERSION = string.substring(0, n);
            BUILD = string.substring(n + 1);
        }
    }

    static {
        state = 0;
        try {
            CommandExec commandExec = new CommandExec("/bin/pkgparam SUNWsade BASEDIR");
            if (commandExec.run() == 0) {
                String string;
                String string2 = commandExec.getStandardOutput();
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if ((string = StoradeEnvironment.getInstallDirName()) != null && string.equals(string2 + "/SUNWsade")) {
                    StoradeEnvironment.initVersion();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            System.out.println("Version=" + StoradeEnvironment.getVersion());
            System.out.println("Install Date=" + StoradeEnvironment.getInstallDate());
            System.out.println("Install Dir=" + StoradeEnvironment.getInstallDirName());
            System.out.println("Output Dir=" + StoradeEnvironment.getOutputDirName());
            System.out.println("Agent Bean=" + StoradeEnvironment.getAgentBean().toBeanXML());
            System.out.println("Host ID=" + StoradeEnvironment.getHostID());
        }
    }
}

