/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.xml;

import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTag {
    private static String INDENT = "  ";
    private String name;
    private HashMap attributes;
    private Collection contents;
    public static final String sccs_id = "@(#)XMLTag.java\t1.4 06/05/02 SMI";

    public XMLTag(String string) {
        this(string, null, null);
    }

    public XMLTag(String string, HashMap hashMap) {
        this(string, hashMap, null);
    }

    public XMLTag(String string, HashMap hashMap, Collection collection) {
        this.setName(string);
        this.setAttributes(hashMap);
        this.setContents(collection);
    }

    public void setAttributes(HashMap hashMap) {
        this.attributes = hashMap;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setContents(Collection collection) {
        this.contents = collection;
    }

    public Collection getContents() {
        return this.contents;
    }

    public void addContent(Object object) {
        if (this.contents == null) {
            this.contents = new Vector();
        }
        this.contents.add(object);
    }

    public String toString(String string) {
        String string2;
        Object object;
        StringBuffer stringBuffer = new StringBuffer(string + "<" + this.getName());
        if (this.attributes != null) {
            Iterator iterator = this.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                string2 = (String)this.attributes.get(object);
                if (string2 == null) {
                    stringBuffer.append(" " + (String)object);
                    continue;
                }
                stringBuffer.append(" " + (String)object + "=" + "\"" + string2 + "\"");
            }
        }
        stringBuffer.append(">");
        boolean bl = false;
        if (this.contents != null) {
            object = this.contents.iterator();
            while (object.hasNext()) {
                string2 = object.next();
                if (string2 != null && !(string2 instanceof XMLTag)) {
                    stringBuffer.append(string2.toString());
                    bl = true;
                    continue;
                }
                if (string2 instanceof XMLTag) {
                    stringBuffer.append("\n" + ((XMLTag)((Object)string2)).toString(string + INDENT));
                    continue;
                }
                stringBuffer.append("\n" + string + INDENT + "null");
            }
        }
        if (!bl) {
            stringBuffer.append("\n" + string);
        }
        stringBuffer.append("</" + this.getName() + ">");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public static XMLTag getTagFromString(String string) {
        return new XMLTagParser().parse(string);
    }

    private static class XMLTagParser
    extends DefaultHandler {
        private Vector stack = new Vector();
        private XMLTag root = null;

        private XMLTagParser() {
        }

        protected XMLTag parse(String string) {
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)this);
                return this.root;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endDocument() {
            XMLTagParser xMLTagParser = this;
            synchronized (xMLTagParser) {
                try {
                    this.notify();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void startDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            HashMap<String, String> hashMap = new HashMap<String, String>(attributes.getLength());
            int n = 0;
            while (n < attributes.getLength()) {
                hashMap.put(attributes.getQName(n), attributes.getValue(n));
                ++n;
            }
            XMLTag xMLTag = new XMLTag(string3, hashMap);
            XMLTag xMLTag2 = null;
            if (this.stack.size() > 0) {
                xMLTag2 = (XMLTag)this.stack.lastElement();
                xMLTag2.addContent(xMLTag);
            }
            this.stack.add(xMLTag);
            if (this.root == null) {
                this.root = xMLTag;
            }
        }

        public void endElement(String string, String string2, String string3) {
            this.stack.remove(this.stack.lastElement());
        }

        public void characters(char[] cArray, int n, int n2) {
            ((XMLTag)this.stack.lastElement()).addContent(new String(cArray, n, n2));
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
        }

        public void notationDecl(String string, String string2, String string3) {
        }

        public InputSource resolveEntity(String string, String string2) {
            return null;
        }

        public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        }

        public void warning(SAXParseException sAXParseException) {
        }
    }
}

