/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.debug;

import com.sun.jade.apps.command.DebugCommand;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;

public class MemoryCommand
implements DebugCommand {
    private static Vector leakv;
    public static final String sccs_id = "@(#)MemoryCommand.java\t1.3 11/18/02 SMI";

    public String getHelp() {
        return "Print memory usage of the webserver.";
    }

    public int execute(Properties properties, PrintWriter printWriter) throws IOException {
        String string = properties.getProperty("leak");
        if (string != null) {
            MemoryCommand.leakMemory(string);
        } else {
            string = properties.getProperty("free");
            if (string != null) {
                leakv = null;
            }
        }
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        long l2 = runtime.totalMemory();
        long l3 = l2 - l;
        printWriter.println("Used  Memory = " + MemoryCommand.toMegString(l3));
        printWriter.println("Free  Memory = " + MemoryCommand.toMegString(l));
        printWriter.println("Total Memory = " + MemoryCommand.toMegString(l2));
        printWriter.println("Max   Memory = " + MemoryCommand.toMegString(runtime.maxMemory()));
        return 0;
    }

    private static String toMegString(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 1000L;
        long l4 = l2 % 1000L;
        String string = "" + l4;
        if (l4 < 100L) {
            string = "0" + string;
        }
        if (l4 < 10L) {
            string = "0" + string;
        }
        return "" + l3 + " Meg";
    }

    private static void leakMemory(String string) {
        try {
            if (string == null) {
                return;
            }
            int n = Integer.parseInt(string);
            if (leakv == null) {
                leakv = new Vector();
            }
            byte[] byArray = new byte[n * 1024 * 1024];
            leakv.add(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

