/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.diags;

import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.ui.util.DeviceHelper;
import com.sun.jade.util.locale.Localizer;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Locale;

public class DiagnosticResultBean {
    private static final String resource = "com.sun.jade.ui.resources.Internal";
    private DateFormat df;
    private String user;
    private String node;
    private String test;
    private String startTime;
    private String endTime;
    private String updateTime;
    private String status;
    private String progress;
    private String key;
    private Locale locale;
    private String executionID;
    private boolean suite;
    private String suiteString;
    private DiagnosticResultBean[] diagnostics;

    public DiagnosticResultBean(String string, String string2, String string3, DiagnosticResult diagnosticResult, Locale locale, String string4) {
        this(string, string2, string3, diagnosticResult, locale);
        this.executionID = string4;
    }

    public DiagnosticResultBean(String string, String string2, String string3, DiagnosticResult diagnosticResult, Locale locale) {
        this.df = DateFormat.getDateTimeInstance(1, 1, locale);
        Localizer localizer = new Localizer(resource);
        if (locale != null) {
            localizer.setLocale(locale);
        }
        this.locale = locale;
        this.user = string;
        this.node = string2;
        this.test = string3;
        this.startTime = localizer.getString("na");
        this.endTime = localizer.getString("na");
        this.updateTime = localizer.getString("na");
        this.status = localizer.getString("na");
        this.progress = diagnosticResult.getPercentComplete() + "%";
        this.suite = diagnosticResult.getIsPackageValue();
        this.key = diagnosticResult.getElementKey().toString();
        this.suiteString = localizer.getString(new Boolean(this.suite).toString());
        if (diagnosticResult.getTestStateValueMap() != null) {
            this.status = diagnosticResult.getLocalizedTestState(locale);
        }
        if (diagnosticResult.getTestStartTime() != null) {
            this.startTime = this.df.format(diagnosticResult.getTestStartTime().getCalendar().getTime());
        }
        if (diagnosticResult.getTestCompletionTime() != null) {
            this.endTime = this.df.format(diagnosticResult.getTestCompletionTime().getCalendar().getTime());
        }
        if (diagnosticResult.getTimeStamp() != null) {
            this.updateTime = this.df.format(diagnosticResult.getTimeStamp().getCalendar().getTime());
        }
    }

    public DiagnosticResultBean(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, String string9, Locale locale) {
        Localizer localizer = new Localizer(resource);
        if (locale != null) {
            localizer.setLocale(locale);
        }
        this.locale = locale;
        this.user = string;
        this.node = string2;
        this.test = string3;
        this.startTime = string4;
        this.endTime = string5;
        this.updateTime = string6;
        this.status = string7;
        this.progress = string8;
        this.suite = bl;
        this.key = string9;
        this.suiteString = localizer.getString(new Boolean(bl).toString());
    }

    public String getUser() {
        return this.user;
    }

    public String getNode() {
        TopologyNode topologyNode = DeviceHelper.getNodeFromString(this.node, false);
        if (topologyNode == null) {
            return this.node;
        }
        MF mF = topologyNode.getMF();
        ReferenceForMSE referenceForMSE = topologyNode.getMSE();
        if (mF == null) {
            return this.node;
        }
        try {
            if (referenceForMSE == null) {
                return mF.getCaption().getLocalizedMessage(this.locale);
            }
            return mF.getCaption().getLocalizedMessage(this.locale) + " - " + referenceForMSE.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.node;
        }
    }

    public String getEncodedNode() {
        return URLEncoder.encode(this.getNode());
    }

    public String getTest() {
        return this.test;
    }

    public String getTestWithLink() {
        String string = "<a href='/jade/jsp/diagnosticTest2.jsp?elementKey=" + this.getEncodedKey() + "&testObjectName=" + this.getEncodedNode() + "'>" + this.getTest() + "</a>";
        return string;
    }

    public String getArchivedTestWithLink() {
        String string = "<a href='/jade/jsp/archivedDiagnosticTest.jsp?elementKey=" + URLEncoder.encode(this.executionID) + "'>" + this.getTest() + "</a>";
        return string;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getProgress() {
        return this.progress;
    }

    public boolean isSuite() {
        return this.suite;
    }

    public String getLocalizedSuite() {
        return this.suiteString;
    }

    public String getSuite() {
        if (this.suite) {
            return "<a href=\"/jade/jsp/suite.jsp?elementKey=" + this.getEncodedKey() + "\">true</a>";
        }
        return "false";
    }

    public String getKey() {
        return this.key;
    }

    public String getEncodedKey() {
        return URLEncoder.encode(this.key);
    }

    public DiagnosticResultBean[] getResultList() {
        return this.diagnostics;
    }

    public void setResultList(DiagnosticResultBean[] diagnosticResultBeanArray) {
        this.diagnostics = diagnosticResultBeanArray;
    }

    public String getExecutionID() {
        return this.executionID;
    }
}

