/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.diags;

import com.sun.jade.util.locale.Localizer;
import com.sun.jade.web.util.StringFormat;
import java.util.Locale;

public class DiagnosticTestBean {
    private static final String resource = "com.sun.jade.ui.resources.Internal";
    Localizer localizer;
    private String localizedName = null;
    private String name = "N/A";
    private String oidName;
    private String testMode = null;
    private String exclusive = null;
    private String interactive = null;
    private String destructive = null;
    private String risky = null;
    private String testPackage = null;
    private String deviceOidName;
    private int testValue = 0;
    private String testKey;
    private String creationClassName;
    private String keyName;
    private String keyValue;
    private Locale locale;
    private String backGround;

    private void init() {
        this.localizer = new Localizer(resource);
        if (this.locale != null) {
            this.localizer.setLocale(this.locale);
        }
        this.testMode = this.localizer.getString("On/off-line");
        this.exclusive = this.localizer.getString("No");
        this.interactive = this.localizer.getString("No");
        this.destructive = this.localizer.getString("No");
        this.risky = this.localizer.getString("No");
        this.testPackage = this.localizer.getString("No");
    }

    public DiagnosticTestBean(String string, String string2, Locale locale, String string3, String string4, String string5, String string6, int[] nArray) {
        this.name = string;
        this.localizedName = string2;
        this.locale = locale;
        this.oidName = string3;
        this.creationClassName = string4;
        this.keyName = string5;
        this.keyValue = string6;
        this.init();
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                switch (nArray[n]) {
                    case 2: {
                        this.exclusive = this.localizer.getString("Yes");
                        this.testValue += 2;
                        break;
                    }
                    case 3: {
                        this.interactive = this.localizer.getString("Yes");
                        this.testValue += 4;
                        break;
                    }
                    case 4: {
                        this.destructive = this.localizer.getString("Yes");
                        ++this.testValue;
                        break;
                    }
                    case 5: {
                        this.risky = this.localizer.getString("Yes");
                        this.testValue += 8;
                        break;
                    }
                    case 6: {
                        this.testPackage = this.localizer.getString("Yes");
                        this.testValue += 16;
                        break;
                    }
                    case 100: {
                        this.testMode = this.localizer.getString("On-line");
                        this.testValue += 32;
                        break;
                    }
                    case 101: {
                        this.testMode = this.localizer.getString("Off-line");
                        this.testValue += 64;
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 7: {
                        break;
                    }
                    default: {
                        System.out.println("Unknown Test Characteristic" + nArray[n]);
                    }
                }
                ++n;
            }
        }
    }

    public DiagnosticTestBean(String string) {
        this.name = string;
    }

    public String getName() {
        return this.getLocalizedName();
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public String getoidName() {
        return this.oidName;
    }

    public String getEncodedOidName() {
        return StringFormat.toURLString(this.oidName);
    }

    public String getMode() {
        if (this.testMode.trim().equals("")) {
            return "-";
        }
        return this.testMode;
    }

    public int getTestValue() {
        return this.testValue;
    }

    public String getExclusive() {
        return this.exclusive;
    }

    public String getInteractive() {
        return this.interactive;
    }

    public String getDestructive() {
        return this.destructive;
    }

    public String getRisky() {
        return this.risky;
    }

    public String getPackage() {
        return this.testPackage;
    }

    public String getEncodedName() {
        return StringFormat.toURLString(this.name);
    }

    public String getEncodedMode() {
        return StringFormat.toURLString(this.testMode);
    }

    public void setKey(String string) {
        this.testKey = StringFormat.toURLString(string);
    }

    public String getKey() {
        return this.testKey;
    }

    public String getEncodedCreationClassName() {
        return StringFormat.toURLString(this.creationClassName);
    }

    public String getEncodedKeyName() {
        return StringFormat.toURLString(this.keyName);
    }

    public String getEncodedKeyValue() {
        return StringFormat.toURLString(this.keyValue);
    }

    public String getDeviceOidName() {
        return this.deviceOidName;
    }

    public void setDeviceOidName(String string) {
        this.deviceOidName = string;
    }

    public void setBackGround(String string) {
        this.backGround = string;
    }

    public String getEncodedBackGround() {
        return StringFormat.toURLString(this.backGround);
    }

    public String getEncodedDeviceOidName() {
        return StringFormat.toURLString(this.deviceOidName);
    }

    public String getNameWithLink() {
        String string = "/jade/jsp/testSetup.jsp?OID=" + this.getEncodedDeviceOidName() + "&sampleOID=" + this.getEncodedOidName() + "&testName=" + this.getEncodedName() + "&creationClassName=" + this.getEncodedCreationClassName() + "&keyName=" + this.getEncodedKeyName() + "&keyValue=" + this.getEncodedKeyValue() + "&testMode=" + this.getEncodedMode();
        if (this.backGround != null) {
            string = string + "&backGround=" + this.getEncodedBackGround();
        }
        String string2 = "<a href='" + string + "'>" + this.getName() + "</a>";
        return string2;
    }

    public String getActionsWithLink() {
        String string = "/jade/jsp/testSetup.jsp?OID=" + this.getEncodedDeviceOidName() + "&sampleOID=" + this.getEncodedOidName() + "&testName=" + this.getEncodedName() + "&creationClassName=" + this.getEncodedCreationClassName() + "&keyName=" + this.getEncodedKeyName() + "&keyValue=" + this.getEncodedKeyValue() + "&testMode=" + this.getEncodedMode();
        if (this.backGround != null) {
            string = string + "&backGround=" + this.getEncodedBackGround();
        }
        String string2 = "[<a href='" + string + "'>" + this.localizer.getString("runTest") + "</a>]";
        return string2;
    }
}

