/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.notification;

import com.sun.jade.device.util.DevInfo;
import com.sun.jade.ui.notification.TopicAnalyzer;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class EmailContract {
    private static final String topicResource = "com.sun.jade.event.resources.EmailTopics";
    private static final String internalResource = "com.sun.jade.ui.resources.Internal";
    private long id;
    private String[] tos;
    private String[] topics;
    private String device;
    private Locale locale;
    private Localizer localizer = new Localizer("com.sun.jade.ui.resources.Internal");

    public EmailContract(long l, String[] stringArray, String[] stringArray2, String string, Locale locale) {
        this.id = l;
        this.tos = stringArray;
        this.topics = stringArray2;
        this.device = string;
        this.locale = locale;
        this.localizer.setLocale(locale);
    }

    public long getID() {
        return this.id;
    }

    public String[] getTos() {
        return this.tos;
    }

    public String getTosWithLink() {
        String string = "";
        int n = 0;
        while (n < this.tos.length) {
            string = string + "<a href=\"mailto:" + this.tos[n] + "\">" + this.tos[n] + "</a><br>";
            ++n;
        }
        return string;
    }

    public String[] getTopics() {
        Object object;
        String string = this.localizer.getString("allAlarmTopics");
        String string2 = this.localizer.getString("allEventTopics");
        boolean bl = TopicAnalyzer.areAllTopics(this.topics, topicResource);
        if (bl) {
            return new String[]{string, string2};
        }
        boolean bl2 = TopicAnalyzer.areAllAlarmTopics(this.topics, topicResource);
        boolean bl3 = TopicAnalyzer.areAllEventTopics(this.topics, topicResource);
        if (bl2) {
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            vector.add(string);
            int n = 0;
            while (n < this.topics.length) {
                if (this.topics[n] == null || !this.topics[n].startsWith(".alert")) {
                    object2 = EmailContract.getTopic(this.topics[n], this.locale);
                    if (object2 == null) {
                        vector.add(this.topics[n]);
                    } else if (!vector.contains(object2)) {
                        vector.add(object2);
                    }
                }
                ++n;
            }
            object2 = new String[vector.size()];
            return vector.toArray((T[])object2);
        }
        if (bl3) {
            Object object3;
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < this.topics.length) {
                if (this.topics[n] == null || this.topics[n].startsWith(".alert")) {
                    object3 = EmailContract.getTopic(this.topics[n], this.locale);
                    if (object3 == null) {
                        vector.add(this.topics[n]);
                    } else if (!vector.contains(object3)) {
                        vector.add(object3);
                    }
                }
                ++n;
            }
            vector.add(string2);
            object3 = new String[vector.size()];
            return vector.toArray((T[])object3);
        }
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        while (n < this.topics.length) {
            if (this.topics[n] == null || this.topics[n].startsWith(".alert")) {
                String string3 = EmailContract.getTopic(this.topics[n], this.locale);
                if (string3 == null) {
                    vector.add(this.topics[n]);
                } else if (!vector.contains(string3)) {
                    vector.add(string3);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.topics.length) {
            if (this.topics[n2] == null || !this.topics[n2].startsWith(".alert")) {
                object = EmailContract.getTopic(this.topics[n2], this.locale);
                if (object == null) {
                    vector.add(this.topics[n2]);
                } else if (!vector.contains(object)) {
                    vector.add(object);
                }
            }
            ++n2;
        }
        object = new String[vector.size()];
        return vector.toArray((T[])object);
    }

    public String getOneStringTopics() {
        String[] stringArray = this.getTopics();
        String string = stringArray[0];
        int n = 1;
        while (n < stringArray.length) {
            string = n % 3 != 0 ? string + ", " + stringArray[n] : string + ", " + "<br>" + stringArray[n];
            ++n;
        }
        return string;
    }

    public String getDevice() {
        if (this.device == null) {
            return this.localizer.getString("allDevices");
        }
        String string = this.getName(this.device);
        if (string == null) {
            return this.device;
        }
        return string;
    }

    public String getActionWithLink() {
        String string = this.localizer.getString("modify");
        String string2 = "/jade/jsp/emailNotificationAddition.jsp?id=" + this.id;
        String string3 = "[<a href='" + string2 + "'>" + string + "</a>]\n";
        return string3;
    }

    private String getName(String string) {
        Iterator iterator = DevInfo.getAllDeviceProperties();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("TYPE");
            String string3 = properties.getProperty("CLASS_NAME");
            String string4 = properties.getProperty("CAPTION");
            if (string2 == null || string3 == null || !string3.equals(string)) continue;
            if (string4 != null) {
                string4 = this.localizer.getString(string4);
                return string4;
            }
            return string2;
        }
        return null;
    }

    private static String getTopic(String string, Locale locale) {
        String string2 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(topicResource, locale);
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                if (!EmailContract.isTopicPartOf(string, string3)) continue;
                string2 = resourceBundle.getString(string3);
                break;
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Cannot access Topic property file");
        }
        return string2;
    }

    private static boolean isTopicPartOf(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string.equals(string3)) continue;
            return true;
        }
        return false;
    }
}

