/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.tags;

import com.sun.jade.apps.persistence.service.EventsPersistence;
import com.sun.jade.apps.persistence.service.GenericPersistence;
import com.sun.jade.apps.persistence.service.PersistenceService;
import com.sun.jade.event.Alarm;
import com.sun.jade.event.NSMEvent;
import com.sun.jade.event.generator.EventHelper;
import com.sun.jade.event.generator.PropertiesGenerator;
import com.sun.jade.ui.login.User;
import com.sun.jade.util.ItemImpl;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.util.ElementFinder;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class EventDetailsTag
extends TagSupport {
    private String mode = "";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("M/d/yyy h:mm:ss a z");

    public void setMode(String string) {
        this.mode = string;
    }

    public int doEndTag() throws JspException {
        Locale locale;
        Object object;
        Serializable serializable;
        ServletRequest servletRequest = this.pageContext.getRequest();
        String string = servletRequest.getParameter("submitControl");
        String string2 = servletRequest.getParameter("submitControl");
        String string3 = servletRequest.getParameter("id");
        String string4 = servletRequest.getParameter("note");
        String string5 = servletRequest.getParameter("number");
        if (string3 == null && string5 != null) {
            int n = 2;
            if ("alarms".equals(this.mode)) {
                n = 3;
            }
            long l = -1L;
            try {
                l = Long.valueOf(string5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            string3 = this.getEventID(l, n);
            if (l == -1L || string3 == null) {
                this.reportError(this.pageContext);
                return 5;
            }
        }
        if ("Ack".equals(string2) && "alarms".equals(this.mode)) {
            Alarm alarm = this.readAlarm(string3);
            if (alarm != null && !alarm.getIsAcked()) {
                HttpSession httpSession = ((HttpServletRequest)servletRequest).getSession();
                serializable = (User)httpSession.getAttribute("user");
                object = ((User)serializable).getUsername();
                long l = System.currentTimeMillis();
                alarm.setIsAcked(true);
                alarm.setAckTime(l);
                alarm.setAckBy((String)object);
                alarm.setNote(string4);
                this.updateAlarm(alarm);
            }
        } else if ("Update".equals(string2) && "alarms".equals(this.mode)) {
            Alarm alarm = this.readAlarm(string3);
            alarm.setNote(string4);
            this.updateAlarm(alarm);
        } else if (!"Reset".equals(string2) || "alarms".equals(this.mode)) {
            // empty if block
        }
        if ((locale = servletRequest.getLocale()) == null) {
            locale = Locale.getDefault();
        }
        String string6 = "com.sun.jade.ui.resources.ApplicationResources";
        serializable = new Localizer(string6);
        if (locale != null) {
            ((Localizer)serializable).setLocale(locale);
        }
        object = null;
        NSMEvent nSMEvent = null;
        if ("alarms".equals(this.mode)) {
            object = this.readAlarm(string3);
            nSMEvent = ((Alarm)object).getEvent();
            if (((Alarm)object).getIsAcked()) {
                this.pageContext.setAttribute("isAcked", (Object)"yes");
            } else {
                this.pageContext.setAttribute("isAcked", (Object)"no");
            }
        } else {
            nSMEvent = this.readEvent(string3);
        }
        String string7 = EventHelper.getSeverityCode(nSMEvent.getSeverity());
        PropertiesGenerator propertiesGenerator = EventHelper.getGenerator(nSMEvent.getTopic());
        this.pageContext.setAttribute("eventID", (Object)nSMEvent.getEventID(), 1);
        Iterator iterator = propertiesGenerator.generateProperties((NSMEvent)nSMEvent, (Locale)locale, (boolean)true).data;
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if ("alarms".equals(this.mode)) {
            ItemImpl itemImpl;
            ItemImpl itemImpl2;
            if (((Alarm)object).getIsCleared()) {
                itemImpl2 = new ItemImpl(((Localizer)serializable).getString("header.cleared"), ((Localizer)serializable).getString("Yes"));
                itemImpl = new ItemImpl(((Localizer)serializable).getString("header.clearTime"), sdf.format(new Date(((Alarm)object).getClearTime())));
                arrayList.add(itemImpl2);
                arrayList.add(itemImpl);
            } else {
                itemImpl2 = new ItemImpl(((Localizer)serializable).getString("header.cleared"), ((Localizer)serializable).getString("No"));
                arrayList.add(itemImpl2);
            }
            if (((Alarm)object).getIsAcked()) {
                itemImpl2 = new ItemImpl(((Localizer)serializable).getString("header.acknowledged"), ((Localizer)serializable).getString("Yes"));
                itemImpl = new ItemImpl(((Localizer)serializable).getString("header.acknowledgedBy"), ((Alarm)object).getAckBy());
                ItemImpl itemImpl3 = new ItemImpl(((Localizer)serializable).getString("header.acknowledgeTime"), sdf.format(new Date(((Alarm)object).getAckTime())));
                arrayList.add(itemImpl2);
                arrayList.add(itemImpl);
                arrayList.add(itemImpl3);
            } else {
                itemImpl2 = new ItemImpl(((Localizer)serializable).getString("header.acknowledged"), ((Localizer)serializable).getString("No"));
                arrayList.add(itemImpl2);
            }
            itemImpl2 = new ItemImpl(((Localizer)serializable).getString("header.note") + "<p>&nbsp;<p>&nbsp;", "<TEXTAREA NAME=\"note\" ROWS=\"4\" COLS=\"30\" WRAP=\"SOFT\">" + (((Alarm)object).getNote() == null ? " " : ((Alarm)object).getNote()) + "</TEXTAREA>");
            arrayList.add(itemImpl2);
        }
        this.pageContext.setAttribute("event", arrayList, 1);
        this.pageContext.setAttribute("Severity", (Object)string7, 1);
        return 6;
    }

    private String getEventID(long l, int n) {
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            EventsPersistence eventsPersistence = persistenceService.getEventsPersistence();
            long l2 = eventsPersistence.countEvents(2, 2, n);
            long l3 = l2 - l - 1L;
            if (l3 < 0L) {
                return null;
            }
            Iterator iterator = eventsPersistence.retrieveEvents(null, 2, 2, n, l3, 1L);
            if (iterator.hasNext()) {
                if (n == 2) {
                    NSMEvent nSMEvent = (NSMEvent)iterator.next();
                    return nSMEvent.getEventID();
                }
                Alarm alarm = (Alarm)iterator.next();
                return alarm.getEvent().getEventID();
            }
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in database operation");
        }
        return null;
    }

    private NSMEvent readEvent(String string) {
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
            return genericPersistence.retrieveEventByID(string);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in database operation");
            return null;
        }
    }

    private Alarm readAlarm(String string) {
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
            return genericPersistence.retrieveAlarmByID(string);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in database operation");
            return null;
        }
    }

    private void updateAlarm(Alarm alarm) {
        try {
            PersistenceService persistenceService = PersistenceService.getService();
            GenericPersistence genericPersistence = persistenceService.getGenericPersistence();
            genericPersistence.updateAlarm(alarm);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error in database operation");
        }
    }

    private void reportError(PageContext pageContext) {
        try {
            JspWriter jspWriter = pageContext.getOut();
            String string = ElementFinder.getErrorMessage(pageContext, "999");
            jspWriter.println(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

