/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.web.tags;

import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.ui.diags.monitor.model.MonitorModel;
import com.sun.jade.ui.diags.monitor.model.TestEvent;
import com.sun.jade.ui.diags.monitor.model.TestListener;
import com.sun.jade.ui.util.Properties;
import com.sun.jade.util.log.Report;
import com.sun.jade.web.diags.DiagnosticBean;
import com.sun.jade.web.diags.DiagnosticResultBean;
import com.sun.jade.web.util.ElementFinder;
import java.rmi.RemoteException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class TestExecTag
extends TagSupport {
    private final String domain = Properties.getDomain();
    private MonitorModel monitor;

    public int doEndTag() throws JspException {
        ServletRequest servletRequest = this.pageContext.getRequest();
        Locale locale = servletRequest.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string = ElementFinder.getOID((HttpServletRequest)servletRequest);
        String string2 = servletRequest.getParameter("username");
        String string3 = servletRequest.getParameter("testName");
        String string4 = servletRequest.getParameter("syncMode");
        if (string == null || string3 == null) {
            try {
                JspWriter jspWriter = this.pageContext.getOut();
                String string5 = ElementFinder.getErrorMessage(this.pageContext, "999");
                jspWriter.println(string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return 5;
        }
        try {
            boolean bl = false;
            if (string4 != null && "sync".equals(string4)) {
                bl = true;
            }
            Listener listener = new Listener(string2, locale, bl);
            DiagnosticResult diagnosticResult = listener.submit(servletRequest, string);
            JspWriter jspWriter = this.pageContext.getOut();
            if (listener.getStatus() == 1) {
                jspWriter.println("Invalid test name");
                return 5;
            }
            if (listener.getStatus() == 2) {
                jspWriter.println("Test submitted");
                return 5;
            }
            DiagnosticResultBean diagnosticResultBean = new DiagnosticResultBean(string2, "", string3, diagnosticResult, locale);
            this.pageContext.setAttribute("result", (Object)diagnosticResultBean, 1);
            this.pageContext.setAttribute("data", (Object)diagnosticResult.getTestResults(), 1);
        }
        catch (RemoteException remoteException) {
            Report.error.log(remoteException, (Object)"Error while submitting test");
            throw new JspException((Throwable)remoteException);
        }
        catch (Exception exception) {
            Report.error.log(exception, (Object)"Error while submitting test");
            throw new JspException((Throwable)exception);
        }
        return 6;
    }

    private class Listener
    implements TestListener {
        private String userName;
        private Locale locale;
        private boolean waitForResult;
        private int status;
        private DiagnosticResult testResult;

        Listener(String string, Locale locale, boolean bl) {
            this.userName = string;
            this.locale = locale;
            this.waitForResult = bl;
            this.connect();
        }

        private void connect() {
            if (this.userName == null || this.locale == null) {
                throw new IllegalStateException();
            }
            if (TestExecTag.this.monitor != null) {
                TestExecTag.this.monitor.removeTestEventListener(this);
            }
            try {
                TestExecTag.this.monitor = MonitorModel.get(TestExecTag.this.domain, this.userName, this.locale);
                TestExecTag.this.monitor.addTestEventListener(this);
            }
            catch (RemoteException remoteException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized DiagnosticResult submit(ServletRequest servletRequest, String string) throws Exception {
            DiagnosticBean diagnosticBean = new DiagnosticBean(string);
            if (diagnosticBean.submitTest(servletRequest, this.userName) == null) {
                this.status = 1;
                return null;
            }
            if (!this.waitForResult) {
                this.status = 2;
                return null;
            }
            this.status = 3;
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.testResult == null || this.testResult.getPercentCompleteValue() != 100);
            return this.testResult;
        }

        public synchronized void notify(TestEvent testEvent) {
            this.testResult = testEvent.getDiagnosticResult();
            if (this.testResult.getPercentCompleteValue() == 100) {
                this.notify();
            }
        }
    }
}

