/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.AlPortStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.HardZone;
import com.sun.jade.device.fcswitch.ancor.sanbox.Initiators;
import com.sun.jade.device.fcswitch.ancor.sanbox.NameServer;
import com.sun.jade.device.fcswitch.ancor.sanbox.NameServerNode;
import com.sun.jade.device.fcswitch.ancor.sanbox.NameServerPort;
import com.sun.jade.device.fcswitch.ancor.sanbox.NetConfig;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortCounts;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortState;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortSteering;
import com.sun.jade.device.fcswitch.ancor.sanbox.ResetLog;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxException;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.device.fcswitch.ancor.sanbox.SimpleCommand;
import com.sun.jade.device.fcswitch.ancor.sanbox.SimpleSubCommand;
import com.sun.jade.device.fcswitch.ancor.sanbox.SystemConfig;
import com.sun.jade.device.fcswitch.ancor.sanbox.TestStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Topology;
import com.sun.jade.device.fcswitch.ancor.sanbox.WWNZone;
import com.sun.jade.device.fcswitch.util.snmp.PortSpeedHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.snmp.SanBoxToSNMP_PortType_Adapter;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.protocol.util.Hex;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Sanbox {
    private static final String sccs_id = "@(#)Sanbox.java\t1.38 04/24/03 SMI";
    public static final int SB_DEFAULT_DEST_ADDR = 0xFFFFFD;
    public static final int MAX_PORTS = 16;
    public static final int MAX_HARD_ZONES = 16;
    private static final int PORT = 5000;
    private static final int TIMEOUT = 20;
    private static final int TRIES = 10;
    private static final String DEFAULT_PORT_TYPE = "1";
    private InetAddress host;
    private String systemName;
    private DatagramSocket socket;
    private String userId;
    private int tcpPort = 5000;
    private int fdAddr = 0xFFFFFD;
    private int localAddr = 0xFFFFFD;
    private Zones[] zones = null;
    private int noOfZones;
    private boolean nullZone = false;
    private long sysUpTime;

    public Sanbox(InetAddress inetAddress) {
        this.open(inetAddress);
        this.systemName = this.getWWN();
    }

    public Sanbox(String string) {
        try {
            int n = string.indexOf(58);
            if (n > 0) {
                this.localAddr = this.fdAddr = Integer.parseInt(string.substring(n + 1));
                this.open(InetAddress.getByName(string.substring(0, n)));
            } else {
                this.open(InetAddress.getByName(string));
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException();
        }
        this.systemName = this.getWWN();
    }

    public void setRemoteAddr(int n) {
        this.fdAddr = n;
    }

    public void setLocalAddr() {
        this.fdAddr = this.localAddr;
    }

    public void open(InetAddress inetAddress) {
        this.host = inetAddress;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = new DatagramSocket();
            this.socket.setSoTimeout(20);
        }
        catch (SocketException socketException) {
            throw new SanboxException(socketException);
        }
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        this.host = null;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public SanboxVersion getVersion() {
        SimpleCommand simpleCommand = new SimpleCommand(7);
        simpleCommand.setDestinationAddress(this.fdAddr);
        DatagramPacket datagramPacket = this.query(simpleCommand.getBytes());
        if (datagramPacket == null) {
            return null;
        }
        return new SanboxVersion(datagramPacket.getData());
    }

    public NetConfig getNetConfig() {
        NetConfig netConfig = new NetConfig();
        netConfig.setDestinationAddress(this.fdAddr);
        DatagramPacket datagramPacket = this.query(netConfig.getBytes());
        if (datagramPacket == null) {
            return null;
        }
        return new NetConfig(datagramPacket.getData());
    }

    private NameServer getNSRequest(int n, int n2, int n3, int n4) {
        int n5 = (n2 & 0xFFFFC000) + (n << 8) + n3;
        return new NameServer(n5, false, n4);
    }

    public NameServerPort getNameServerPort(int n, int n2, int n3) {
        NameServer nameServer = this.getNSRequest(n, n2, n3, 0);
        nameServer.setDestinationAddress(this.fdAddr);
        DatagramPacket datagramPacket = this.query(nameServer.getBytes());
        if (datagramPacket == null) {
            return null;
        }
        return new NameServerPort(datagramPacket.getData());
    }

    public NameServerNode getNameServerNode(int n, int n2, int n3) {
        NameServer nameServer = this.getNSRequest(n, n2, n3, 1);
        nameServer.setDestinationAddress(this.fdAddr);
        DatagramPacket datagramPacket = this.query(nameServer.getBytes());
        if (datagramPacket == null) {
            return null;
        }
        return new NameServerNode(datagramPacket.getData());
    }

    public AlPortStatus getAlPortStatus(int n) {
        AlPortStatus alPortStatus = new AlPortStatus(n);
        DatagramPacket datagramPacket = this.query(alPortStatus.getBytes());
        if (datagramPacket == null) {
            return null;
        }
        return new AlPortStatus(datagramPacket.getData());
    }

    public void startTest(int n, int n2, int n3, int n4, boolean bl) {
        DatagramPacket datagramPacket = this.query(TestStatus.getTestStartBuffer(n, n2, n3, n4));
        if (datagramPacket == null) {
            throw new SanboxException("request failed");
        }
    }

    public void abortTest() {
        SimpleSubCommand simpleSubCommand = new SimpleSubCommand(49, 1);
        DatagramPacket datagramPacket = this.query(simpleSubCommand.getBytes());
        if (datagramPacket == null) {
            throw new SanboxException("Abort test request failed.");
        }
    }

    public TestStatus getTestStatus() {
        DatagramPacket datagramPacket = this.query(TestStatus.getTestStatusBuffer());
        if (datagramPacket == null) {
            return null;
        }
        return new TestStatus(datagramPacket.getData());
    }

    public PortCounts getPortCounts(int n) {
        DatagramPacket datagramPacket = this.query(PortCounts.getPortCountsRequest(n));
        if (datagramPacket == null) {
            return null;
        }
        return new PortCounts(datagramPacket.getData());
    }

    public PortSteering getPortSteering(int n) {
        DatagramPacket datagramPacket = this.query(PortSteering.getPortSteeringRequest(n));
        if (datagramPacket == null) {
            return null;
        }
        return new PortSteering(datagramPacket.getData());
    }

    public HardZone getHardZone() {
        DatagramPacket datagramPacket = this.query(HardZone.getHardZoneRequest());
        if (datagramPacket == null) {
            return null;
        }
        return new HardZone(datagramPacket.getData());
    }

    public WWNZone getWWNZone() {
        DatagramPacket datagramPacket = this.query(WWNZone.getWWNZoneRequest());
        if (datagramPacket == null) {
            return null;
        }
        return new WWNZone(datagramPacket.getData());
    }

    public ResetLog getResetLog(int n) {
        DatagramPacket datagramPacket = this.query(ResetLog.getResetLogRequest(n));
        if (datagramPacket == null) {
            return null;
        }
        return new ResetLog(datagramPacket.getData());
    }

    public Topology getTopology() {
        DatagramPacket datagramPacket = this.query(Topology.getTopologyRequest(0));
        if (datagramPacket == null) {
            return null;
        }
        return new Topology(datagramPacket.getData());
    }

    public Initiators getInitiators(int n) {
        DatagramPacket datagramPacket = this.query(Initiators.getInitiatorsRequest(n));
        if (datagramPacket == null) {
            return null;
        }
        return new Initiators(datagramPacket.getData());
    }

    public ChassisStatus getChassisStatus(int n) {
        DatagramPacket datagramPacket = this.query(ChassisStatus.getChassisStatusRequest(n));
        if (datagramPacket == null) {
            return null;
        }
        return new ChassisStatus(datagramPacket.getData());
    }

    public PortState getPortState(int n) {
        DatagramPacket datagramPacket = this.query(PortState.getPortStateRequest(n));
        if (datagramPacket == null) {
            return null;
        }
        return new PortState(datagramPacket.getData());
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void switchReset() {
    }

    public DatagramPacket query(byte[] byArray) {
        if (this.host == null) {
            throw new SanboxException("Connection to switch not open");
        }
        SanboxHeader sanboxHeader = new SanboxHeader(byArray);
        long l = sanboxHeader.getSequenceNumber();
        byte[] byArray2 = new byte[1024];
        DatagramPacket datagramPacket = null;
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, this.host, this.tcpPort);
        int n = 0;
        while (n < 10) {
            try {
                this.socket.send(datagramPacket2);
                datagramPacket = new DatagramPacket(byArray2, byArray2.length);
                this.socket.receive(datagramPacket);
                sanboxHeader.useData(datagramPacket.getData());
                if (sanboxHeader.getSequenceNumber() == l) {
                    break;
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                throw new SanboxException(iOException);
            }
            try {
                Thread.currentThread();
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        if (n == 10) {
            throw new SanboxException("Switch Communication Error");
        }
        return datagramPacket;
    }

    public SystemConfig getSystemConfig() {
        DatagramPacket datagramPacket = this.query(SystemConfig.getSystemConfigRequest());
        if (datagramPacket == null) {
            return null;
        }
        return new SystemConfig(datagramPacket.getData());
    }

    public String getReport() {
        StringBuffer stringBuffer = new StringBuffer();
        ChassisStatus chassisStatus = this.getChassisStatus(0);
        SystemConfig systemConfig = this.getSystemConfig();
        SanboxVersion sanboxVersion = this.getVersion();
        WWNZone wWNZone = this.getWWNZone();
        int n = chassisStatus.getNumOfPorts();
        PortCounts[] portCountsArray = new PortCounts[n];
        PortState[] portStateArray = new PortState[n];
        int n2 = 0;
        while (n2 < n) {
            portCountsArray[n2] = this.getPortCounts(n2);
            portStateArray[n2] = this.getPortState(n2);
            ++n2;
        }
        int n3 = this.host.getHostName().indexOf(".");
        stringBuffer.append("chassis.fan.1.status\t" + chassisStatus.getFanStatusString(1) + "\n");
        stringBuffer.append("chassis.fan.2.status\t" + chassisStatus.getFanStatusString(2) + "\n");
        stringBuffer.append("chassis.power.status\t" + chassisStatus.getPowerSupplyFailedString() + "\n");
        stringBuffer.append("chassis.temp.status\t" + chassisStatus.getBoardHeatStatusString() + "\n");
        stringBuffer.append("chassis.temp.value\t" + (double)((int)((double)chassisStatus.getBoardTemp() * 0.5 * 10.0)) / 10.0 + "c" + "\n");
        stringBuffer.append("chassis.uptime\t" + systemConfig.getSysUpTime() + "s" + "\n");
        stringBuffer.append("id.ip\t" + this.host.getHostAddress() + "\n");
        stringBuffer.append("id.ipno\t" + this.host.getHostAddress() + "\n");
        stringBuffer.append("id.mac\t" + Integer.toHexString((int)(sanboxVersion.getMACAddr() >> 32)) + Integer.toHexString((int)sanboxVersion.getMACAddr()) + "\n");
        stringBuffer.append("id.name\t" + this.host.getHostName().substring(0, n3) + "\n");
        stringBuffer.append("id.wwn\t" + Integer.toHexString((int)(sanboxVersion.getWorldWideName() >> 32)) + Integer.toHexString((int)sanboxVersion.getWorldWideName()) + "\n");
        int n4 = 0;
        while (n4 < n) {
            stringBuffer.append("port." + (n4 + 1) + ".error.AL Init Errs\t" + portCountsArray[n4].getal_init_err_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.AddressIdErrs\t" + portCountsArray[n4].getfcFPortAddressIdErrors() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.CRC Errs\t" + portCountsArray[n4].getfcFPortInvalidCrcs() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.InvalidTxWds\t" + portCountsArray[n4].getfcFPortInvalidTxWords() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.LinkFails\t" + portCountsArray[n4].getfcFPortLinkFailures() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.Prim Seq Errs\t" + portCountsArray[n4].getfcFPortPrimSeqProtoErrors() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.SyncLosses\t" + portCountsArray[n4].getfcFPortSyncLosses() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.Total LIP Rcvd\t" + portCountsArray[n4].gettotal_lip_rcvd_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.long_frame_err_cnt\t" + portCountsArray[n4].getlong_frame_err_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.loss_of_signal_cnt\t" + portCountsArray[n4].getloss_of_signal_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.short_frame_err_cnt\t" + portCountsArray[n4].getshort_frame_err_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".error.sync_loss\t" + portCountsArray[n4].getsync_loss() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".mode\t" + portStateArray[n4].getOperationalStateString() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.AL Inits\t" + portCountsArray[n4].getal_init_attempts_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.C2Rjtframes\t" + portCountsArray[n4].getfcFPortC2FrjtFrames() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.DelimiterErrs\t" + portCountsArray[n4].getfcFPortDelimiterErrors() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.Discards\t" + portCountsArray[n4].getfcFPortC23Discards() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.Fbsyframes\t" + portCountsArray[n4].getfcFPortC2FbsyFrames() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.Inframes\t" + portCountsArray[n4].getfcFPortC23InFrames() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.LIF_flow_cntrl_err_cnt\t" + portCountsArray[n4].getLIF_flow_cntrl_err_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.LIP AL_PD,AL_PS\t" + portCountsArray[n4].getlip_reset_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.LIP F7 AL_PS\t" + portCountsArray[n4].getlip_nrml_has_al_pa_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.LIP F7 F7\t" + portCountsArray[n4].getlip_nrml_no_al_pa_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.LIP F8 AL_PS\t" + portCountsArray[n4].getlip_err_has_al_pa_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.LIP F8 F7\t" + portCountsArray[n4].getlip_err_no_al_pa_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.Link Reset In\t" + portCountsArray[n4].getfcFPortLinkResetIns() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.Link Reset Out\t" + portCountsArray[n4].getfcFPortLinkResetOuts() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.OLS In\t" + portCountsArray[n4].getfcFPortOlsIns() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.OLS Out\t" + portCountsArray[n4].getfcFPortOlsOuts() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.Outframes\t" + portCountsArray[n4].getfcFPortC23OutFrames() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.laser_fault_cnt\t" + portCountsArray[n4].getlaser_fault_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.lip_during_init\t" + portCountsArray[n4].getlip_during_init() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.lism_failed\t" + portCountsArray[n4].getlism_failed() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.lof_timeout\t" + portCountsArray[n4].getlof_timeout() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.lof_timeout_els\t" + portCountsArray[n4].getlof_timeout_els() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.loop_init_failed\t" + portCountsArray[n4].getloop_init_failed() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.opn_returned\t" + portCountsArray[n4].getopn_returned() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.retry_lip\t" + portCountsArray[n4].getretry_lip() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".stats.smth_ovrflw_err_cnt\t" + portCountsArray[n4].getsmth_ovrflw_err_cnt() + "\n");
            stringBuffer.append("port." + (n4 + 1) + ".type\t" + portStateArray[n4].getPortTypeString() + "\n");
            ++n4;
        }
        stringBuffer.append("version.FLASH\t" + Integer.toHexString((int)sanboxVersion.getFlashRevision()) + "\n");
        stringBuffer.append("version.HW\t" + Integer.toHexString((int)sanboxVersion.getPromHWVersion()) + "\n");
        stringBuffer.append("version.MAC\t" + Integer.toHexString((int)(sanboxVersion.getMACAddr() >> 32)) + Integer.toHexString((int)sanboxVersion.getMACAddr()) + "\n");
        stringBuffer.append("version.PROM\t" + Integer.toHexString((int)sanboxVersion.getPromSWVersion()) + "\n");
        stringBuffer.append("version.WWN\t" + Integer.toHexString((int)(sanboxVersion.getWorldWideName() >> 32)) + Integer.toHexString((int)sanboxVersion.getWorldWideName()) + "\n");
        stringBuffer.append("version.ports\t" + chassisStatus.getNumOfPorts() + "\n");
        stringBuffer.append("zone.total\t" + wWNZone.getTotalNumWWNEntries() + "\n");
        return stringBuffer.toString();
    }

    private String getWWN() {
        SanboxVersion sanboxVersion = this.getVersion();
        String string = Integer.toHexString((int)(sanboxVersion.getWorldWideName() >> 32)) + Integer.toHexString((int)sanboxVersion.getWorldWideName());
        return string;
    }

    public String getXMLReport() {
        StringBuffer stringBuffer = new StringBuffer();
        ChassisStatus chassisStatus = this.getChassisStatus(0);
        SystemConfig systemConfig = this.getSystemConfig();
        this.sysUpTime = systemConfig.getSysUpTime();
        double d = this.sysUpTime / 100L;
        this.sysUpTime = Math.round(d);
        SanboxVersion sanboxVersion = this.getVersion();
        WWNZone wWNZone = this.getWWNZone();
        int n = chassisStatus.getNumOfPorts();
        PortCounts[] portCountsArray = new PortCounts[n];
        PortState[] portStateArray = new PortState[n];
        int n2 = 0;
        while (n2 < n) {
            portCountsArray[n2] = this.getPortCounts(n2);
            portStateArray[n2] = this.getPortState(n2);
            ++n2;
        }
        stringBuffer.append("<report ReturnCode = 'OK'>\n");
        stringBuffer.append("<model schema=\"CIM2.5\"");
        stringBuffer.append(" view=\"system\"");
        stringBuffer.append(" type=\"switch\"");
        stringBuffer.append(" package=\"com.sun.jade.cim.bean\"");
        stringBuffer.append(">");
        stringBuffer = this.addUnitaryComputerSystem(stringBuffer);
        int n3 = 0;
        while (n3 < n) {
            stringBuffer = this.addFibrePort(stringBuffer, n3, portCountsArray[n3], portStateArray[n3]);
            stringBuffer = this.addDeviceStatisticalInformation(stringBuffer, n3, portCountsArray[n3]);
            this.addProtocolEndpoint(stringBuffer, portStateArray[n3], n3);
            stringBuffer.append("</FibrePort>\n");
            ++n3;
        }
        stringBuffer = this.addChassis(stringBuffer);
        stringBuffer = this.addPhysicalPackage(stringBuffer);
        stringBuffer.append("</UnitaryComputerSystem>\n");
        stringBuffer.append("</model>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    private StringBuffer addUnitaryComputerSystem(StringBuffer stringBuffer) {
        ChassisStatus chassisStatus = this.getChassisStatus(0);
        SanboxVersion sanboxVersion = this.getVersion();
        WWNZone wWNZone = this.getWWNZone();
        stringBuffer.append("<UnitaryComputerSystem");
        stringBuffer.append(" Name=\"" + this.systemName + "\"");
        stringBuffer.append(" Status='OK'");
        stringBuffer.append(" CreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" OtherIdentifyingInfo = '\"" + this.host.getHostAddress() + "\"'");
        stringBuffer.append(" IdentifyingDescriptions = '\"IP Address\"'");
        stringBuffer.append(" PortCount=\"" + chassisStatus.getNumOfPorts() + "\"");
        stringBuffer.append(" Flash=\"" + Integer.toHexString((int)sanboxVersion.getFlashRevision()) + "\"");
        stringBuffer.append(" HW=\"" + Integer.toHexString((int)sanboxVersion.getPromHWVersion()) + "\"");
        stringBuffer.append(" MAC=\"" + Integer.toHexString((int)(sanboxVersion.getMACAddr() >> 32)) + Integer.toHexString((int)sanboxVersion.getMACAddr()) + "\"");
        stringBuffer.append(" PROM=\"" + Integer.toHexString((int)sanboxVersion.getPromSWVersion()) + "\"");
        stringBuffer.append(" WWN=\"" + this.getWWN() + "\"");
        if (this.nullZone) {
            stringBuffer.append(" ZoneTotal=\"" + (this.noOfZones - 1) + "\"");
        } else {
            stringBuffer.append(" ZoneTotal=\"" + this.noOfZones + "\"");
        }
        stringBuffer.append(">\n");
        return stringBuffer;
    }

    protected String getPortWWN(int n) {
        String string = Integer.toHexString(n);
        String string2 = this.computePortWWN(string);
        return string2;
    }

    private String computePortWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getWWN());
        stringBuffer.setCharAt(0, '2');
        if (string.length() > 1) {
            stringBuffer.setCharAt(2, string.charAt(0));
            stringBuffer.setCharAt(3, string.charAt(1));
            return stringBuffer.toString();
        }
        stringBuffer.setCharAt(3, string.charAt(0));
        return stringBuffer.toString();
    }

    private StringBuffer addZones(StringBuffer stringBuffer, Zones zones) {
        stringBuffer.append("<Zone");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" REF=\"" + zones.getZoneName().trim() + "\"");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append(" Name=\"" + zones.getZoneName().trim() + " (" + zones.getZoneDescription() + ")\"");
        stringBuffer.append(" ElementName=\"" + zones.getZoneName() + "\"");
        stringBuffer.append(" OtherZoneTypeDescription=\"" + zones.getZoneDescription() + "\"");
        stringBuffer.append(" Active=\"true\"");
        stringBuffer.append(" ProtocolType=\"1\"");
        stringBuffer.append("/>");
        return stringBuffer;
    }

    private StringBuffer addZoneMembers(StringBuffer stringBuffer, Zones zones) {
        Object[] objectArray = zones.getPortList();
        if (objectArray.length > 0) {
            stringBuffer.append("<ZoneMember");
            stringBuffer.append(" ZoneMemberType=\"5\">");
            stringBuffer.append("<Collection");
            stringBuffer.append(" REF=\"" + zones.getZoneName().trim() + "\"/>");
            int n = 0;
            while (n < objectArray.length) {
                stringBuffer.append("<Member");
                stringBuffer.append(" REF=\"" + ((String)objectArray[n]).trim() + "\"");
                stringBuffer.append("/>");
                ++n;
            }
            stringBuffer.append("</ZoneMember>");
        }
        return stringBuffer;
    }

    private StringBuffer addChassis(StringBuffer stringBuffer) {
        ChassisStatus chassisStatus = this.getChassisStatus(0);
        stringBuffer.append("<LogicalDevice");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append(" DeviceID=\"Chassis\"");
        stringBuffer.append(" Name=\"chassis\"");
        stringBuffer.append(" CreationClassName=\"StorAdeSwitch_ChassisDevice\"");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" Status=\"" + this.convertToCIMStatus("online") + "\"");
        stringBuffer.append(" Availability=\"" + this.convertToCIMAvailability("online") + "\"");
        stringBuffer.append(" Description=\"Sun StorEdge network FC switch Chassis\"");
        stringBuffer.append(" PowerOnTime=\"" + this.sysUpTime + "s\"");
        stringBuffer.append(" PowerOnSeconds=\"" + this.sysUpTime + "\"");
        stringBuffer.append(" PowerManagementSupported=\"false\"");
        stringBuffer.append(">");
        stringBuffer.append(" <Fan");
        stringBuffer.append(" CreationClassName=\"CIM_Fan\"");
        stringBuffer.append(" DeviceID=\"Fan 1\"");
        stringBuffer.append(" Status=\"" + chassisStatus.getFanStatusString(1) + "\"");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append("/>");
        stringBuffer.append("<Fan");
        stringBuffer.append(" CreationClassName=\"CIM_Fan\"");
        stringBuffer.append(" DeviceID=\"Fan 2\"");
        stringBuffer.append(" Status=\"" + chassisStatus.getFanStatusString(2) + "\"");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append("/>");
        stringBuffer.append("<PowerSupply");
        stringBuffer.append(" CreationClassName=\"CIM_UninterruptiblePowerSupply\"");
        stringBuffer.append(" DeviceID=\"Power Supply\"");
        stringBuffer.append(" Status=\"" + chassisStatus.getPowerSupplyFailedString() + "\"");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append("/>");
        stringBuffer.append("<TemperatureSensor");
        stringBuffer.append(" CreationClassName=\"CIM_TemperatureSensor\"");
        stringBuffer.append(" DeviceID=\"Temperature Sensor\"");
        stringBuffer.append(" Status=\"" + chassisStatus.getBoardHeatStatusString() + "\"");
        stringBuffer.append(" SensorType=\"1\"");
        stringBuffer.append(" OtherSensorTypeDescription=\"" + (double)((int)((double)chassisStatus.getBoardTemp() * 0.5 * 10.0)) / 10.0 + "\"");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append("/>");
        stringBuffer.append("</LogicalDevice>\n");
        return stringBuffer;
    }

    private StringBuffer addFibrePort(StringBuffer stringBuffer, int n, PortCounts portCounts, PortState portState) {
        stringBuffer.append("<FibrePort");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append(" DeviceID=\"" + (n + 1) + "\"");
        stringBuffer.append(" REF=\"" + (n + 1) + "\"");
        String string = this.getPortWWN(n);
        if (string == null) {
            string = "";
        }
        stringBuffer.append(" Name=\"" + string + "\"");
        stringBuffer.append(" CreationClassName=\"StorAdeSwitch_FibrePort\"");
        stringBuffer.append(" SystemCreationClassName=\"StorAdeSwitch_UnitaryComputerSystem\"");
        stringBuffer.append(" Status=\"" + this.convertToCIMStatus(portState.getOperationalStateString()) + "\"");
        stringBuffer.append(" Availability=\"" + this.convertToCIMAvailability(portState.getOperationalStateString()) + "\"");
        stringBuffer.append(" PowerManagementSupported=\"false\"");
        stringBuffer.append(" LossOfSignalCounter=\"" + portCounts.getloss_of_signal_cnt() + "\"");
        stringBuffer.append(" LossOfSyncCounter=\"" + portCounts.getfcFPortSyncLosses() + "\"");
        stringBuffer.append(" CRCErrors=\"" + portCounts.getfcFPortInvalidCrcs() + "\"");
        stringBuffer.append(" InvalidTransmissionWords=\"" + portCounts.getfcFPortInvalidTxWords() + "\"");
        stringBuffer.append(" FramesTooShort=\"" + portCounts.getshort_frame_err_cnt() + "\"");
        stringBuffer.append(" FramesTooLong=\"" + portCounts.getlong_frame_err_cnt() + "\"");
        String string2 = SanBoxToSNMP_PortType_Adapter.getPortType(portState.getPortType());
        if (string2 == null) {
            string2 = SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE);
        }
        string2 = SNMPPortType.getPortTypeString(string2);
        stringBuffer.append(" Type=\"" + string2 + "\"");
        stringBuffer.append(" Description=\"" + string2 + "\"");
        stringBuffer.append(" Speed=\"1048576\"");
        stringBuffer.append(" PortOperatingSpeed=\"" + PortSpeedHelper.getPortSpeed("1048576") + "\"");
        stringBuffer.append(" OperatingStatus=\"" + portState.getOperationalStateString() + "\"");
        stringBuffer.append(" AdministrativeStatus=\"" + portState.getAdministrativeStateString() + "\"");
        stringBuffer.append(">");
        return stringBuffer;
    }

    private void addWWN_PE(StringBuffer stringBuffer, long l, long l2) {
        stringBuffer.append("<ProtocolEndpoint");
        stringBuffer.append(" Name='" + Hex.toHexString((long)l) + "'");
        stringBuffer.append(" NameFormat='WWN' ProtocolType='Fibre Channel'>");
        stringBuffer.append("<ProtocolEndpoint");
        stringBuffer.append(" Name='" + Hex.toHexString((long)l2) + "'");
        stringBuffer.append(" NameFormat='WWN' ProtocolType='Fibre Channel'/>");
        stringBuffer.append("</ProtocolEndpoint>\n");
    }

    private void addIP_PE(StringBuffer stringBuffer, InetAddress inetAddress, int n) {
        String string = Integer.toString(n >>> 24) + "." + Integer.toString(n >> 16 & 0xFF) + "." + Integer.toString(n >> 8 & 0xFF) + "." + Integer.toString(n & 0xFF);
        stringBuffer.append("<ProtocolEndpoint");
        stringBuffer.append(" Name='" + inetAddress + "'");
        stringBuffer.append(" NameFormat='IPv4' ProtocolType='IPv4'>");
        stringBuffer.append("<ProtocolEndpoint");
        stringBuffer.append(" Name='" + string + "'");
        stringBuffer.append(" NameFormat='IPv4' ProtocolType='IPv4'/>");
        stringBuffer.append("</ProtocolEndpoint>\n");
    }

    private void addProtocolEndpoint(StringBuffer stringBuffer, PortState portState, int n) {
        if (2 == portState.getOperationalState()) {
            return;
        }
        if (!portState.getLoggedIn()) {
            return;
        }
        AlPortStatus alPortStatus = null;
        Initiators initiators = null;
        NameServerPort nameServerPort = null;
        Object var7_7 = null;
        SanboxVersion sanboxVersion = this.getVersion();
        switch (portState.getPortType()) {
            case 3: {
                Topology topology = this.getTopology();
                int n2 = topology.getLinkPortAddr(n);
                this.setRemoteAddr(n2);
                SanboxVersion sanboxVersion2 = this.getVersion();
                NetConfig netConfig = this.getNetConfig();
                this.setLocalAddr();
                this.addWWN_PE(stringBuffer, sanboxVersion.getWorldWideName(), sanboxVersion2.getWorldWideName());
                this.addIP_PE(stringBuffer, this.host, netConfig.getNetAddress());
                break;
            }
            case 1: {
                int n3 = (int)sanboxVersion.getModuleAddr();
                nameServerPort = this.getNameServerPort(n, n3, 0);
                this.addWWN_PE(stringBuffer, sanboxVersion.getWorldWideName(), nameServerPort.getWorldWideName());
                break;
            }
            case 4: {
                alPortStatus = this.getAlPortStatus(n);
                initiators = this.getInitiators(0);
                int n4 = initiators.getNumInitiators();
                int n5 = 0;
                while (n5 < n4) {
                    if (n == initiators.getPortNum(n5)) {
                        this.addWWN_PE(stringBuffer, sanboxVersion.getWorldWideName(), initiators.getPortName(n5));
                    }
                    ++n5;
                }
                break;
            }
            case 2: 
            case 5: {
                alPortStatus = this.getAlPortStatus(n);
                int n6 = alPortStatus.getFirstPortAddr();
                int n7 = alPortStatus.getPortEntryCount();
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = alPortStatus.getDeviceAlpa(n8);
                    nameServerPort = this.getNameServerPort(n, n6, n9);
                    this.addWWN_PE(stringBuffer, sanboxVersion.getWorldWideName(), nameServerPort.getWorldWideName());
                    ++n8;
                }
                break;
            }
        }
    }

    private StringBuffer addDeviceStatisticalInformation(StringBuffer stringBuffer, int n, PortCounts portCounts) {
        stringBuffer.append("<DeviceStatisticalInformation");
        stringBuffer.append(" SystemName=\"" + this.systemName + "\"");
        stringBuffer.append(" DeviceCreationClassName=\"StorAdeSwitch_FibrePort\"");
        stringBuffer.append(" CreationClassName=\"StorAdeSwitch_FibrePortEventCounters\"");
        stringBuffer.append(" DeviceID=\"" + (n + 1) + "\"");
        stringBuffer.append(" Name=\"port." + (n + 1) + "\"");
        stringBuffer.append(" AL_Init_Errs=\"" + portCounts.getal_init_err_cnt() + "\"");
        stringBuffer.append(" AddressIdErrs=\"" + portCounts.getfcFPortAddressIdErrors() + "\"");
        stringBuffer.append(" LinkFails=\"" + portCounts.getfcFPortLinkFailures() + "\"");
        stringBuffer.append(" Prim_Seq_Errs=\"" + portCounts.getfcFPortPrimSeqProtoErrors() + "\"");
        stringBuffer.append(" Total_LIP_Rcvd=\"" + portCounts.gettotal_lip_rcvd_cnt() + "\"");
        stringBuffer.append(" AL_Inits=\"" + portCounts.getal_init_attempts_cnt() + "\"");
        stringBuffer.append(" C2Rjtframes=\"" + portCounts.getfcFPortC2FrjtFrames() + "\"");
        stringBuffer.append(" DelimiterErrs=\"" + portCounts.getfcFPortDelimiterErrors() + "\"");
        stringBuffer.append(" Discards=\"" + portCounts.getfcFPortC23Discards() + "\"");
        stringBuffer.append(" Fbsyframes=\"" + portCounts.getfcFPortC2FbsyFrames() + "\"");
        stringBuffer.append(" LIF_flow_cntrl_err_cnt=\"" + portCounts.getLIF_flow_cntrl_err_cnt() + "\"");
        stringBuffer.append(" LIP_AL_PD_AL_PS=\"" + portCounts.getlip_reset_cnt() + "\"");
        stringBuffer.append(" LIP_F7_AL_PS=\"" + portCounts.getlip_nrml_has_al_pa_cnt() + "\"");
        stringBuffer.append(" LIP_F7_F7=\"" + portCounts.getlip_nrml_no_al_pa_cnt() + "\"");
        stringBuffer.append(" LIP_F8_AL_PS=\"" + portCounts.getlip_err_has_al_pa_cnt() + "\"");
        stringBuffer.append(" LIP_F8_F7=\"" + portCounts.getlip_err_no_al_pa_cnt() + "\"");
        stringBuffer.append(" Link_Reset_In=\"" + portCounts.getfcFPortLinkResetIns() + "\"");
        stringBuffer.append(" Link_Reset_Out=\"" + portCounts.getfcFPortLinkResetOuts() + "\"");
        stringBuffer.append(" OLS_In=\"" + portCounts.getfcFPortOlsIns() + "\"");
        stringBuffer.append(" OLS_Out=\"" + portCounts.getfcFPortOlsOuts() + "\"");
        stringBuffer.append(" Outframes=\"" + portCounts.getfcFPortC23OutFrames() + "\"");
        stringBuffer.append(" Laser_fault_cnt=\"" + portCounts.getlaser_fault_cnt() + "\"");
        stringBuffer.append(" LIP_during_init=\"" + portCounts.getlip_during_init() + "\"");
        stringBuffer.append(" LISM_failed=\"" + portCounts.getlism_failed() + "\"");
        stringBuffer.append(" LOF_timeout=\"" + portCounts.getlof_timeout() + "\"");
        stringBuffer.append(" LOF_timeout_els=\"" + portCounts.getlof_timeout_els() + "\"");
        stringBuffer.append(" Loop_init_failed=\"" + portCounts.getloop_init_failed() + "\"");
        stringBuffer.append(" OPN_returned=\"" + portCounts.getopn_returned() + "\"");
        stringBuffer.append(" Retry_LIP=\"" + portCounts.getretry_lip() + "\"");
        stringBuffer.append(" Smth_ovrflw_err_cnt=\"" + portCounts.getsmth_ovrflw_err_cnt() + "\"");
        stringBuffer.append("/>\n");
        return stringBuffer;
    }

    private StringBuffer addPhysicalPackage(StringBuffer stringBuffer) {
        stringBuffer.append("<PhysicalPackage");
        stringBuffer.append(" Tag=\"" + this.systemName + "\"");
        stringBuffer.append(" Name=\"Sun StorEdge network FC switch\"");
        stringBuffer.append(" CreationClassName=\"StorAdeSwitch_PhysicalPackage\"");
        stringBuffer.append(" SerialNumber=\"-\"");
        stringBuffer.append(" Removable=\"true\"");
        stringBuffer.append(" Replaceable=\"true\"");
        stringBuffer.append(" HotSwappable=\"true\"");
        stringBuffer.append(" Manufacturer=\"Sun StorEdge network FC switch\"");
        stringBuffer.append(">");
        stringBuffer.append("</PhysicalPackage>");
        return stringBuffer;
    }

    private String convertToCIMStatus(String string) {
        String string2 = "Unknown";
        try {
            if (string.equalsIgnoreCase("online")) {
                string2 = "OK";
            } else if (string.equalsIgnoreCase("offline")) {
                string2 = "OK";
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    private String convertToCIMAvailability(String string) {
        int n = 2;
        try {
            if (string.equalsIgnoreCase("online")) {
                n = 3;
            } else if (string.equalsIgnoreCase("offline")) {
                n = 8;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String string2 = Integer.toString(n);
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage Sanbox <ip>");
            System.exit(1);
        }
        Sanbox sanbox = new Sanbox(stringArray[0]);
        System.out.println(sanbox.getXMLReport());
    }
}

